/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.crafting;

import mchorse.mappet.api.conditions.Checker;
import mchorse.mappet.api.triggers.Trigger;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.utils.InventoryUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.util.INBTSerializable;

public class CraftingRecipe
implements INBTSerializable<NBTTagCompound> {
    public String title = "";
    public String description = "";
    public NonNullList<ItemStack> input = NonNullList.func_191196_a();
    public NonNullList<ItemStack> output = NonNullList.func_191196_a();
    public Checker visible = new Checker(true);
    public int hotkey = -1;
    public Trigger trigger = new Trigger();
    public boolean ignoreNBT = true;

    public boolean isAvailable(EntityPlayer player) {
        return this.visible.check(new DataContext((Entity)player));
    }

    public boolean craft(EntityPlayer player) {
        return this.craft(player, null);
    }

    public boolean craft(EntityPlayer player, DataContext context) {
        if (context == null) {
            context = new DataContext((Entity)player);
        }
        if (!this.isPlayerHasAllItems(player)) {
            return false;
        }
        for (ItemStack stack : this.input) {
            NBTTagCompound tagCompound = this.ignoreNBT ? null : stack.func_77978_p();
            player.field_71071_by.func_174925_a(stack.func_77973_b(), -1, stack.func_190916_E(), tagCompound);
        }
        for (ItemStack stack : this.output) {
            this.addOrDrop(player, stack.func_77946_l());
        }
        this.trigger.trigger(context);
        return true;
    }

    public boolean isPlayerHasAllItems(EntityPlayer player) {
        for (ItemStack stack : this.input) {
            if (InventoryUtils.countItems(player, stack, true, this.ignoreNBT) >= stack.func_190916_E()) continue;
            return false;
        }
        return true;
    }

    private void addOrDrop(EntityPlayer player, ItemStack stack) {
        boolean flag = player.field_71071_by.func_70441_a(stack);
        if (flag) {
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, 1.0f);
            player.field_71069_bz.func_75142_b();
        } else {
            EntityItem entityitem = player.func_71019_a(stack, false);
            if (entityitem != null) {
                entityitem.func_174868_q();
                entityitem.func_145797_a(player.func_70005_c_());
            }
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList input = this.serializeList(this.input);
        NBTTagList output = this.serializeList(this.output);
        if (!this.title.isEmpty()) {
            tag.func_74778_a("Title", this.title);
        }
        if (!this.description.isEmpty()) {
            tag.func_74778_a("Description", this.description);
        }
        if (input != null) {
            tag.func_74782_a("Input", (NBTBase)input);
        }
        if (output != null) {
            tag.func_74782_a("Output", (NBTBase)output);
        }
        tag.func_74782_a("Visible", this.visible.serializeNBT());
        NBTTagCompound trigger = this.trigger.serializeNBT();
        if (trigger.func_186856_d() > 0) {
            tag.func_74782_a("Trigger", (NBTBase)trigger);
        }
        if (this.hotkey > 0) {
            tag.func_74768_a("Hotkey", this.hotkey);
        }
        tag.func_74757_a("IgnoreNBT", this.ignoreNBT);
        return tag;
    }

    private NBTTagList serializeList(NonNullList<ItemStack> list) {
        NBTTagList tagList = new NBTTagList();
        for (ItemStack stack : list) {
            if (stack.func_190926_b()) continue;
            tagList.func_74742_a((NBTBase)stack.serializeNBT());
        }
        return tagList.func_74745_c() == 0 ? null : tagList;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Title")) {
            this.title = tag.func_74779_i("Title");
        }
        if (tag.func_74764_b("Description")) {
            this.description = tag.func_74779_i("Description");
        }
        if (tag.func_74764_b("Input")) {
            this.deserializeList(this.input, tag.func_150295_c("Input", 10));
        }
        if (tag.func_74764_b("Output")) {
            this.deserializeList(this.output, tag.func_150295_c("Output", 10));
        }
        if (tag.func_74764_b("Visible")) {
            this.visible.deserializeNBT(tag.func_74781_a("Visible"));
        }
        if (tag.func_74764_b("Trigger")) {
            this.trigger.deserializeNBT(tag.func_74775_l("Trigger"));
        }
        if (tag.func_74764_b("Hotkey")) {
            this.hotkey = tag.func_74762_e("Hotkey");
        }
        if (tag.func_74764_b("IgnoreNBT")) {
            this.ignoreNBT = tag.func_74767_n("IgnoreNBT");
        }
    }

    private void deserializeList(NonNullList<ItemStack> list, NBTTagList tagList) {
        list.clear();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound compound = tagList.func_150305_b(i);
            ItemStack stack = new ItemStack(compound);
            if (stack.func_190926_b()) continue;
            list.add((Object)stack);
        }
    }
}

