/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.conditions.blocks;

import mchorse.mappet.api.conditions.blocks.TargetConditionBlock;
import mchorse.mappet.api.states.States;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.api.utils.TargetMode;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mappet.capabilities.character.ICharacter;
import mchorse.mappet.utils.EnumUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class QuestConditionBlock
extends TargetConditionBlock {
    public QuestCheck quest = QuestCheck.COMPLETED;

    @Override
    public boolean evaluateBlock(DataContext context) {
        if (this.target.mode == TargetMode.GLOBAL) {
            States states = this.target.getStates(context);
            if (this.quest == QuestCheck.ABSENT) {
                return !states.wasQuestCompleted(this.id) && this.hasServerInProgress(context);
            }
            if (this.quest == QuestCheck.PRESENT) {
                return this.hasServerInProgress(context);
            }
            return states.wasQuestCompleted(this.id);
        }
        ICharacter character = this.target.getCharacter(context);
        if (character != null) {
            if (this.quest == QuestCheck.ABSENT) {
                return !character.getStates().wasQuestCompleted(this.id) && !character.getQuests().has(this.id);
            }
            if (this.quest == QuestCheck.PRESENT) {
                return character.getQuests().has(this.id);
            }
            return character.getStates().wasQuestCompleted(this.id);
        }
        return false;
    }

    private boolean hasServerInProgress(DataContext context) {
        for (EntityPlayer player : context.server.func_184103_al().func_181057_v()) {
            if (!Character.get(player).getQuests().has(this.id)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected TargetMode getDefaultTarget() {
        return TargetMode.SUBJECT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String stringify() {
        if (this.quest == QuestCheck.ABSENT) {
            return I18n.func_135052_a((String)"mappet.gui.conditions.quest.is_absent", (Object[])new Object[]{this.id});
        }
        if (this.quest == QuestCheck.PRESENT) {
            return I18n.func_135052_a((String)"mappet.gui.conditions.quest.is_present", (Object[])new Object[]{this.id});
        }
        return I18n.func_135052_a((String)"mappet.gui.conditions.quest.is_completed", (Object[])new Object[]{this.id});
    }

    @Override
    public void serializeNBT(NBTTagCompound tag) {
        super.serializeNBT(tag);
        tag.func_74768_a("Quest", this.quest.ordinal());
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        this.quest = EnumUtils.getValue(tag.func_74762_e("Quest"), QuestCheck.values(), QuestCheck.COMPLETED);
    }

    public static enum QuestCheck {
        ABSENT,
        PRESENT,
        COMPLETED;

    }
}

