/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mchorse.mappet.CommonProxy;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.huds.HUDScene;
import mchorse.mappet.api.quests.Quest;
import mchorse.mappet.api.quests.Quests;
import mchorse.mappet.api.scripts.code.entities.ScriptEntity;
import mchorse.mappet.api.scripts.code.entities.ScriptEntityItem;
import mchorse.mappet.api.scripts.code.entities.ScriptPlayer;
import mchorse.mappet.api.scripts.code.entities.ai.repeatingCommand.EntityAIRepeatingCommand;
import mchorse.mappet.api.scripts.code.entities.ai.repeatingCommand.RepeatingCommandDataStorage;
import mchorse.mappet.api.scripts.code.entities.ai.rotations.EntityAIRotations;
import mchorse.mappet.api.scripts.code.entities.ai.rotations.RotationDataStorage;
import mchorse.mappet.api.scripts.code.items.ScriptInventory;
import mchorse.mappet.api.scripts.code.items.ScriptItemStack;
import mchorse.mappet.api.scripts.user.data.ScriptVector;
import mchorse.mappet.api.scripts.user.entities.IScriptEntity;
import mchorse.mappet.api.triggers.Trigger;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.api.utils.IExecutable;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mappet.capabilities.character.CharacterProvider;
import mchorse.mappet.capabilities.character.ICharacter;
import mchorse.mappet.client.KeyboardHandler;
import mchorse.mappet.client.RenderingHandler;
import mchorse.mappet.client.SoundPack;
import mchorse.mappet.commands.data.CommandDataClear;
import mchorse.mappet.entities.EntityNpc;
import mchorse.mappet.entities.utils.MappetNpcRespawnManager;
import mchorse.mappet.events.StateChangedEvent;
import mchorse.mappet.libs.org.reflections.Reflections;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.events.PacketEventHotkeys;
import mchorse.mappet.network.common.huds.PacketHUDScene;
import mchorse.mappet.network.common.npc.PacketNpcJump;
import mchorse.mappet.network.common.quests.PacketQuest;
import mchorse.mappet.network.common.quests.PacketQuests;
import mchorse.mappet.network.common.scripts.PacketClick;
import mchorse.mappet.utils.RunnableExecutionFork;
import mchorse.mclib.utils.ReflectionUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.command.EntitySelector;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandler {
    public static final ResourceLocation CAPABILITY = new ResourceLocation("mappet", "character");
    private static Boolean isMohist;
    private Set<EntityPlayer> playersToCheck = new HashSet<EntityPlayer>();
    private List<IExecutable> executables = new ArrayList<IExecutable>();
    private List<IExecutable> secondList = new ArrayList<IExecutable>();
    private DataContext context;
    private Set<UUID> loggedInPlayers = new HashSet<UUID>();
    private static Set<Class<? extends Event>> registeredEvents;
    private int skinCounter;

    private static boolean isMohist() {
        if (isMohist != null) {
            return isMohist;
        }
        try {
            Class.forName("com.mohistmc.MohistMC");
            isMohist = true;
        }
        catch (Exception e) {
            isMohist = false;
        }
        return isMohist;
    }

    public List<String> getIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (IExecutable executable : this.executables) {
            ids.add(executable.getId());
        }
        return Lists.newArrayList((Iterable)Sets.newLinkedHashSet(ids));
    }

    public void addExecutables(List<IExecutable> executionForks) {
        this.executables.addAll(executionForks);
    }

    public void addExecutable(IExecutable executable) {
        this.executables.add(executable);
    }

    public int removeExecutables(String id) {
        int size = this.executables.size();
        this.executables.removeIf(e -> e.getId().equals(id));
        return size - this.executables.size();
    }

    public void reset() {
        this.playersToCheck.clear();
        this.executables.clear();
        this.secondList.clear();
        this.context = null;
    }

    public void trigger(Event event, Trigger trigger, DataContext context) {
        context.getValues().put("event", event);
        trigger.trigger(context);
        if (event.isCancelable() && context.isCanceled()) {
            if (event instanceof LivingEquipmentChangeEvent || event instanceof TickEvent.PlayerTickEvent) {
                return;
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onAnyEvent(Event event) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null || Mappet.settings == null) {
            return;
        }
        if (!((Boolean)Mappet.enableForgeTriggers.get()).booleanValue()) {
            return;
        }
        if (event instanceof TickEvent && ((TickEvent)event).side == Side.CLIENT) {
            return;
        }
        if (event instanceof EntityEvent && (((EntityEvent)event).getEntity() == null || ((EntityEvent)event).getEntity().field_70170_p.field_72995_K)) {
            return;
        }
        if (event instanceof WorldEvent && ((WorldEvent)event).getWorld().field_72995_K) {
            return;
        }
        String name = EventHandler.getEventClassName(event.getClass());
        Trigger trigger = Mappet.settings.registeredForgeTriggers.get(name);
        if (trigger == null || trigger.isEmpty()) {
            return;
        }
        this.trigger(event, trigger, new DataContext(server));
    }

    public static String getEventClassName(Class<? extends Event> clazz) {
        return clazz.getName().replace("$", ".");
    }

    public static Set<Class<? extends Event>> getRegisteredEvents() {
        if (((Boolean)Mappet.enableForgeTriggers.get()).booleanValue() && (registeredEvents == null || registeredEvents.isEmpty())) {
            Reflections reflections = new Reflections(new Object[0]);
            registeredEvents = reflections.getSubTypesOf(Event.class).stream().filter(clazz -> !FMLNetworkEvent.class.isAssignableFrom((Class<?>)clazz)).filter(clazz -> clazz != Event.class).filter(clazz -> clazz != CommandEvent.class).filter(clazz -> !TextureStitchEvent.class.isAssignableFrom((Class<?>)clazz)).collect(Collectors.toSet());
        }
        return registeredEvents;
    }

    @SubscribeEvent
    public void onPlayerChat(ServerChatEvent event) {
        if (!Mappet.settings.playerChat.isEmpty()) {
            DataContext context = new DataContext((Entity)event.getPlayer()).set("message", event.getMessage());
            this.trigger((Event)event, Mappet.settings.playerChat, context);
        }
    }

    @SubscribeEvent
    public void onPlayerBreakBlock(BlockEvent.BreakEvent event) {
        if (!Mappet.settings.blockBreak.isEmpty()) {
            IBlockState state = event.getState();
            DataContext context = new DataContext((Entity)event.getPlayer()).set("block", state.func_177230_c().getRegistryName().toString()).set("meta", state.func_177230_c().func_176201_c(state)).set("x", event.getPos().func_177958_n()).set("y", event.getPos().func_177956_o()).set("z", event.getPos().func_177952_p());
            this.trigger((Event)event, Mappet.settings.blockBreak, context);
        }
    }

    @SubscribeEvent
    public void onPlayerPlaceBlock(BlockEvent.PlaceEvent event) {
        if (!Mappet.settings.blockPlace.isEmpty()) {
            IBlockState state = event.getPlacedBlock();
            DataContext context = new DataContext((Entity)event.getPlayer()).set("block", state.func_177230_c().getRegistryName().toString()).set("meta", state.func_177230_c().func_176201_c(state)).set("x", event.getPos().func_177958_n()).set("y", event.getPos().func_177956_o()).set("z", event.getPos().func_177952_p());
            this.trigger((Event)event, Mappet.settings.blockPlace, context);
        }
    }

    @SubscribeEvent
    public void onEntityHurt(LivingDamageEvent event) {
        EntityLivingBase attacker;
        DamageSource source = event.getSource();
        EntityLivingBase entityLivingBase = attacker = source.func_76346_g() instanceof EntityLivingBase ? (EntityLivingBase)source.func_76346_g() : null;
        if (Mappet.settings == null || Mappet.settings.entityDamaged == null || Mappet.settings.entityDamaged.isEmpty()) {
            return;
        }
        DataContext context = new DataContext((Entity)event.getEntityLiving(), source.func_76346_g()).set("damage", event.getAmount());
        context.getValues().put("damageType", source.func_76355_l());
        context.getValues().put("attacker", ScriptEntity.create((Entity)attacker));
        this.trigger((Event)event, Mappet.settings.entityDamaged, context);
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        DamageSource source = event.getSource();
        if (event.getEntity() == null || event.getEntity().field_70170_p.field_72995_K || Mappet.settings == null || Mappet.settings.entityAttacked == null || Mappet.settings.entityAttacked.isEmpty()) {
            return;
        }
        DataContext context = new DataContext((Entity)event.getEntityLiving(), source.func_76346_g()).set("damage", event.getAmount());
        context.getValues().put("damageType", source.func_76355_l());
        this.trigger((Event)event, Mappet.settings.entityAttacked, context);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerOpenOrCloseContainer(PlayerContainerEvent event) {
        Trigger trigger = event instanceof PlayerContainerEvent.Close ? Mappet.settings.playerCloseContainer : Mappet.settings.playerOpenContainer;
        this.playersToCheck.add(event.getEntityPlayer());
        if (trigger.isEmpty()) {
            return;
        }
        Container container = event.getContainer();
        DataContext context = new DataContext((Entity)event.getEntityPlayer());
        InventoryPlayer inventory = null;
        if (container instanceof ContainerChest) {
            ContainerChest chest = (ContainerChest)container;
            if (chest.func_85151_d() instanceof TileEntity) {
                BlockPos pos = ((TileEntity)chest.func_85151_d()).func_174877_v();
                context.set("x", pos.func_177958_n());
                context.set("y", pos.func_177956_o());
                context.set("z", pos.func_177952_p());
            }
            inventory = chest.func_85151_d();
        } else if (container instanceof ContainerPlayer) {
            inventory = event.getEntityPlayer().field_71071_by;
        } else {
            Field[] fields;
            for (Field field : fields = container.getClass().getDeclaredFields()) {
                if (!field.getType().isAssignableFrom(IInventory.class)) continue;
                try {
                    field.setAccessible(true);
                    inventory = (IInventory)field.get(container);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (inventory != null) {
            context.getValues().put("inventory", new ScriptInventory((IInventory)inventory));
        }
        trigger.trigger(context);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        if (!event.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        Dispatcher.sendToServer(new PacketClick(EnumHand.MAIN_HAND));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        if (!event.getEntityPlayer().field_70170_p.field_72995_K || event.getHand() == EnumHand.OFF_HAND) {
            return;
        }
        Dispatcher.sendToServer(new PacketClick(EnumHand.OFF_HAND));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerRightClickItem(PlayerInteractEvent.RightClickItem event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K || Mappet.settings.playerItemInteract.isEmpty()) {
            return;
        }
        DataContext context = new DataContext((Entity)player).set("x", event.getPos().func_177958_n()).set("y", event.getPos().func_177956_o()).set("z", event.getPos().func_177952_p()).set("hand", event.getHand() == EnumHand.MAIN_HAND ? "main" : "off");
        this.trigger((Event)event, Mappet.settings.playerItemInteract, context);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K || Mappet.settings.blockClick.isEmpty()) {
            return;
        }
        DataContext context = new DataContext((Entity)player).set("x", event.getPos().func_177958_n()).set("y", event.getPos().func_177956_o()).set("z", event.getPos().func_177952_p()).set("hand", event.getHand() == EnumHand.MAIN_HAND ? "main" : "off");
        this.trigger((Event)event, Mappet.settings.blockClick, context);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K || Mappet.settings.blockInteract.isEmpty()) {
            return;
        }
        IBlockState state = event.getWorld().func_180495_p(event.getPos());
        DataContext context = new DataContext((Entity)player).set("block", state.func_177230_c().getRegistryName().toString()).set("meta", state.func_177230_c().func_176201_c(state)).set("x", event.getPos().func_177958_n()).set("y", event.getPos().func_177956_o()).set("z", event.getPos().func_177952_p()).set("hand", event.getHand() == EnumHand.MAIN_HAND ? "main" : "off");
        this.trigger((Event)event, Mappet.settings.blockInteract, context);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K || Mappet.settings.playerEntityInteract.isEmpty()) {
            return;
        }
        DataContext context = new DataContext((Entity)player, event.getTarget()).set("hand", event.getHand() == EnumHand.MAIN_HAND ? "main" : "off");
        this.trigger((Event)event, Mappet.settings.playerEntityInteract, context);
    }

    @SubscribeEvent
    public void attachPlayerCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(CAPABILITY, (ICapabilityProvider)new CharacterProvider());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerClientLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        if (((Boolean)Mappet.loadCustomSoundsOnLogin.get()).booleanValue()) {
            ScriptPlayer scriptPlayer = new ScriptPlayer(player);
            for (String sound : SoundPack.getCustomSoundEvents()) {
                scriptPlayer.playStaticSound(sound, 1.0E-9f, 1.0f);
                CommonProxy.eventHandler.addExecutable(new RunnableExecutionFork(1, () -> scriptPlayer.stopSound(sound)));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        Character character = Character.get((EntityPlayer)player);
        Instant lastClear = Mappet.data.getLastClear();
        if (character != null) {
            if (character.getLastClear().isBefore(lastClear)) {
                CommandDataClear.clear(player, Mappet.data.getLastInventory());
                character.updateLastClear(lastClear);
            }
            this.syncData(player, character);
        }
        Map<String, List<HUDScene>> displayedHUDs = character.getDisplayedHUDs();
        for (Map.Entry<String, List<HUDScene>> entry : displayedHUDs.entrySet()) {
            String id = entry.getKey();
            List<HUDScene> scenes = entry.getValue();
            for (HUDScene hUDScene : scenes) {
                Dispatcher.sendTo(new PacketHUDScene(id, hUDScene.serializeNBT()), player);
            }
        }
        for (EntityPlayerMP p : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            Character c = Character.get((EntityPlayer)p);
            if (c == null) continue;
            Map<String, List<HUDScene>> displayed = c.getDisplayedHUDs();
            for (Map.Entry entry : displayed.entrySet()) {
                String id = (String)entry.getKey();
                List scenes = (List)entry.getValue();
                for (HUDScene scene : scenes) {
                    if (!scene.global) continue;
                    Dispatcher.sendTo(new PacketHUDScene(id, scene.serializeNBT()), player);
                }
            }
        }
        if (!Mappet.settings.playerLogIn.isEmpty()) {
            DataContext context = new DataContext((Entity)event.player);
            Mappet.settings.playerLogIn.trigger(context);
        }
        this.loggedInPlayers.add(player.func_110124_au());
    }

    @SubscribeEvent
    public void onPlayerLogsOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!Mappet.settings.playerLogOut.isEmpty()) {
            DataContext context = new DataContext((Entity)event.player);
            Mappet.settings.playerLogOut.trigger(context);
        }
        this.loggedInPlayers.remove(event.player.func_110124_au());
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer player = event.getEntityPlayer();
        Character character = Character.get(player);
        Character oldCharacter = Character.get(event.getOriginal());
        if (!EventHandler.isMohist()) {
            character.copy(oldCharacter, player);
        }
    }

    @SubscribeEvent
    public void onPlayerSpawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            Character character = Character.get((EntityPlayer)player);
            this.syncData(player, character);
            if (this.loggedInPlayers.contains(player.func_110124_au()) && !Mappet.settings.playerRespawn.isEmpty()) {
                Mappet.settings.playerRespawn.trigger(new DataContext((Entity)player));
            }
        }
    }

    private void syncData(EntityPlayerMP player, ICharacter character) {
        if (!character.getQuests().quests.isEmpty()) {
            character.getQuests().initiate((EntityPlayer)player);
            Dispatcher.sendTo(new PacketQuests(character.getQuests()), player);
        }
        if (!Mappet.settings.hotkeys.hotkeys.isEmpty()) {
            Dispatcher.sendTo(new PacketEventHotkeys(Mappet.settings), player);
        }
    }

    @SubscribeEvent
    public void onPlayerPickUp(EntityItemPickupEvent event) {
        this.playersToCheck.add(event.getEntityPlayer());
        if (!Mappet.settings.playerItemPickup.isEmpty()) {
            DataContext context = new DataContext((Entity)event.getEntityPlayer());
            context.getValues().put("item", ScriptItemStack.create(event.getItem().func_92059_d()));
            context.getValues().put("entityItem", ScriptEntityItem.create((Entity)event.getItem()));
            this.trigger((Event)event, Mappet.settings.playerItemPickup, context);
        }
    }

    @SubscribeEvent
    public void onPlayerToss(ItemTossEvent event) {
        if (event.getPlayer().field_70170_p.field_72995_K) {
            return;
        }
        if (!Mappet.settings.playerItemToss.isEmpty()) {
            DataContext context = new DataContext((Entity)event.getPlayer());
            context.getValues().put("entityItem", ScriptEntityItem.create((Entity)event.getEntityItem()));
            this.trigger((Event)event, Mappet.settings.playerItemToss, context);
        }
    }

    @SubscribeEvent
    public void onMobKilled(LivingDeathEvent event) {
        EntityPlayer player;
        Character character;
        Trigger trigger;
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        Entity source = event.getSource().func_76346_g();
        String damageType = event.getSource().func_76355_l();
        Trigger trigger2 = trigger = event.getEntity() instanceof EntityPlayer ? Mappet.settings.playerDeath : Mappet.settings.entityDeath;
        if (!trigger.isEmpty()) {
            DataContext context = new DataContext((Entity)event.getEntityLiving(), source);
            context.getValues().put("damageType", damageType);
            if (source != null) {
                context.getValues().put("killer", ScriptEntity.create(source));
            }
            EntityLivingBase thrower = null;
            if (source instanceof EntityThrowable) {
                thrower = ((EntityThrowable)event.getEntity()).func_85052_h();
            }
            if (thrower != null) {
                context.getValues().put("thrower", ScriptEntity.create((Entity)thrower));
            }
            this.trigger((Event)event, trigger, context);
        }
        if (source instanceof EntityPlayer && (character = Character.get(player = (EntityPlayer)source)) != null) {
            for (Quest quest : character.getQuests().quests.values()) {
                quest.mobWasKilled(player, event.getEntity());
            }
            this.playersToCheck.add(player);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityLiving) {
            RepeatingCommandDataStorage repeatingCommandDataStorage;
            List<RepeatingCommandDataStorage.RepeatingCommandData> repeatingCommandDataList;
            EntityLiving entityLiving = (EntityLiving)event.getEntity();
            RotationDataStorage rotationDataStorage = RotationDataStorage.getRotationDataStorage(event.getWorld());
            RotationDataStorage.RotationData rotationData = rotationDataStorage.getRotationData(entityLiving.func_110124_au());
            if (rotationData != null) {
                float yaw = rotationData.yaw;
                float pitch = rotationData.pitch;
                float yawHead = rotationData.yawHead;
                entityLiving.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIRotations(entityLiving, yaw, pitch, yawHead, 1.0f));
            }
            if ((repeatingCommandDataList = (repeatingCommandDataStorage = RepeatingCommandDataStorage.getRepeatingCommandDataStorage(event.getWorld())).getRepeatingCommandData(entityLiving.func_110124_au())) != null) {
                for (RepeatingCommandDataStorage.RepeatingCommandData repeatingCommandData : repeatingCommandDataList) {
                    String command = repeatingCommandData.command;
                    int frequency = repeatingCommandData.frequency;
                    entityLiving.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIRepeatingCommand((Entity)entityLiving, command, frequency));
                }
            }
        }
    }

    List<Entity> getAllEntities() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        try {
            for (Entity entity : EntitySelector.func_179656_b((ICommandSender)FMLCommonHandler.instance().getMinecraftServerInstance(), (String)"@e", Entity.class)) {
                entities.add(entity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entities;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        for (Entity entity : this.getAllEntities()) {
            IScriptEntity scriptEntity;
            if (entity == null) continue;
            if (entity.getEntityData().func_74767_n("positionLocked")) {
                scriptEntity = ScriptEntity.create(entity);
                scriptEntity.setPosition(entity.getEntityData().func_74769_h("lockX"), entity.getEntityData().func_74769_h("lockY"), entity.getEntityData().func_74769_h("lockZ"));
                scriptEntity.setMotion(0.0, 0.0, 0.0);
            }
            if (!entity.getEntityData().func_74767_n("rotationLocked")) continue;
            scriptEntity = ScriptEntity.create(entity);
            scriptEntity.setRotations(entity.getEntityData().func_74760_g("lockPitch"), entity.getEntityData().func_74760_g("lockYaw"), entity.getEntityData().func_74760_g("lockYawHead"));
        }
        for (EntityPlayer player : this.playersToCheck) {
            Character character = Character.get(player);
            if (character == null) continue;
            Quests quests = character.getQuests();
            Iterator<Map.Entry<String, Quest>> it = quests.quests.entrySet().iterator();
            quests.iterating = true;
            while (it.hasNext()) {
                Map.Entry<String, Quest> entry = it.next();
                Quest quest = entry.getValue();
                if (quest.instant && quest.rewardIfComplete(player)) {
                    it.remove();
                    Dispatcher.sendTo(new PacketQuest(entry.getKey(), null), (EntityPlayerMP)player);
                    continue;
                }
                Dispatcher.sendTo(new PacketQuest(entry.getKey(), entry.getValue()), (EntityPlayerMP)player);
            }
            quests.flush(player);
        }
        this.playersToCheck.clear();
        if (!this.executables.isEmpty()) {
            this.secondList.addAll(this.executables);
            this.executables.clear();
            this.secondList.removeIf(IExecutable::update);
            this.secondList.addAll(this.executables);
            this.executables.clear();
            this.executables.addAll(this.secondList);
            this.secondList.clear();
        }
        if (!Mappet.settings.serverTick.isEmpty()) {
            if (this.context == null) {
                this.context = new DataContext(FMLCommonHandler.instance().getMinecraftServerInstance());
            }
            Mappet.settings.serverTick.trigger(this.context);
            this.context.cancel(false);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Character character = Character.get(event.player);
        if (character != null && !event.player.field_70170_p.field_72995_K) {
            character.getPositionCache().updatePlayer(event.player);
            character.updateDisplayedHUDsList();
        }
        if (event.player.field_70170_p.field_72995_K && event.player == Minecraft.func_71410_x().field_71439_g) {
            this.onPlayerTickClient(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onPlayerTickClient(TickEvent.PlayerTickEvent event) {
        RenderingHandler.update();
        KeyboardHandler.updateHeldKeys();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (this.skinCounter >= 50) {
                this.updateSkins();
                this.skinCounter = 0;
            }
            ++this.skinCounter;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSkins() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return;
        }
        Map map = ReflectionUtils.getTextures((TextureManager)mc.field_71446_o);
        for (EntityPlayer player : mc.field_71441_e.field_73010_i) {
            if (player instanceof EntityOtherPlayerMP) {
                map.put(AbstractClientPlayer.func_110311_f((String)player.func_70005_c_()), map.get(((EntityOtherPlayerMP)player).func_110306_p()));
                continue;
            }
            if (!(player instanceof EntityPlayerSP)) continue;
            map.put(AbstractClientPlayer.func_110311_f((String)player.func_70005_c_()), map.get(((EntityPlayerSP)player).func_110306_p()));
        }
    }

    @SubscribeEvent
    public void onStateChange(StateChangedEvent event) {
        Trigger trigger = Mappet.settings.stateChanged;
        if (!trigger.isEmpty()) {
            this.handleStateChangedEvent(event, trigger);
        }
        for (EntityPlayer player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            Character character = Character.get(player);
            if (character == null || !event.isGlobal() && character.getStates() != event.states) continue;
            int i = 0;
            for (Quest quest : character.getQuests().quests.values()) {
                i += quest.stateWasUpdated(player) ? 1 : 0;
            }
            if (i <= 0) continue;
            this.playersToCheck.add(player);
        }
    }

    private void handleStateChangedEvent(StateChangedEvent event, Trigger trigger) {
        if (event.isGlobal()) {
            this.handleGlobalStateChangedEvent(event, trigger);
        } else {
            this.handlePlayerStateChangedEvent(event, trigger);
            this.handleNpcStateChangedEvent(event, trigger);
        }
    }

    private void handleGlobalStateChangedEvent(StateChangedEvent event, Trigger trigger) {
        this.context = new DataContext(FMLCommonHandler.instance().getMinecraftServerInstance());
        this.setStateChangedEventValues(this.context, event);
        trigger.trigger(this.context);
    }

    private void handlePlayerStateChangedEvent(StateChangedEvent event, Trigger trigger) {
        for (EntityPlayer player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            Character character = Character.get(player);
            if (character == null || character.getStates() != event.states) continue;
            this.context = new DataContext((Entity)player);
            this.setStateChangedEventValues(this.context, event);
            this.context.getValues().put("entity", ScriptEntity.create((Entity)player));
            trigger.trigger(this.context);
        }
    }

    private void handleNpcStateChangedEvent(StateChangedEvent event, Trigger trigger) {
        for (EntityNpc npc : this.getAllNpcs()) {
            if (npc == null || npc.getStates() != event.states) continue;
            this.context = new DataContext((Entity)npc);
            this.setStateChangedEventValues(this.context, event);
            this.context.getValues().put("entity", ScriptEntity.create((Entity)npc));
            trigger.trigger(this.context);
        }
    }

    private void setStateChangedEventValues(DataContext context, StateChangedEvent event) {
        context.getValues().put("key", event.key);
        context.getValues().put("current", event.current);
        context.getValues().put("previous", event.previous);
    }

    private List<EntityNpc> getAllNpcs() {
        ArrayList<EntityNpc> npcs = new ArrayList<EntityNpc>();
        try {
            for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                npcs.addAll(world.field_72996_f.stream().filter(entity -> entity instanceof EntityNpc).map(entity -> (EntityNpc)((Object)entity)).collect(Collectors.toList()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return npcs;
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        MappetNpcRespawnManager respawnManager = MappetNpcRespawnManager.get(event.world);
        respawnManager.onTick();
    }

    @SubscribeEvent
    public void onLivingKnockBack(LivingKnockBackEvent event) {
        EntityLivingBase target = event.getEntityLiving();
        Entity attacker = event.getAttacker();
        if (target != null && target.getEntityData().func_74767_n("positionLocked")) {
            event.setCanceled(true);
        }
        if (target.field_70170_p.field_72995_K || Mappet.settings.livingKnockBack.isEmpty()) {
            return;
        }
        DataContext context = new DataContext((Entity)target, attacker).set("strength", event.getStrength()).set("ratioX", event.getRatioX()).set("ratioZ", event.getRatioZ());
        context.getValues().put("attacker", ScriptEntity.create(attacker));
        this.trigger((Event)event, Mappet.settings.livingKnockBack, context);
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        Trigger trigger = Mappet.settings.projectileImpact;
        if (!trigger.isEmpty()) {
            Entity hitEntity = event.getRayTraceResult().field_72308_g;
            DataContext context = new DataContext(event.getEntity(), hitEntity);
            context.getValues().put("pos", new ScriptVector(event.getRayTraceResult().field_72307_f));
            context.getValues().put("projectile", ScriptEntity.create(event.getEntity()));
            if (hitEntity != null && !context.getValues().containsKey("entity")) {
                context.getValues().put("entity", ScriptEntity.create(hitEntity));
            }
            EntityLivingBase thrower = null;
            if (event.getEntity() instanceof EntityThrowable) {
                thrower = ((EntityThrowable)event.getEntity()).func_85052_h();
            }
            if (thrower != null) {
                context.getValues().put("thrower", ScriptEntity.create((Entity)thrower));
            }
            this.trigger((Event)event, trigger, context);
        }
    }

    @SubscribeEvent
    public void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        Trigger trigger = Mappet.settings.onLivingEquipmentChange;
        if (!trigger.isEmpty()) {
            DataContext context = new DataContext(event.getEntity());
            context.getValues().put("item", ScriptItemStack.create(event.getTo()));
            context.getValues().put("previous", ScriptItemStack.create(event.getFrom()));
            if (event.getEntity() instanceof EntityPlayerMP) {
                ScriptPlayer player = new ScriptPlayer((EntityPlayerMP)event.getEntity());
                context.getValues().put("slot", player.getHotbarIndex());
            } else {
                context.getValues().put("slot", event.getSlot().func_188454_b());
            }
            this.trigger((Event)event, trigger, context);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        EntityPlayerSP player;
        if (Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151468_f() && (player = Minecraft.func_71410_x().field_71439_g).func_184218_aH() && player.func_184187_bx() instanceof EntityNpc && ((Boolean)((EntityNpc)player.func_184187_bx()).getState().canBeSteered.get()).booleanValue()) {
            float jumpPower = ((Float)((EntityNpc)player.func_184187_bx()).getState().jumpPower.get()).floatValue();
            Dispatcher.sendToServer(new PacketNpcJump(player.func_184187_bx().func_145782_y(), jumpPower));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerLeashEntity(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack item = player.func_184586_b(event.getHand());
        if (player.field_70170_p.field_72995_K || item.func_77973_b() != Items.field_151058_ca || Mappet.settings.playerEntityLeash.isEmpty()) {
            return;
        }
        Entity target = event.getTarget();
        if (!(target instanceof EntityLiving) || ((EntityLiving)target).func_110167_bD() || !((EntityLiving)target).func_184652_a(player)) {
            return;
        }
        DataContext context = new DataContext((Entity)player, target).set("hand", event.getHand() == EnumHand.MAIN_HAND ? "main" : "off");
        this.trigger((Event)event, Mappet.settings.playerEntityLeash, context);
    }

    static {
        registeredEvents = new HashSet<Class<? extends Event>>();
    }
}

