/*
 * Decompiled with CFR 0.152.
 */
package mchorse.chameleon.metamorph.pose;

import mchorse.chameleon.metamorph.pose.AnimatedTransform;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.Interpolation;
import net.minecraft.nbt.NBTTagCompound;

public class AnimatedPoseTransform
extends AnimatedTransform {
    public static final int FIXED = 0;
    public static final int ANIMATED = 1;
    public float fixed = 1.0f;
    public boolean absoluteBrightness = false;
    public float glow = 0.0f;
    public Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);

    public AnimatedPoseTransform(String name) {
        super(name);
    }

    @Override
    public AnimatedPoseTransform clone() {
        AnimatedPoseTransform item = new AnimatedPoseTransform(this.boneName);
        item.copy(this);
        return item;
    }

    public void copy(AnimatedPoseTransform transform) {
        this.x = transform.x;
        this.y = transform.y;
        this.z = transform.z;
        this.scaleX = transform.scaleX;
        this.scaleY = transform.scaleY;
        this.scaleZ = transform.scaleZ;
        this.rotateX = transform.rotateX;
        this.rotateY = transform.rotateY;
        this.rotateZ = transform.rotateZ;
        this.fixed = transform.fixed;
        this.absoluteBrightness = transform.absoluteBrightness;
        this.glow = transform.glow;
        this.color.copy(transform.color);
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (obj instanceof AnimatedPoseTransform) {
            result = result && this.fixed == ((AnimatedPoseTransform)obj).fixed;
            result = result && this.absoluteBrightness == ((AnimatedPoseTransform)obj).absoluteBrightness;
            result = result && (double)Math.abs(this.glow - ((AnimatedPoseTransform)obj).glow) < 1.0E-4;
            result = result && this.color.equals((Object)((AnimatedPoseTransform)obj).color);
        }
        return result;
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        super.fromNBT(tag);
        if (tag.func_150297_b("F", 1)) {
            float f = this.fixed = tag.func_74767_n("F") ? 1.0f : 0.0f;
        }
        if (tag.func_150297_b("AB", 1)) {
            this.absoluteBrightness = tag.func_74767_n("AB");
        }
        if (tag.func_150297_b("G", 5)) {
            this.glow = tag.func_74760_g("G");
        }
        if (tag.func_150297_b("C", 3)) {
            this.color.set(tag.func_74762_e("C"));
        }
    }

    @Override
    public NBTTagCompound toNBT(NBTTagCompound tag) {
        tag = super.toNBT(tag);
        if (this.fixed != 1.0f) {
            tag.func_74757_a("F", false);
        }
        if (this.absoluteBrightness) {
            tag.func_74757_a("AB", this.absoluteBrightness);
        }
        if ((double)this.glow > 1.0E-4) {
            tag.func_74776_a("G", this.glow);
        }
        if (this.color.getRGBAColor() != -1) {
            tag.func_74768_a("C", this.color.getRGBAColor());
        }
        return tag;
    }

    @Override
    public void interpolate(AnimatedTransform a, AnimatedTransform b, float x, Interpolation interp) {
        AnimatedPoseTransform l;
        super.interpolate(a, b, x, interp);
        float glow = 0.0f;
        float ca = 1.0f;
        float cb = 1.0f;
        float cg = 1.0f;
        float cr = 1.0f;
        if (a instanceof AnimatedPoseTransform) {
            l = (AnimatedPoseTransform)a;
            glow = l.glow;
            cr = l.color.r;
            cg = l.color.g;
            cb = l.color.b;
            ca = l.color.a;
        }
        if (b instanceof AnimatedPoseTransform) {
            l = (AnimatedPoseTransform)b;
            glow = interp.interpolate(glow, l.glow, x);
            cr = interp.interpolate(cr, l.color.r, x);
            cg = interp.interpolate(cg, l.color.g, x);
            cb = interp.interpolate(cb, l.color.b, x);
            ca = interp.interpolate(ca, l.color.a, x);
            this.absoluteBrightness = l.absoluteBrightness;
        } else {
            glow = interp.interpolate(glow, 0.0f, x);
            cr = interp.interpolate(cr, 1.0f, x);
            cg = interp.interpolate(cg, 1.0f, x);
            cb = interp.interpolate(cb, 1.0f, x);
            ca = interp.interpolate(ca, 1.0f, x);
            this.absoluteBrightness = false;
        }
        this.glow = glow;
        this.color.set(cr, cg, cb, ca);
    }
}

