/*
 * Decompiled with CFR 0.152.
 */
package mchorse.chameleon.metamorph.pose;

import java.util.HashMap;
import java.util.Map;
import mchorse.chameleon.metamorph.pose.AnimatedPoseTransform;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class AnimatedPose {
    public final Map<String, AnimatedPoseTransform> bones = new HashMap<String, AnimatedPoseTransform>();
    public float animated = 1.0f;

    public void copy(AnimatedPose pose) {
        for (Map.Entry<String, AnimatedPoseTransform> entry : this.bones.entrySet()) {
            AnimatedPoseTransform transform = pose.bones.get(entry.getKey());
            if (transform == null) continue;
            entry.getValue().copy(transform);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof AnimatedPose) {
            AnimatedPose pose = (AnimatedPose)obj;
            return this.bones.equals(pose.bones) && this.animated == pose.animated;
        }
        return super.equals(obj);
    }

    public AnimatedPose clone() {
        AnimatedPose pose = new AnimatedPose();
        for (Map.Entry<String, AnimatedPoseTransform> entry : this.bones.entrySet()) {
            pose.bones.put(entry.getKey(), entry.getValue().clone());
        }
        pose.animated = this.animated;
        return pose;
    }

    public void fromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Pose")) {
            NBTTagCompound pose = tag.func_74775_l("Pose");
            for (String key : pose.func_150296_c()) {
                AnimatedPoseTransform config = new AnimatedPoseTransform(key);
                config.fromNBT(pose.func_74775_l(key));
                this.bones.put(key, config);
            }
        }
        if (tag.func_74764_b("Animated")) {
            this.animated = tag.func_74767_n("Animated") ? 1.0f : 0.0f;
        }
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound pose = new NBTTagCompound();
        for (Map.Entry<String, AnimatedPoseTransform> entry : this.bones.entrySet()) {
            pose.func_74782_a(entry.getKey(), (NBTBase)entry.getValue().toNBT(null));
        }
        tag.func_74782_a("Pose", (NBTBase)pose);
        if (this.animated != 1.0f) {
            tag.func_74757_a("Animated", false);
        }
        return tag;
    }
}

