/*
 * Decompiled with CFR 0.152.
 */
package mchorse.chameleon.metamorph.editor.render;

import java.util.List;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import mchorse.chameleon.lib.data.model.ModelBone;
import mchorse.chameleon.lib.data.model.ModelCube;
import mchorse.chameleon.lib.data.model.ModelQuad;
import mchorse.chameleon.lib.data.model.ModelVertex;
import mchorse.chameleon.lib.render.IChameleonRenderProcessor;
import mchorse.chameleon.lib.utils.MatrixStack;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ChameleonStencilRenderer
implements IChameleonRenderProcessor {
    private List<String> bones;
    private Vector4f vertex = new Vector4f();
    private float r;
    private float g;
    private float b;
    private float a;

    public void setBones(List<String> bones) {
        this.bones = bones;
    }

    @Override
    public boolean renderBone(BufferBuilder builder, MatrixStack stack, ModelBone bone) {
        this.r = bone.color.r;
        this.g = bone.color.g;
        this.b = bone.color.b;
        this.a = bone.color.a;
        GL11.glStencilFunc((int)519, (int)(this.bones.indexOf(bone.id) + 1), (int)-1);
        builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (ModelCube cube : bone.cubes) {
            this.renderCube(builder, stack, cube);
        }
        Tessellator.func_178181_a().func_78381_a();
        return false;
    }

    private void renderCube(BufferBuilder builder, MatrixStack stack, ModelCube cube) {
        stack.push();
        stack.moveToCubePivot(cube);
        stack.rotateCube(cube);
        stack.moveBackFromCubePivot(cube);
        for (ModelQuad quad : cube.quads) {
            for (ModelVertex vertex : quad.vertices) {
                this.vertex.set((Tuple3f)vertex.position);
                this.vertex.w = 1.0f;
                stack.getModelMatrix().transform((Tuple4f)this.vertex);
                builder.func_181662_b((double)this.vertex.getX(), (double)this.vertex.getY(), (double)this.vertex.getZ()).func_187315_a((double)vertex.uv.x, (double)vertex.uv.y).func_181666_a(this.r, this.g, this.b, this.a).func_181675_d();
            }
        }
        stack.pop();
    }
}

