/*
 * Decompiled with CFR 0.152.
 */
package mchorse.chameleon.metamorph.editor;

import java.util.List;
import mchorse.chameleon.lib.ChameleonModel;
import mchorse.chameleon.lib.render.ChameleonRenderer;
import mchorse.chameleon.lib.utils.MatrixStack;
import mchorse.chameleon.metamorph.ChameleonMorph;
import mchorse.chameleon.metamorph.editor.render.ChameleonHighlightRenderer;
import mchorse.chameleon.metamorph.editor.render.ChameleonStencilRenderer;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.metamorph.client.gui.creative.GuiMorphRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiChameleonModelRenderer
extends GuiMorphRenderer {
    private static final MatrixStack MATRIX_STACK = new MatrixStack();
    private static final ChameleonStencilRenderer STENCIL_RENDERER = new ChameleonStencilRenderer();
    private static final ChameleonHighlightRenderer HIGHLIGHT_RENDERER = new ChameleonHighlightRenderer();
    public String boneName = "";

    public GuiChameleonModelRenderer(Minecraft mc) {
        super(mc);
    }

    protected void drawUserModel(GuiContext context) {
        super.drawUserModel(context);
        this.drawHighlight(context);
        this.tryPicking(context);
    }

    private void drawHighlight(GuiContext context) {
        if (!(this.morph instanceof ChameleonMorph)) {
            return;
        }
        ChameleonModel model = ((ChameleonMorph)this.morph).getModel();
        if (model == null || this.boneName.isEmpty()) {
            return;
        }
        float scale = ((ChameleonMorph)this.morph).scale;
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        GlStateManager.func_179097_i();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)0.0f, (float)0.5f, (float)1.0f, (float)0.33f);
        GlStateManager.func_179114_b((float)(180.0f - (this.customEntity ? this.entityYawBody : 0.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        HIGHLIGHT_RENDERER.setBoneName(this.boneName);
        ChameleonRenderer.processRenderModel(HIGHLIGHT_RENDERER, Tessellator.func_178181_a().func_178180_c(), MATRIX_STACK, model.model);
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
    }

    protected void drawForStencil(GuiContext context) {
        if (!(this.morph instanceof ChameleonMorph)) {
            return;
        }
        ChameleonModel model = ((ChameleonMorph)this.morph).getModel();
        if (model == null) {
            return;
        }
        float scale = ((ChameleonMorph)this.morph).scale;
        if (((ChameleonMorph)this.morph).skin != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(((ChameleonMorph)this.morph).skin);
        }
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179126_j();
        GlStateManager.func_179129_p();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(180.0f - (this.customEntity ? this.entityYawBody : 0.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        STENCIL_RENDERER.setBones(model.getBoneNames());
        ChameleonRenderer.processRenderModel(STENCIL_RENDERER, Tessellator.func_178181_a().func_178180_c(), MATRIX_STACK, model.model);
        GlStateManager.func_179121_F();
        GlStateManager.func_179089_o();
    }

    protected String getStencilValue(int value) {
        ChameleonMorph morph;
        ChameleonModel model;
        if (value == 0) {
            return null;
        }
        --value;
        if (this.morph instanceof ChameleonMorph && (model = (morph = (ChameleonMorph)this.morph).getModel()) != null) {
            List<String> bones = model.getBoneNames();
            if (value >= 0 && value < bones.size()) {
                return bones.get(value);
            }
        }
        return super.getStencilValue(value);
    }
}

