/*
 * Decompiled with CFR 0.152.
 */
package mchorse.chameleon.metamorph;

import java.util.Objects;
import mchorse.chameleon.ClientProxy;
import mchorse.chameleon.animation.ActionPlayback;
import mchorse.chameleon.animation.ActionsConfig;
import mchorse.chameleon.animation.Animator;
import mchorse.chameleon.lib.ChameleonAnimator;
import mchorse.chameleon.lib.ChameleonModel;
import mchorse.chameleon.lib.data.model.Model;
import mchorse.chameleon.lib.data.model.ModelBone;
import mchorse.chameleon.lib.data.model.ModelTransform;
import mchorse.chameleon.lib.render.ChameleonRenderer;
import mchorse.chameleon.metamorph.pose.AnimatedPose;
import mchorse.chameleon.metamorph.pose.AnimatedPoseTransform;
import mchorse.chameleon.metamorph.pose.PoseAnimation;
import mchorse.mclib.client.render.RenderLightmap;
import mchorse.mclib.utils.Interpolations;
import mchorse.mclib.utils.MatrixUtils;
import mchorse.mclib.utils.resources.RLUtils;
import mchorse.metamorph.api.models.IMorphProvider;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.Animation;
import mchorse.metamorph.api.morphs.utils.IAnimationProvider;
import mchorse.metamorph.api.morphs.utils.IMorphGenerator;
import mchorse.metamorph.api.morphs.utils.ISyncableMorph;
import mchorse.metamorph.bodypart.BodyPart;
import mchorse.metamorph.bodypart.BodyPartManager;
import mchorse.metamorph.bodypart.IBodyPartProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ChameleonMorph
extends AbstractMorph
implements IBodyPartProvider,
ISyncableMorph,
IAnimationProvider,
IMorphGenerator {
    public ResourceLocation skin;
    public AnimatedPose pose;
    public ActionsConfig actions = new ActionsConfig();
    public BodyPartManager parts = new BodyPartManager();
    public float scale = 1.0f;
    public float scaleGui = 1.0f;
    private float lastScale = 1.0f;
    public PoseAnimation animation = new PoseAnimation();
    public boolean isActionPlayer;
    public ActionPlayback lastAnimAction;
    private String key;
    @SideOnly(value=Side.CLIENT)
    private Animator animator;
    private boolean updateAnimator = false;
    private long lastUpdate;

    public float getScale(float partialTick) {
        if (this.animation.isInProgress()) {
            return this.animation.interp.interpolate(this.lastScale, this.scale, this.animation.getFactor(partialTick));
        }
        return this.scale;
    }

    @SideOnly(value=Side.CLIENT)
    protected Animator getAnimator() {
        if (this.animator == null) {
            this.animator = new Animator(this);
        }
        return this.animator;
    }

    public void pause(AbstractMorph previous, int offset) {
        this.animation.pause(offset);
        while (previous instanceof IMorphProvider) {
            previous = ((IMorphProvider)previous).getMorph();
        }
        AnimatedPose pose = null;
        if (previous instanceof ChameleonMorph) {
            ChameleonMorph morph = (ChameleonMorph)previous;
            pose = morph.pose;
            if (pose != null) {
                pose = pose.clone();
            }
            this.lastScale = morph.scale;
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && this.isActionPlayer && morph.isActionPlayer) {
                morph.checkAnimator();
                this.lastAnimAction = morph.animator != null && morph.actions.getConfig("animation") != null ? morph.animator.createAction(morph.animator.animation, morph.actions.getConfig("animation").clone(), false) : null;
                if (this.lastAnimAction != null) {
                    this.lastAnimAction.config.tick = (int)((float)this.lastAnimAction.config.tick + morph.animation.getFactor(0.0f) * (float)morph.animation.duration * Math.abs(this.lastAnimAction.config.speed));
                }
            }
        }
        this.animation.last = pose == null ? (previous == null ? this.pose : new AnimatedPose()) : pose;
        this.parts.pause(previous, offset);
        this.updateAnimator = true;
    }

    public boolean isPaused() {
        return this.animation.paused;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public BodyPartManager getBodyPart() {
        return this.parts;
    }

    public boolean canGenerate() {
        return this.animation.isInProgress();
    }

    public AbstractMorph genCurrentMorph(float partialTicks) {
        ChameleonMorph morph = (ChameleonMorph)this.copy();
        morph.pose = this.getCurrentPose(partialTicks);
        morph.animation.duration = this.animation.progress;
        morph.parts.parts.clear();
        for (BodyPart part : this.parts.parts) {
            morph.parts.parts.add(part.genCurrentBodyPart((AbstractMorph)this, partialTicks));
        }
        return morph.copy();
    }

    public String getKey() {
        if (this.key == null) {
            this.key = this.name.replaceAll("^chameleon\\.", "");
        }
        return this.key;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateAnimator() {
        this.updateAnimator = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOnScreen(EntityPlayer target, int x, int y, float scale, float alpha) {
        GlStateManager.func_179126_j();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)(scale *= this.scaleGui), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)45.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderHelper.func_74519_b();
        this.renderModel((EntityLivingBase)target, 0.0f);
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179097_i();
    }

    @SideOnly(value=Side.CLIENT)
    public void render(EntityLivingBase target, double x, double y, double z, float entityYaw, float partialTicks) {
        float scale = this.getScale(partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        boolean captured = MatrixUtils.captureMatrix();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        float renderYawOffset = Interpolations.lerp((float)target.field_70760_ar, (float)target.field_70761_aq, (float)partialTicks);
        GlStateManager.func_179114_b((float)(-renderYawOffset + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderModel(target, partialTicks);
        if (captured) {
            MatrixUtils.releaseMatrix();
        }
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    private void renderModel(EntityLivingBase target, float partialTicks) {
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179141_d();
        ChameleonModel chameleonModel = this.getModel();
        if (chameleonModel == null) {
            return;
        }
        this.checkAnimator();
        Model model = chameleonModel.model;
        ChameleonAnimator.resetPose(model);
        if (!chameleonModel.isStatic()) {
            this.getAnimator().applyActions(target, model, partialTicks);
        }
        this.applyPose(model, partialTicks);
        if (this.skin != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.skin);
        }
        boolean hurtLight = RenderLightmap.set((EntityLivingBase)target, (float)partialTicks);
        ChameleonRenderer.render(model);
        if (hurtLight) {
            RenderLightmap.unset();
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.parts.initBodyParts();
        for (BodyPart part : this.parts.parts) {
            GlStateManager.func_179094_E();
            if (ChameleonRenderer.postRender(model, part.limb)) {
                part.render((AbstractMorph)this, target, partialTicks);
            }
            GlStateManager.func_179121_F();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void checkAnimator() {
        if (this.updateAnimator) {
            this.updateAnimator = false;
            this.getAnimator().refresh();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void applyPose(Model model, float partialTicks) {
        AnimatedPose pose = this.pose;
        boolean inProgress = this.animation.isInProgress();
        if (inProgress) {
            pose = this.animation.calculatePose(this.pose, this.getModel(), partialTicks);
        }
        for (ModelBone bone : model.bones) {
            this.applyPose(bone, pose);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void applyPose(ModelBone bone, AnimatedPose pose) {
        if (pose != null && pose.bones.containsKey(bone.id)) {
            AnimatedPoseTransform transform = pose.bones.get(bone.id);
            ModelTransform initial = bone.initial;
            ModelTransform current = bone.current;
            float factor = transform.fixed * pose.animated;
            float piToDegrees = 57.29578f;
            current.translate.x = Interpolations.lerp((float)initial.translate.x, (float)current.translate.x, (float)factor) + transform.x;
            current.translate.y = Interpolations.lerp((float)initial.translate.y, (float)current.translate.y, (float)factor) + transform.y;
            current.translate.z = Interpolations.lerp((float)initial.translate.z, (float)current.translate.z, (float)factor) + transform.z;
            current.rotation.x = Interpolations.lerp((float)initial.rotation.x, (float)current.rotation.x, (float)factor) + transform.rotateX * 57.29578f;
            current.rotation.y = Interpolations.lerp((float)initial.rotation.y, (float)current.rotation.y, (float)factor) + transform.rotateY * 57.29578f;
            current.rotation.z = Interpolations.lerp((float)initial.rotation.z, (float)current.rotation.z, (float)factor) + transform.rotateZ * 57.29578f;
            current.scale.x = Interpolations.lerp((float)initial.scale.x, (float)current.scale.x, (float)factor) + (transform.scaleX - 1.0f);
            current.scale.y = Interpolations.lerp((float)initial.scale.y, (float)current.scale.y, (float)factor) + (transform.scaleY - 1.0f);
            current.scale.z = Interpolations.lerp((float)initial.scale.z, (float)current.scale.z, (float)factor) + (transform.scaleZ - 1.0f);
            bone.absoluteBrightness = transform.absoluteBrightness;
            bone.glow = transform.glow;
            bone.color.copy(transform.color);
        }
        for (ModelBone childBone : bone.children) {
            this.applyPose(childBone, pose);
        }
    }

    private AnimatedPose getCurrentPose(float partialTicks) {
        if (this.getModel() == null) {
            return this.pose == null ? new AnimatedPose() : this.pose.clone();
        }
        return this.animation.calculatePose(this.pose, this.getModel(), partialTicks).clone();
    }

    @SideOnly(value=Side.CLIENT)
    public ChameleonModel getModel() {
        return ClientProxy.chameleonModels.get(this.getKey());
    }

    public void update(EntityLivingBase target) {
        this.animation.update();
        this.parts.updateBodyLimbs((AbstractMorph)this, target);
        super.update(target);
        if (target.field_70170_p.field_72995_K) {
            this.updateClient(target);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateClient(EntityLivingBase target) {
        ChameleonModel model = this.getModel();
        if (model == null || model.isStatic()) {
            return;
        }
        if (this.lastUpdate < model.lastUpdate) {
            this.lastUpdate = model.lastUpdate;
            this.updateAnimator = true;
        }
        this.checkAnimator();
        this.getAnimator().update(target);
    }

    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (obj instanceof ChameleonMorph) {
            ChameleonMorph morph = (ChameleonMorph)((Object)obj);
            result = result && Objects.equals(morph.skin, this.skin);
            result = result && Objects.equals(morph.pose, this.pose);
            result = result && Objects.equals(morph.parts, this.parts);
            result = result && Objects.equals(morph.actions, this.actions);
            result = result && Objects.equals((Object)morph.animation, (Object)this.animation);
            result = result && morph.scale == this.scale;
            result = result && morph.scaleGui == this.scaleGui;
            result = result && morph.isActionPlayer == this.isActionPlayer;
        }
        return result;
    }

    public boolean canMerge(AbstractMorph morph) {
        if (morph instanceof ChameleonMorph) {
            ChameleonMorph animated = (ChameleonMorph)morph;
            if (Objects.equals(this.getKey(), animated.getKey())) {
                this.mergeBasic(morph);
                this.lastScale = this.getScale(0.0f);
                this.animation.paused = false;
                AnimatedPose animatedPose = this.animation.last = this.pose == null ? new AnimatedPose() : this.pose.clone();
                if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && this.isActionPlayer && animated.isActionPlayer) {
                    this.checkAnimator();
                    this.lastAnimAction = this.animator != null && this.actions.getConfig("animation") != null ? this.animator.createAction(this.animator.animation, this.actions.getConfig("animation").clone(), false) : null;
                    if (this.lastAnimAction != null) {
                        this.lastAnimAction.config.tick = (int)((float)this.lastAnimAction.config.tick + this.animation.getFactor(0.0f) * (float)this.animation.duration * Math.abs(this.lastAnimAction.config.speed));
                    }
                }
                this.isActionPlayer = animated.isActionPlayer;
                this.skin = RLUtils.clone((ResourceLocation)animated.skin);
                this.pose = animated.pose == null ? null : animated.pose.clone();
                this.actions.copy(animated.actions);
                this.parts.merge(animated.parts);
                this.animation.merge(animated.animation);
                this.scale = animated.scale;
                this.scaleGui = animated.scaleGui;
                this.updateAnimator = true;
                return true;
            }
        }
        return false;
    }

    public void afterMerge(AbstractMorph morph) {
        super.afterMerge(morph);
        while (morph instanceof IMorphProvider) {
            morph = ((IMorphProvider)morph).getMorph();
        }
        if (morph instanceof IBodyPartProvider) {
            this.recursiveAfterMerge(this, (IBodyPartProvider)morph);
        }
        if (morph instanceof ChameleonMorph) {
            ChameleonMorph animated = (ChameleonMorph)morph;
            if (Objects.equals(this.getKey(), animated.getKey())) {
                AnimatedPose animatedPose = this.animation.last = this.pose == null ? new AnimatedPose() : this.pose.clone();
                if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && this.isActionPlayer && animated.isActionPlayer) {
                    animated.checkAnimator();
                    this.lastAnimAction = animated.animator != null && animated.actions.getConfig("animation") != null ? animated.animator.createAction(animated.animator.animation, animated.actions.getConfig("animation").clone(), false) : null;
                    if (this.lastAnimAction != null) {
                        this.lastAnimAction.config.tick = (int)((float)this.lastAnimAction.config.tick + animated.animation.getFactor(0.0f) * (float)animated.animation.duration * Math.abs(this.lastAnimAction.config.speed));
                    }
                }
                if (animated.animator != null) {
                    this.animator = animated.animator;
                    this.animator.morph = this;
                    this.updateAnimator = true;
                }
            }
        }
    }

    private void recursiveAfterMerge(IBodyPartProvider target, IBodyPartProvider destination) {
        int c = target.getBodyPart().parts.size();
        for (int i = 0; i < c && i < destination.getBodyPart().parts.size(); ++i) {
            AbstractMorph a = ((BodyPart)target.getBodyPart().parts.get((int)i)).morph.get();
            AbstractMorph b = ((BodyPart)destination.getBodyPart().parts.get((int)i)).morph.get();
            if (a == null) continue;
            a.afterMerge(b);
        }
    }

    public AbstractMorph create() {
        return new ChameleonMorph();
    }

    public void copy(AbstractMorph from) {
        super.copy(from);
        if (from instanceof ChameleonMorph) {
            ChameleonMorph morph = (ChameleonMorph)from;
            this.skin = RLUtils.clone((ResourceLocation)morph.skin);
            if (morph.pose != null) {
                this.pose = morph.pose.clone();
            }
            this.actions.copy(morph.actions);
            this.parts.copy(morph.parts);
            this.animation.copy(morph.animation);
            this.scale = morph.scale;
            this.scaleGui = morph.scaleGui;
            this.isActionPlayer = morph.isActionPlayer;
        }
    }

    public float getWidth(EntityLivingBase target) {
        return 0.6f;
    }

    public float getHeight(EntityLivingBase target) {
        return 1.8f;
    }

    public void reset() {
        super.reset();
        this.key = null;
        this.skin = null;
        this.pose = null;
        this.actions = new ActionsConfig();
        this.parts.reset();
        this.lastScale = 1.0f;
        this.scaleGui = 1.0f;
        this.scale = 1.0f;
        this.isActionPlayer = false;
        this.updateAnimator = true;
    }

    public void toNBT(NBTTagCompound tag) {
        NBTTagCompound actions;
        NBTTagCompound animation;
        NBTTagList bodyParts;
        super.toNBT(tag);
        if (this.skin != null) {
            tag.func_74782_a("Skin", RLUtils.writeNbt((ResourceLocation)this.skin));
        }
        if (this.pose != null) {
            tag.func_74782_a("Pose", (NBTBase)this.pose.toNBT());
        }
        if ((bodyParts = this.parts.toNBT()) != null) {
            tag.func_74782_a("BodyParts", (NBTBase)bodyParts);
        }
        if (!(animation = this.animation.toNBT()).func_82582_d()) {
            tag.func_74782_a("Transition", (NBTBase)animation);
        }
        if ((actions = this.actions.toNBT()) != null) {
            tag.func_74782_a("Actions", (NBTBase)actions);
        }
        if (this.scale != 1.0f) {
            tag.func_74776_a("Scale", this.scale);
        }
        if (this.scaleGui != 1.0f) {
            tag.func_74776_a("ScaleGUI", this.scaleGui);
        }
        if (this.isActionPlayer) {
            tag.func_74757_a("ActionPlayer", this.isActionPlayer);
        }
    }

    public void fromNBT(NBTTagCompound tag) {
        super.fromNBT(tag);
        if (tag.func_74764_b("Skin")) {
            this.skin = RLUtils.create((NBTBase)tag.func_74781_a("Skin"));
        }
        if (tag.func_150297_b("Pose", 10)) {
            this.pose = new AnimatedPose();
            this.pose.fromNBT(tag.func_74775_l("Pose"));
        }
        if (tag.func_150297_b("BodyParts", 9)) {
            this.parts.fromNBT(tag.func_150295_c("BodyParts", 10));
        }
        if (tag.func_74764_b("Transition")) {
            this.animation.fromNBT(tag.func_74775_l("Transition"));
        }
        if (tag.func_74764_b("Actions")) {
            this.actions.fromNBT(tag.func_74775_l("Actions"));
        }
        if (tag.func_74764_b("Scale")) {
            this.scale = tag.func_74760_g("Scale");
        }
        if (tag.func_74764_b("ScaleGUI")) {
            this.scaleGui = tag.func_74760_g("ScaleGUI");
        }
        if (tag.func_74764_b("ActionPlayer")) {
            this.isActionPlayer = tag.func_74767_n("ActionPlayer");
        }
    }
}

