/*
 * Decompiled with CFR 0.152.
 */
package mchorse.chameleon.lib.utils;

import java.util.Stack;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import mchorse.chameleon.lib.data.model.ModelBone;
import mchorse.chameleon.lib.data.model.ModelCube;

public class MatrixStack {
    private Stack<Matrix4f> model = new Stack();
    private Stack<Matrix3f> normal = new Stack();
    private Matrix4f tempModelMatrix = new Matrix4f();
    private Matrix3f tempNormalMatrix = new Matrix3f();

    public MatrixStack() {
        Matrix4f model = new Matrix4f();
        Matrix3f normal = new Matrix3f();
        model.setIdentity();
        normal.setIdentity();
        this.model.add(model);
        this.normal.add(normal);
    }

    public Matrix4f getModelMatrix() {
        return this.model.peek();
    }

    public Matrix3f getNormalMatrix() {
        return this.normal.peek();
    }

    public void push() {
        this.model.add(new Matrix4f(this.model.peek()));
        this.normal.add(new Matrix3f(this.normal.peek()));
    }

    public void pop() {
        if (this.model.size() == 1) {
            throw new IllegalStateException("A one level stack can't be popped!");
        }
        this.model.pop();
        this.normal.pop();
    }

    public void translate(float x, float y, float z) {
        this.translate(new Vector3f(x, y, z));
    }

    public void translate(Vector3f vec) {
        this.tempModelMatrix.setIdentity();
        this.tempModelMatrix.setTranslation(vec);
        this.model.peek().mul(this.tempModelMatrix);
    }

    public void moveToCubePivot(ModelCube cube) {
        Vector3f pivot = cube.pivot;
        this.translate(pivot.x / 16.0f, pivot.y / 16.0f, pivot.z / 16.0f);
    }

    public void moveBackFromCubePivot(ModelCube cube) {
        Vector3f pivot = cube.pivot;
        this.translate(-pivot.x / 16.0f, -pivot.y / 16.0f, -pivot.z / 16.0f);
    }

    public void moveToBonePivot(ModelBone bone) {
        Vector3f pivot = bone.initial.translate;
        this.translate(pivot.x / 16.0f, pivot.y / 16.0f, pivot.z / 16.0f);
    }

    public void moveBackFromBonePivot(ModelBone bone) {
        Vector3f pivot = bone.initial.translate;
        this.translate(-pivot.x / 16.0f, -pivot.y / 16.0f, -pivot.z / 16.0f);
    }

    public void translateBone(ModelBone bone) {
        Vector3f translate = bone.current.translate;
        Vector3f pivot = bone.initial.translate;
        this.translate(-(translate.x - pivot.x) / 16.0f, (translate.y - pivot.y) / 16.0f, (translate.z - pivot.z) / 16.0f);
    }

    public void scale(float x, float y, float z) {
        this.tempModelMatrix.setIdentity();
        this.tempModelMatrix.setM00(x);
        this.tempModelMatrix.setM11(y);
        this.tempModelMatrix.setM22(z);
        this.model.peek().mul(this.tempModelMatrix);
        if (x < 0.0f || y < 0.0f || z < 0.0f) {
            this.tempNormalMatrix.setIdentity();
            this.tempNormalMatrix.setM00(x < 0.0f ? -1.0f : 1.0f);
            this.tempNormalMatrix.setM11(y < 0.0f ? -1.0f : 1.0f);
            this.tempNormalMatrix.setM22(z < 0.0f ? -1.0f : 1.0f);
            this.normal.peek().mul(this.tempNormalMatrix);
        }
    }

    public void scaleBone(ModelBone bone) {
        this.scale(bone.current.scale.x, bone.current.scale.y, bone.current.scale.z);
    }

    public void rotateX(float radian) {
        this.tempModelMatrix.setIdentity();
        this.tempModelMatrix.rotX(radian);
        this.tempNormalMatrix.setIdentity();
        this.tempNormalMatrix.rotX(radian);
        this.model.peek().mul(this.tempModelMatrix);
        this.normal.peek().mul(this.tempNormalMatrix);
    }

    public void rotateY(float radian) {
        this.tempModelMatrix.setIdentity();
        this.tempModelMatrix.rotY(radian);
        this.tempNormalMatrix.setIdentity();
        this.tempNormalMatrix.rotY(radian);
        this.model.peek().mul(this.tempModelMatrix);
        this.normal.peek().mul(this.tempNormalMatrix);
    }

    public void rotateZ(float radian) {
        this.tempModelMatrix.setIdentity();
        this.tempModelMatrix.rotZ(radian);
        this.tempNormalMatrix.setIdentity();
        this.tempNormalMatrix.rotZ(radian);
        this.model.peek().mul(this.tempModelMatrix);
        this.normal.peek().mul(this.tempNormalMatrix);
    }

    public void rotateBone(ModelBone bone) {
        float degreesToPi = (float)Math.PI / 180;
        float z = bone.current.rotation.z;
        float y = bone.current.rotation.y;
        float x = bone.current.rotation.x;
        if (z != 0.0f) {
            this.rotateZ(z * ((float)Math.PI / 180));
        }
        if (y != 0.0f) {
            this.rotateY(y * ((float)Math.PI / 180));
        }
        if (x != 0.0f) {
            this.rotateX(x * ((float)Math.PI / 180));
        }
    }

    public void rotateCube(ModelCube bone) {
        float degreesToPi = (float)Math.PI / 180;
        Vector3f rotation = bone.rotation;
        Matrix4f matrix4f = new Matrix4f();
        Matrix3f matrix3f = new Matrix3f();
        this.tempModelMatrix.setIdentity();
        matrix4f.rotZ(rotation.z * ((float)Math.PI / 180));
        this.tempModelMatrix.mul(matrix4f);
        matrix4f.rotY(rotation.y * ((float)Math.PI / 180));
        this.tempModelMatrix.mul(matrix4f);
        matrix4f.rotX(rotation.x * ((float)Math.PI / 180));
        this.tempModelMatrix.mul(matrix4f);
        this.tempNormalMatrix.setIdentity();
        matrix3f.rotZ(rotation.z * ((float)Math.PI / 180));
        this.tempNormalMatrix.mul(matrix3f);
        matrix3f.rotY(rotation.y * ((float)Math.PI / 180));
        this.tempNormalMatrix.mul(matrix3f);
        matrix3f.rotX(rotation.x * ((float)Math.PI / 180));
        this.tempNormalMatrix.mul(matrix3f);
        this.model.peek().mul(this.tempModelMatrix);
        this.normal.peek().mul(this.tempNormalMatrix);
    }
}

