/*
 * Decompiled with CFR 0.152.
 */
package mchorse.chameleon.lib.render;

import mchorse.chameleon.lib.data.model.Model;
import mchorse.chameleon.lib.data.model.ModelBone;
import mchorse.chameleon.lib.render.ChameleonAxisRenderer;
import mchorse.chameleon.lib.render.ChameleonCubeRenderer;
import mchorse.chameleon.lib.render.ChameleonPostRenderer;
import mchorse.chameleon.lib.render.IChameleonRenderProcessor;
import mchorse.chameleon.lib.utils.MatrixStack;
import mchorse.mclib.client.render.VertexBuilder;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ChameleonRenderer {
    private static final MatrixStack MATRIX_STACK = new MatrixStack();
    private static final ChameleonCubeRenderer CUBE_RENDERER = new ChameleonCubeRenderer();
    private static final ChameleonPostRenderer POST_RENDERER = new ChameleonPostRenderer();
    private static final ChameleonAxisRenderer AXIS_RENDERER = new ChameleonAxisRenderer();

    public static void render(Model model) {
        GlStateManager.func_179129_p();
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        builder.func_181668_a(7, VertexBuilder.getFormat((boolean)true, (boolean)true, (boolean)true, (boolean)true));
        ChameleonRenderer.processRenderModel(CUBE_RENDERER, builder, MATRIX_STACK, model);
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
        GlStateManager.func_179089_o();
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        GlStateManager.func_179097_i();
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
    }

    public static boolean postRender(Model model, String boneName) {
        POST_RENDERER.setBoneName(boneName);
        return ChameleonRenderer.processRenderModel(POST_RENDERER, Tessellator.func_178181_a().func_178180_c(), MATRIX_STACK, model);
    }

    public static boolean processRenderModel(IChameleonRenderProcessor renderProcessor, BufferBuilder builder, MatrixStack stack, Model model) {
        for (ModelBone bone : model.bones) {
            if (!ChameleonRenderer.processRenderRecursively(renderProcessor, builder, stack, bone)) continue;
            return true;
        }
        return false;
    }

    private static boolean processRenderRecursively(IChameleonRenderProcessor renderProcessor, BufferBuilder builder, MatrixStack stack, ModelBone bone) {
        stack.push();
        stack.translateBone(bone);
        stack.moveToBonePivot(bone);
        stack.rotateBone(bone);
        stack.scaleBone(bone);
        stack.moveBackFromBonePivot(bone);
        if (bone.visible) {
            if (renderProcessor.renderBone(builder, stack, bone)) {
                stack.pop();
                return true;
            }
            for (ModelBone childBone : bone.children) {
                if (!ChameleonRenderer.processRenderRecursively(renderProcessor, builder, stack, childBone)) continue;
                stack.pop();
                return true;
            }
        }
        stack.pop();
        return false;
    }
}

