/*
 * Decompiled with CFR 0.152.
 */
package mchorse.chameleon.lib.render;

import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import mchorse.chameleon.lib.data.model.ModelBone;
import mchorse.chameleon.lib.data.model.ModelCube;
import mchorse.chameleon.lib.data.model.ModelQuad;
import mchorse.chameleon.lib.data.model.ModelVertex;
import mchorse.chameleon.lib.render.IChameleonRenderProcessor;
import mchorse.chameleon.lib.utils.MatrixStack;
import mchorse.mclib.utils.Interpolation;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ChameleonCubeRenderer
implements IChameleonRenderProcessor {
    private float r;
    private float g;
    private float b;
    private float a;
    private Vector3f normal = new Vector3f();
    private Vector4f vertex = new Vector4f();

    @Override
    public boolean renderBone(BufferBuilder builder, MatrixStack stack, ModelBone bone) {
        int lightX = (int)OpenGlHelper.lastBrightnessX;
        int lightY = (int)OpenGlHelper.lastBrightnessY;
        this.r = bone.color.r;
        this.g = bone.color.g;
        this.b = bone.color.b;
        this.a = bone.color.a;
        if (bone.absoluteBrightness) {
            lightX = 0;
        }
        lightX = (int)Interpolation.LINEAR.interpolate((float)lightX, 240.0f, bone.glow);
        for (ModelCube cube : bone.cubes) {
            this.renderCube(builder, stack, cube, lightX, lightY);
        }
        return false;
    }

    private void renderCube(BufferBuilder builder, MatrixStack stack, ModelCube cube, int lightX, int lightY) {
        stack.push();
        stack.moveToCubePivot(cube);
        stack.rotateCube(cube);
        stack.moveBackFromCubePivot(cube);
        for (ModelQuad quad : cube.quads) {
            this.normal.set(quad.normal.x, quad.normal.y, quad.normal.z);
            stack.getNormalMatrix().transform((Tuple3f)this.normal);
            if (this.normal.getX() < 0.0f && (cube.size.y == 0.0f || cube.size.z == 0.0f)) {
                this.normal.x *= -1.0f;
            }
            if (this.normal.getY() < 0.0f && (cube.size.x == 0.0f || cube.size.z == 0.0f)) {
                this.normal.y *= -1.0f;
            }
            if (this.normal.getZ() < 0.0f && (cube.size.x == 0.0f || cube.size.y == 0.0f)) {
                this.normal.z *= -1.0f;
            }
            for (ModelVertex vertex : quad.vertices) {
                this.vertex.set((Tuple3f)vertex.position);
                this.vertex.w = 1.0f;
                stack.getModelMatrix().transform((Tuple4f)this.vertex);
                builder.func_181662_b((double)this.vertex.x, (double)this.vertex.y, (double)this.vertex.z).func_181666_a(this.r, this.g, this.b, this.a).func_187315_a((double)vertex.uv.x, (double)vertex.uv.y).func_187314_a(lightY, lightX).func_181663_c(this.normal.x, this.normal.y, this.normal.z).func_181675_d();
            }
        }
        stack.pop();
    }
}

