/*
 * Decompiled with CFR 0.152.
 */
package mchorse.chameleon.lib.parsing;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import mchorse.chameleon.lib.data.model.Model;
import mchorse.chameleon.lib.data.model.ModelBone;
import mchorse.chameleon.lib.data.model.ModelCube;
import mchorse.chameleon.lib.data.model.ModelUV;
import net.minecraft.client.util.JsonException;

public class ModelParser {
    public static Model parse(JsonObject object) throws JsonException {
        Model model = new Model();
        if ((object = object.get("minecraft:geometry").getAsJsonArray().get(0).getAsJsonObject()).has("description")) {
            ModelParser.parseDescription(model, object.get("description").getAsJsonObject());
        }
        if (object.has("bones")) {
            ModelParser.parseBones(model, object.get("bones").getAsJsonArray());
        }
        return model;
    }

    private static void parseDescription(Model model, JsonObject object) {
        if (object.has("identifier")) {
            model.id = object.get("identifier").getAsString();
        }
        if (object.has("texture_width")) {
            model.textureWidth = object.get("texture_width").getAsInt();
        }
        if (object.has("texture_height")) {
            model.textureHeight = object.get("texture_height").getAsInt();
        }
    }

    private static void parseBones(Model model, JsonArray bones) {
        HashMap<String, List> hierarchy = new HashMap<String, List>();
        HashMap<String, ModelBone> flatBones = new HashMap<String, ModelBone>();
        for (JsonElement element : bones) {
            JsonObject boneElement = element.getAsJsonObject();
            ModelBone bone = new ModelBone(boneElement.get("name").getAsString());
            String parent = boneElement.has("parent") ? boneElement.get("parent").getAsString() : "";
            List list = hierarchy.computeIfAbsent(parent, a -> new ArrayList());
            list.add(bone.id);
            if (boneElement.has("pivot")) {
                ModelParser.parseVector(boneElement.get("pivot"), bone.initial.translate);
            }
            if (boneElement.has("scale")) {
                ModelParser.parseVector(boneElement.get("scale"), bone.initial.scale);
            }
            if (boneElement.has("rotation")) {
                ModelParser.parseVector(boneElement.get("rotation"), bone.initial.rotation);
                bone.initial.rotation.x *= -1.0f;
                bone.initial.rotation.y *= -1.0f;
            }
            bone.initial.translate.x *= -1.0f;
            if (boneElement.has("cubes")) {
                ModelParser.parseCubes(model, bone, boneElement.get("cubes").getAsJsonArray());
            }
            flatBones.put(bone.id, bone);
        }
        for (Map.Entry entry : hierarchy.entrySet()) {
            if (((String)entry.getKey()).isEmpty()) continue;
            ModelBone bone = (ModelBone)flatBones.get(entry.getKey());
            for (String child : (List)entry.getValue()) {
                bone.children.add((ModelBone)flatBones.get(child));
            }
        }
        List topLevel = (List)hierarchy.get("");
        if (topLevel != null) {
            for (String topLevelBone : topLevel) {
                model.bones.add((ModelBone)flatBones.get(topLevelBone));
            }
        }
    }

    private static void parseCubes(Model model, ModelBone bone, JsonArray cubes) {
        for (JsonElement element : cubes) {
            bone.cubes.add(ModelParser.parseCube(model, element.getAsJsonObject()));
        }
    }

    private static ModelCube parseCube(Model model, JsonObject object) {
        ModelCube cube = new ModelCube();
        if (object.has("inflate")) {
            cube.inflate = object.get("inflate").getAsFloat();
        }
        ModelParser.parseVector(object.get("origin"), cube.origin);
        ModelParser.parseVector(object.get("size"), cube.size);
        if (object.has("pivot")) {
            ModelParser.parseVector(object.get("pivot"), cube.pivot);
        } else {
            cube.pivot.set((Tuple3f)cube.origin);
        }
        cube.origin.x *= -1.0f;
        cube.pivot.x *= -1.0f;
        if (object.has("rotation")) {
            ModelParser.parseVector(object.get("rotation"), cube.rotation);
            cube.rotation.x *= -1.0f;
            cube.rotation.y *= -1.0f;
        }
        if (object.has("uv")) {
            boolean mirror = object.has("mirror") && object.get("mirror").getAsBoolean();
            ModelParser.parseUV(cube, object.get("uv"), mirror);
        }
        cube.generateQuads(model);
        return cube;
    }

    private static void parseUV(ModelCube cube, JsonElement element, boolean mirror) {
        if (element.isJsonArray()) {
            Vector2f boxUV = new Vector2f();
            ModelParser.parseVector((JsonElement)element.getAsJsonArray(), boxUV);
            cube.setupBoxUV(boxUV, mirror);
        } else if (element.isJsonObject()) {
            JsonObject sides = element.getAsJsonObject();
            if (sides.has("north")) {
                cube.north = ModelParser.parseUVSide(sides.get("north").getAsJsonObject());
            }
            if (sides.has("east")) {
                cube.east = ModelParser.parseUVSide(sides.get("east").getAsJsonObject());
            }
            if (sides.has("south")) {
                cube.south = ModelParser.parseUVSide(sides.get("south").getAsJsonObject());
            }
            if (sides.has("west")) {
                cube.west = ModelParser.parseUVSide(sides.get("west").getAsJsonObject());
            }
            if (sides.has("up")) {
                cube.up = ModelParser.parseUVSide(sides.get("up").getAsJsonObject());
            }
            if (sides.has("down")) {
                cube.down = ModelParser.parseUVSide(sides.get("down").getAsJsonObject());
            }
        }
    }

    private static ModelUV parseUVSide(JsonObject uvSide) {
        ModelUV uv = new ModelUV();
        ModelParser.parseVector(uvSide.get("uv"), uv.origin);
        ModelParser.parseVector(uvSide.get("uv_size"), uv.size);
        return uv;
    }

    private static void parseVector(JsonElement element, Vector3f vector) {
        JsonArray array = element.getAsJsonArray();
        vector.x = array.get(0).getAsFloat();
        vector.y = array.get(1).getAsFloat();
        vector.z = array.get(2).getAsFloat();
    }

    private static void parseVector(JsonElement element, Vector2f vector) {
        JsonArray array = element.getAsJsonArray();
        vector.x = array.get(0).getAsFloat();
        vector.y = array.get(1).getAsFloat();
    }
}

