/*
 * Decompiled with CFR 0.152.
 */
package mchorse.chameleon.lib;

import mchorse.mclib.math.Variable;
import mchorse.mclib.math.molang.MolangParser;
import mchorse.mclib.math.molang.expressions.MolangExpression;
import mchorse.mclib.utils.Interpolations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MolangHelper {
    public static void registerVars(MolangParser parser) {
        parser.register(new Variable("query.anim_time", 0.0));
        parser.register(new Variable("query.life_time", 0.0));
        parser.register(new Variable("query.actor_count", 0.0));
        parser.register(new Variable("query.time_of_day", 0.0));
        parser.register(new Variable("query.moon_phase", 0.0));
        parser.register(new Variable("query.distance_from_camera", 0.0));
        parser.register(new Variable("query.is_on_ground", 0.0));
        parser.register(new Variable("query.is_in_water", 0.0));
        parser.register(new Variable("query.is_in_water_or_rain", 0.0));
        parser.register(new Variable("query.health", 0.0));
        parser.register(new Variable("query.max_health", 0.0));
        parser.register(new Variable("query.is_on_fire", 0.0));
        parser.register(new Variable("query.ground_speed", 0.0));
        parser.register(new Variable("query.yaw_speed", 0.0));
    }

    public static void setMolangVariables(MolangParser parser, EntityLivingBase target, float frame) {
        parser.setValue("query.anim_time", (double)(frame / 20.0f));
        parser.setValue("query.life_time", (double)(frame / 20.0f));
        Minecraft mc = Minecraft.func_71410_x();
        float partialTick = mc.func_184121_ak();
        parser.setValue("query.actor_count", (double)mc.field_71441_e.field_72996_f.size());
        parser.setValue("query.time_of_day", MolangHelper.normalizeTime(mc.field_71441_e.func_82737_E()));
        parser.setValue("query.moon_phase", (double)mc.field_71441_e.func_72853_d());
        Entity camera = mc.func_175606_aa();
        Vec3d entityCamera = new Vec3d(camera.field_70169_q + (camera.field_70165_t - camera.field_70169_q) * (double)partialTick, camera.field_70167_r + (camera.field_70163_u - camera.field_70167_r) * (double)partialTick, camera.field_70166_s + (camera.field_70161_v - camera.field_70166_s) * (double)partialTick);
        Vec3d entityPosition = new Vec3d(target.field_70169_q + (target.field_70165_t - target.field_70169_q) * (double)partialTick, target.field_70167_r + (target.field_70163_u - target.field_70167_r) * (double)partialTick, target.field_70166_s + (target.field_70161_v - target.field_70166_s) * (double)partialTick);
        double distance = entityCamera.func_178787_e(ActiveRenderInfo.getCameraPosition()).func_72438_d(entityPosition);
        parser.setValue("query.distance_from_camera", distance);
        parser.setValue("query.is_on_ground", MolangHelper.booleanToDouble(target.field_70122_E));
        parser.setValue("query.is_in_water", MolangHelper.booleanToDouble(target.func_70090_H()));
        parser.setValue("query.is_in_water_or_rain", MolangHelper.booleanToDouble(target.func_70026_G()));
        parser.setValue("query.health", (double)target.func_110143_aJ());
        parser.setValue("query.max_health", (double)target.func_110138_aP());
        parser.setValue("query.is_on_fire", MolangHelper.booleanToDouble(target.func_70027_ad()));
        double dx = target.field_70159_w;
        double dz = target.field_70179_y;
        float groundSpeed = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        parser.setValue("query.ground_speed", (double)groundSpeed);
        parser.setValue("query.yaw_speed", (double)(target.field_70759_as - target.field_70758_at));
        float yaw = Interpolations.lerpYaw((float)target.field_70758_at, (float)target.field_70759_as, (float)partialTick);
        float bodyYaw = Interpolations.lerpYaw((float)target.field_70760_ar, (float)target.field_70761_aq, (float)partialTick);
        parser.setValue("query.head_yaw", (double)(yaw - bodyYaw));
        parser.setValue("query.head_pitch", (double)Interpolations.lerp((float)target.field_70127_C, (float)target.field_70125_A, (float)partialTick));
        double velocity = Math.sqrt(target.field_70159_w * target.field_70159_w + target.field_70181_x * target.field_70181_x + target.field_70179_y * target.field_70179_y);
        float limbSwingAmount = Interpolations.lerp((float)target.field_184618_aE, (float)target.field_70721_aZ, (float)partialTick);
        float limbSwing = target.field_184619_aG - target.field_70721_aZ * (1.0f - partialTick);
        if (target.field_70122_E && target.field_70181_x < 0.0 && (Math.abs(target.field_70159_w) < 0.001 || Math.abs(target.field_70179_y) < 0.001)) {
            velocity = 0.0;
        }
        if (limbSwingAmount > 1.0f) {
            limbSwingAmount = 1.0f;
        }
        parser.setValue("query.velocity", velocity);
        parser.setValue("query.limb_swing", (double)limbSwing);
        parser.setValue("query.limb_swing_amount", (double)limbSwingAmount);
        parser.setValue("query.age", (double)((float)target.field_70173_aa + partialTick));
    }

    private static double normalizeTime(long totalWorldTime) {
        return (double)totalWorldTime / 24000.0;
    }

    private static double booleanToDouble(boolean bool) {
        return bool ? 1.0 : 0.0;
    }

    public static double getValue(MolangExpression value, Component component, EnumFacing.Axis axis) {
        double out = value.get();
        if (component == Component.ROTATION) {
            if (axis == EnumFacing.Axis.X || axis == EnumFacing.Axis.Y) {
                out *= -1.0;
            }
        } else if (component == Component.SCALE) {
            out -= 1.0;
        }
        return out;
    }

    public static enum Component {
        POSITION,
        ROTATION,
        SCALE;

    }
}

