/*
 * Decompiled with CFR 0.152.
 */
package mchorse.chameleon.lib;

import java.util.List;
import javax.vecmath.Vector3d;
import mchorse.chameleon.ClientProxy;
import mchorse.chameleon.lib.MolangHelper;
import mchorse.chameleon.lib.data.animation.Animation;
import mchorse.chameleon.lib.data.animation.AnimationChannel;
import mchorse.chameleon.lib.data.animation.AnimationPart;
import mchorse.chameleon.lib.data.animation.AnimationVector;
import mchorse.chameleon.lib.data.model.Model;
import mchorse.chameleon.lib.data.model.ModelBone;
import mchorse.chameleon.lib.data.model.ModelTransform;
import mchorse.mclib.utils.Interpolations;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ChameleonAnimator {
    public static void resetPose(Model model) {
        for (ModelBone bone : model.bones) {
            bone.reset();
        }
    }

    public static void animate(EntityLivingBase target, Model model, Animation animation, float frame, float blend, boolean skipInitial) {
        MolangHelper.setMolangVariables(ClientProxy.parser, target, frame);
        for (ModelBone bone : model.bones) {
            ChameleonAnimator.animateBone(bone, animation, frame, blend, skipInitial);
        }
    }

    private static void animateBone(ModelBone bone, Animation animation, float frame, float blend, boolean skipInitial) {
        boolean applied = false;
        AnimationPart part = animation.parts.get(bone.id);
        if (part != null) {
            ChameleonAnimator.applyBoneAnimation(bone, part, frame, blend);
            applied = true;
        }
        if (!applied && !skipInitial) {
            ModelTransform initial = bone.initial;
            ModelTransform current = bone.current;
            current.translate.x = Interpolations.lerp((float)current.translate.x, (float)initial.translate.x, (float)blend);
            current.translate.y = Interpolations.lerp((float)current.translate.y, (float)initial.translate.y, (float)blend);
            current.translate.z = Interpolations.lerp((float)current.translate.z, (float)initial.translate.z, (float)blend);
            current.scale.x = Interpolations.lerp((float)current.scale.x, (float)initial.scale.x, (float)blend);
            current.scale.y = Interpolations.lerp((float)current.scale.y, (float)initial.scale.y, (float)blend);
            current.scale.z = Interpolations.lerp((float)current.scale.z, (float)initial.scale.z, (float)blend);
            current.rotation.x = Interpolations.lerp((float)current.rotation.x, (float)initial.rotation.x, (float)blend);
            current.rotation.y = Interpolations.lerp((float)current.rotation.y, (float)initial.rotation.y, (float)blend);
            current.rotation.z = Interpolations.lerp((float)current.rotation.z, (float)initial.rotation.z, (float)blend);
        }
        for (ModelBone childBone : bone.children) {
            ChameleonAnimator.animateBone(childBone, animation, frame, blend, skipInitial);
        }
    }

    private static void applyBoneAnimation(ModelBone bone, AnimationPart animation, float frame, float blend) {
        Vector3d pos = ChameleonAnimator.interpolateList(animation.position, frame, MolangHelper.Component.POSITION);
        Vector3d rot = ChameleonAnimator.interpolateList(animation.rotation, frame, MolangHelper.Component.ROTATION);
        Vector3d scale = ChameleonAnimator.interpolateList(animation.scale, frame, MolangHelper.Component.SCALE);
        ModelTransform initial = bone.initial;
        ModelTransform current = bone.current;
        current.translate.x = Interpolations.lerp((float)current.translate.x, (float)((float)pos.x + initial.translate.x), (float)blend);
        current.translate.y = Interpolations.lerp((float)current.translate.y, (float)((float)pos.y + initial.translate.y), (float)blend);
        current.translate.z = Interpolations.lerp((float)current.translate.z, (float)((float)pos.z + initial.translate.z), (float)blend);
        current.scale.x = Interpolations.lerp((float)current.scale.x, (float)((float)scale.x + initial.scale.x), (float)blend);
        current.scale.y = Interpolations.lerp((float)current.scale.y, (float)((float)scale.y + initial.scale.y), (float)blend);
        current.scale.z = Interpolations.lerp((float)current.scale.z, (float)((float)scale.z + initial.scale.z), (float)blend);
        current.rotation.x = Interpolations.lerp((float)current.rotation.x, (float)((float)rot.x + initial.rotation.x), (float)blend);
        current.rotation.y = Interpolations.lerp((float)current.rotation.y, (float)((float)rot.y + initial.rotation.y), (float)blend);
        current.rotation.z = Interpolations.lerp((float)current.rotation.z, (float)((float)rot.z + initial.rotation.z), (float)blend);
    }

    private static Vector3d interpolateList(AnimationChannel channel, float frame, MolangHelper.Component component) {
        return ChameleonAnimator.interpolate(channel, frame, component);
    }

    private static Vector3d interpolate(AnimationChannel channel, float frame, MolangHelper.Component component) {
        Vector3d output = new Vector3d();
        List<AnimationVector> keyframes = channel.keyframes;
        if (keyframes.isEmpty()) {
            output.set(0.0, 0.0, 0.0);
            return output;
        }
        AnimationVector first = keyframes.get(0);
        if ((double)frame < first.time * 20.0) {
            output.x = MolangHelper.getValue(first.getStart(EnumFacing.Axis.X), component, EnumFacing.Axis.X);
            output.y = MolangHelper.getValue(first.getStart(EnumFacing.Axis.Y), component, EnumFacing.Axis.Y);
            output.z = MolangHelper.getValue(first.getStart(EnumFacing.Axis.Z), component, EnumFacing.Axis.Z);
            return output;
        }
        double duration = first.time * 20.0;
        for (AnimationVector vector : keyframes) {
            double length = vector.getLengthInTicks();
            if ((double)frame >= duration && (double)frame < duration + length) {
                double factor = ((double)frame - duration) / length;
                output.x = vector.interp.interpolate(vector, component, EnumFacing.Axis.X, factor);
                output.y = vector.interp.interpolate(vector, component, EnumFacing.Axis.Y, factor);
                output.z = vector.interp.interpolate(vector, component, EnumFacing.Axis.Z, factor);
                return output;
            }
            duration += length;
        }
        AnimationVector last = keyframes.get(keyframes.size() - 1);
        output.x = MolangHelper.getValue(last.getStart(EnumFacing.Axis.X), component, EnumFacing.Axis.X);
        output.y = MolangHelper.getValue(last.getStart(EnumFacing.Axis.Y), component, EnumFacing.Axis.Y);
        output.z = MolangHelper.getValue(last.getStart(EnumFacing.Axis.Z), component, EnumFacing.Axis.Z);
        return output;
    }
}

