/*
 * Decompiled with CFR 0.152.
 */
package mchorse.chameleon.animation;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mchorse.chameleon.animation.ActionConfig;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ActionsConfig {
    public Map<String, ActionConfig> actions = new HashMap<String, ActionConfig>();

    public boolean equals(Object obj) {
        if (obj instanceof ActionsConfig) {
            ActionsConfig config = (ActionsConfig)obj;
            return Objects.equals(this.actions, config.actions);
        }
        return super.equals(obj);
    }

    public void copy(ActionsConfig config) {
        this.actions.clear();
        this.actions.putAll(config.actions);
    }

    public void fromNBT(NBTTagCompound tag) {
        this.actions.clear();
        for (String key : tag.func_150296_c()) {
            NBTBase base = tag.func_74781_a(key);
            String newKey = this.toKey(key);
            ActionConfig config = new ActionConfig(newKey);
            config.fromNBT(base);
            this.actions.put(newKey, config);
        }
    }

    public NBTTagCompound toNBT() {
        return this.toNBT(new NBTTagCompound());
    }

    public NBTTagCompound toNBT(NBTTagCompound tag) {
        if (this.actions.isEmpty()) {
            return null;
        }
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        for (Map.Entry<String, ActionConfig> entry : this.actions.entrySet()) {
            ActionConfig action = entry.getValue();
            String key = entry.getKey();
            if (key.equals(action.name) && action.isDefault()) continue;
            tag.func_74782_a(key, action.toNBT());
        }
        return tag;
    }

    public ActionConfig getConfig(String key) {
        ActionConfig output = this.actions.get(key);
        return output == null ? new ActionConfig(key) : output;
    }

    public String toKey(String key) {
        return key.replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase();
    }
}

