/*
 * Decompiled with CFR 0.152.
 */
package dmfmm.catwalks.client.catwalks;

import com.google.common.collect.ImmutableMap;
import dmfmm.catwalks.block.CatwalkBlock;
import dmfmm.catwalks.client.catwalks.CatwalkModel;
import dmfmm.catwalks.client.catwalks.CatwalkState;
import dmfmm.catwalks.utils.CatwalkMaterial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;

public class CatwalkLegacyModel
implements IBakedModel {
    static Map<CatwalkState, List<BakedQuad>> cache = new HashMap<CatwalkState, List<BakedQuad>>();
    static Map<String, Map<String, ImmutableMap<EnumFacing, IBakedModel>>> modelPieces = new HashMap<String, Map<String, ImmutableMap<EnumFacing, IBakedModel>>>();
    private boolean match;
    private String modelType;

    public CatwalkLegacyModel(boolean matches, String modelMaterial, Map<String, IModel> models, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        this.match = matches;
        this.modelType = modelMaterial;
        for (String model : models.keySet()) {
            Map<Object, Object> hash;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                TRSRTransformation transformation = TRSRTransformation.from((EnumFacing)facing);
                builder.put((Object)facing, (Object)models.get(model).bake((IModelState)transformation, format, bakedTextureGetter));
            }
            if (modelPieces.containsKey(this.modelType)) {
                hash = modelPieces.get(this.modelType);
                hash.put(model, builder.build());
                continue;
            }
            hash = new HashMap<String, ImmutableMap>();
            hash.put(model, builder.build());
            modelPieces.put(this.modelType, hash);
        }
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        int i;
        CatwalkState cw = null;
        String material = "treated_wood";
        if (state != null) {
            material = ((CatwalkMaterial)((Object)state.func_177229_b(CatwalkBlock.MATERIAL))).func_176610_l().toLowerCase();
        }
        if (state instanceof IExtendedBlockState) {
            cw = (CatwalkState)((IExtendedBlockState)state).getValue(CatwalkBlock.CATWALK_STATE);
        }
        if (cw == null) {
            cw = new CatwalkState(CatwalkModel.RailSection.OUTER, CatwalkModel.RailSection.OUTER, CatwalkModel.RailSection.OUTER, CatwalkModel.RailSection.OUTER, CatwalkModel.FloorSection.OUTER, CatwalkModel.FloorSection.OUTER, CatwalkModel.FloorSection.OUTER, CatwalkModel.FloorSection.OUTER, 0);
        }
        ArrayList<BakedQuad> bq = new ArrayList<BakedQuad>();
        for (i = 0; i < 4; ++i) {
            CatwalkModel.FloorSection section = cw.floorSections.get(i);
            if (!this.match || section == null) continue;
            if (!material.equals("nyanwalk")) {
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    bq.addAll(((IBakedModel)modelPieces.get(material).get("bottom_corner").get((Object)facing)).func_188616_a(state, side, rand));
                    bq.addAll(((IBakedModel)modelPieces.get(material).get("bottom_edge").get((Object)facing)).func_188616_a(state, side, rand));
                }
            }
            bq.addAll(((IBakedModel)modelPieces.get(material).get("bottom").get((Object)EnumFacing.NORTH)).func_188616_a(state, side, rand));
        }
        block10: for (i = 0; i < 4; ++i) {
            CatwalkModel.RailSection rail = cw.railSections.get(i);
            switch (rail) {
                case OUTER: {
                    if (!material.equals("nyanwalk")) {
                        bq.addAll(((IBakedModel)modelPieces.get(material).get("corner_outer").get((Object)this.facingFromInt(i))).func_188616_a(state, side, rand));
                        bq.addAll(((IBakedModel)modelPieces.get(material).get("left_merge").get((Object)this.facingFromInt(i))).func_188616_a(state, side, rand));
                        bq.addAll(((IBakedModel)modelPieces.get(material).get("right_merge").get((Object)this.facingFromInt(i).func_176735_f())).func_188616_a(state, side, rand));
                        continue block10;
                    }
                    if (i == 0) {
                        bq.addAll(((IBakedModel)modelPieces.get(material).get("left_merge").get((Object)this.facingFromInt(i))).func_188616_a(state, side, rand));
                        bq.addAll(((IBakedModel)modelPieces.get(material).get("right_connect").get((Object)this.facingFromInt(i).func_176735_f())).func_188616_a(state, side, rand));
                        continue block10;
                    }
                    if (i == 1) {
                        bq.addAll(((IBakedModel)modelPieces.get(material).get("left_connect").get((Object)this.facingFromInt(i))).func_188616_a(state, side, rand));
                        bq.addAll(((IBakedModel)modelPieces.get(material).get("right_merge").get((Object)this.facingFromInt(i).func_176735_f())).func_188616_a(state, side, rand));
                        continue block10;
                    }
                    if (i == 2) {
                        bq.addAll(((IBakedModel)modelPieces.get(material).get("left_merge").get((Object)this.facingFromInt(i))).func_188616_a(state, side, rand));
                        bq.addAll(((IBakedModel)modelPieces.get(material).get("right_connect").get((Object)this.facingFromInt(i).func_176735_f())).func_188616_a(state, side, rand));
                        continue block10;
                    }
                    bq.addAll(((IBakedModel)modelPieces.get(material).get("left_connect").get((Object)this.facingFromInt(i))).func_188616_a(state, side, rand));
                    bq.addAll(((IBakedModel)modelPieces.get(material).get("right_merge").get((Object)this.facingFromInt(i).func_176735_f())).func_188616_a(state, side, rand));
                    continue block10;
                }
                case INNER: {
                    if (material.equals("nyanwalk")) continue block10;
                    bq.addAll(((IBakedModel)modelPieces.get(material).get("corner_inner").get((Object)this.facingFromInt(i))).func_188616_a(state, side, rand));
                    continue block10;
                }
                case Z_EDGE: {
                    String siding = i % 2 == 0 ? "right" : "left";
                    EnumFacing facing = i == 1 || i == 2 ? EnumFacing.EAST : EnumFacing.WEST;
                    bq.addAll(((IBakedModel)modelPieces.get(material).get(siding + "_connect").get((Object)facing)).func_188616_a(state, side, rand));
                    continue block10;
                }
                case X_END: {
                    bq.addAll(((IBakedModel)modelPieces.get(material).get("corner_outer").get((Object)this.facingFromInt(i))).func_188616_a(state, side, rand));
                    String siding = i % 2 == 0 ? "left" : "right";
                    EnumFacing facing = i <= 1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                    bq.addAll(((IBakedModel)modelPieces.get(material).get(siding + "_merge").get((Object)facing)).func_188616_a(state, side, rand));
                    continue block10;
                }
                case Z_END: {
                    bq.addAll(((IBakedModel)modelPieces.get(material).get("corner_outer").get((Object)this.facingFromInt(i))).func_188616_a(state, side, rand));
                    String siding = i % 2 == 0 ? "right" : "left";
                    EnumFacing facing = i == 1 || i == 2 ? EnumFacing.EAST : EnumFacing.WEST;
                    bq.addAll(((IBakedModel)modelPieces.get(material).get(siding + "_merge").get((Object)facing)).func_188616_a(state, side, rand));
                    continue block10;
                }
                case X_EDGE: {
                    String siding = i % 2 == 0 ? "left" : "right";
                    EnumFacing facing = i <= 1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                    bq.addAll(((IBakedModel)modelPieces.get(material).get(siding + "_connect").get((Object)facing)).func_188616_a(state, side, rand));
                    continue block10;
                }
            }
        }
        return bq;
    }

    private EnumFacing facingFromInt(int number) {
        switch (number) {
            case 0: {
                return EnumFacing.NORTH;
            }
            case 1: {
                return EnumFacing.EAST;
            }
            case 2: {
                return EnumFacing.SOUTH;
            }
            case 3: {
                return EnumFacing.WEST;
            }
        }
        return EnumFacing.NORTH;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return ((IBakedModel)modelPieces.get(this.modelType).get("bottom").get((Object)EnumFacing.NORTH)).func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

