/*
 * Decompiled with CFR 0.152.
 */
package dmfmm.catwalks.client;

import com.google.common.collect.ImmutableList;
import dmfmm.catwalks.client.LadderModel;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;

public class LadderModelLoader
implements ICustomModelLoader {
    public boolean accepts(ResourceLocation modelLocation) {
        return modelLocation.func_110623_a().endsWith("!catwalks:ladder");
    }

    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        return new LadderModelWrapper(modelLocation.func_110623_a().replace("!!catwalks:ladder", "").replace("models/", ""));
    }

    public void func_110549_a(IResourceManager resourceManager) {
    }

    public static class LadderModelWrapper
    implements IModel {
        static ResourceLocation ladder;
        static ResourceLocation side_bar;
        static ResourceLocation connectionRight;
        static ResourceLocation connectionLeft;
        static ResourceLocation wrap;
        static ResourceLocation base;
        static ResourceLocation secondPole;
        static ResourceLocation baseConnected;
        static ResourceLocation connectionRightBig;
        static ResourceLocation connectionLeftBig;
        static ResourceLocation wrapBig;
        static ResourceLocation ladderTop;
        static ResourceLocation mergeLeft;
        static ResourceLocation mergeRight;
        static IModel bakedLadder;
        static IModel bakedSideBar;
        static IModel bakedConnectionRight;
        static IModel bakedConnectionLeft;
        static IModel bakedWrap;
        static IModel bakedBase;
        static IModel bakedSecondPole;
        static IModel bakedBaseConnected;
        static IModel bakedRightBig;
        static IModel bakedLeftBig;
        static IModel bakedWrapBig;
        static IModel bakedLadderTop;
        static IModel bakedMergeLeft;
        static IModel bakedMergeRight;

        LadderModelWrapper(String path) {
            ladder = new ResourceLocation("catwalks", path + "/ladder");
            side_bar = new ResourceLocation("catwalks", path + "/corner");
            connectionRight = new ResourceLocation("catwalks", path + "/right_connect_small");
            wrap = new ResourceLocation("catwalks", path + "/round_corner_small");
            connectionLeft = new ResourceLocation("catwalks", path + "/left_connect_small");
            base = new ResourceLocation("catwalks", path + "/bottom_connect_none");
            baseConnected = new ResourceLocation("catwalks", path + "/bottom_connect_front");
            secondPole = new ResourceLocation("catwalks", path + "/bottom_side_bar");
            connectionLeftBig = new ResourceLocation("catwalks", path + "/left_connect_large");
            connectionRightBig = new ResourceLocation("catwalks", path + "/right_connect_large");
            wrapBig = new ResourceLocation("catwalks", path + "/round_corner_large");
            ladderTop = new ResourceLocation("catwalks", path + "/ladder_top");
            mergeLeft = new ResourceLocation("catwalks", path + "/left_merge_large");
            mergeRight = new ResourceLocation("catwalks", path + "/right_merge_large");
        }

        public Collection<ResourceLocation> getDependencies() {
            return ImmutableList.of((Object)ladder, (Object)side_bar, (Object)connectionRight, (Object)connectionLeft, (Object)wrap, (Object)base, (Object)secondPole, (Object)baseConnected, (Object)connectionLeftBig, (Object)connectionRightBig, (Object)wrapBig, (Object)ladderTop, (Object[])new ResourceLocation[]{mergeLeft, mergeRight});
        }

        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            if (bakedLadder == null || bakedSideBar == null || bakedConnectionRight == null || bakedConnectionLeft == null || bakedWrap == null || bakedBase == null) {
                bakedLadder = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)ladder);
                bakedSideBar = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)side_bar);
                bakedConnectionRight = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)connectionRight);
                bakedConnectionLeft = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)connectionLeft);
                bakedWrap = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)wrap);
                bakedBase = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)base);
                bakedSecondPole = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)secondPole);
                bakedBaseConnected = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)baseConnected);
                bakedLeftBig = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)connectionLeftBig);
                bakedRightBig = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)connectionRightBig);
                bakedWrapBig = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)wrapBig);
                bakedLadderTop = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)ladderTop);
                bakedMergeLeft = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)mergeLeft);
                bakedMergeRight = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)mergeRight);
            }
            return new LadderModel(bakedLadder, bakedSideBar, bakedConnectionRight, bakedConnectionLeft, bakedWrap, bakedBase, bakedSecondPole, bakedBaseConnected, bakedLeftBig, bakedRightBig, bakedWrapBig, bakedLadderTop, bakedMergeLeft, bakedMergeRight, format, bakedTextureGetter);
        }
    }
}

