/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.trackers;

import info.ata4.minecraft.minema.MinemaAPI;
import mchorse.aperture.camera.CameraExporter;
import mchorse.aperture.client.gui.GuiMinemaPanel;
import mchorse.blockbuster_pack.trackers.BaseTracker;
import mchorse.mclib.utils.ReflectionUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;

public class MorphTracker
extends BaseTracker {
    private CameraExporter.TrackingPacket trackingPacket = null;
    private boolean combineTracking;
    private ApertureTracker apertureTracker;
    private MinemaTracker minemaTracker;

    public void setCombineTracking(boolean combineTracking) {
        this.combineTracking = combineTracking;
    }

    public boolean getCombineTracking() {
        return this.combineTracking;
    }

    @Override
    public void init() {
        if (Loader.isModLoaded((String)"minema")) {
            this.minemaTracker = new MinemaTracker();
        }
        if (Loader.isModLoaded((String)"aperture")) {
            this.apertureTracker = new ApertureTracker();
        }
    }

    @Override
    public void track(EntityLivingBase target, double x, double y, double z, float entityYaw, float partialTicks) {
        if (this.minemaTracker != null) {
            this.minemaTracker.track(this);
        }
        if (this.trackingPacket != null && this.trackingPacket.isReset()) {
            this.trackingPacket = null;
            return;
        }
        if (this.apertureTracker != null && !ReflectionUtils.isOptifineShadowPass() && !this.name.equals("")) {
            this.apertureTracker.track(this);
        }
    }

    @Override
    public boolean canMerge(BaseTracker tracker) {
        if (tracker instanceof MorphTracker) {
            MorphTracker apTracker = (MorphTracker)tracker;
            this.combineTracking = apTracker.combineTracking;
            return super.canMerge(tracker);
        }
        return false;
    }

    @Override
    public void copy(BaseTracker tracker) {
        if (tracker instanceof MorphTracker) {
            MorphTracker trackerAperture = (MorphTracker)tracker;
            this.combineTracking = trackerAperture.combineTracking;
        }
        super.copy(tracker);
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof MorphTracker) {
            MorphTracker morph = (MorphTracker)obj;
            result = super.equals(obj) && this.combineTracking == morph.combineTracking;
        }
        return result;
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        super.fromNBT(tag);
        this.combineTracking = tag.func_74767_n("CombineTracking");
    }

    @Override
    public NBTTagCompound toNBT(NBTTagCompound tag) {
        super.toNBT(tag);
        tag.func_74757_a("CombineTracking", this.combineTracking);
        return tag;
    }

    private static class ApertureTracker
    extends Tracker {
        private ApertureTracker() {
        }

        @Override
        @Optional.Method(modid="aperture")
        public void track(MorphTracker tracker) {
            if (GuiMinemaPanel.trackingExporter.isTracking()) {
                CameraExporter.TrackingPacket packet;
                if (tracker.trackingPacket == null && GuiMinemaPanel.trackingExporter.addTracker(packet = new CameraExporter.TrackingPacket(tracker.name, tracker.combineTracking))) {
                    tracker.trackingPacket = packet;
                }
                GuiMinemaPanel.trackingExporter.track(tracker.trackingPacket);
            }
        }
    }

    private static class MinemaTracker
    extends Tracker {
        private MinemaTracker() {
        }

        @Override
        @Optional.Method(modid="minema")
        public void track(MorphTracker tracker) {
            MinemaAPI.doTrack((String)tracker.name);
        }
    }

    private static class Tracker {
        private Tracker() {
        }

        public void track(MorphTracker tracker) {
        }
    }
}

