/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.morphs.structure;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import mchorse.blockbuster.network.client.ClientHandlerStructure;
import mchorse.blockbuster_pack.morphs.StructureMorph;
import mchorse.blockbuster_pack.morphs.structure.StructureStatus;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class StructureRenderer {
    public static int renderTimes = 0;
    public StructureStatus status = StructureStatus.UNLOADED;
    public Map<Biome, int[]> solidBuffers = new HashMap<Biome, int[]>();
    public Map<Biome, int[]> cutoutBuffers = new HashMap<Biome, int[]>();
    public Map<Biome, int[]> translucentBuffers = new HashMap<Biome, int[]>();
    public BlockPos size;
    public ClientHandlerStructure.FakeWorld world;
    public VertexFormat worldLighting;
    public VertexFormat structureLighting;
    public Map<TileEntity, Integer> tileEntityLighting = new LinkedHashMap<TileEntity, Integer>();

    public StructureRenderer() {
    }

    public StructureRenderer(BlockPos size, ClientHandlerStructure.FakeWorld world) {
        this.size = size;
        this.world = world;
        this.setupFormat();
        this.status = StructureStatus.LOADED;
    }

    public void setupFormat() {
        if (!DefaultVertexFormats.field_176600_a.equals((Object)this.structureLighting)) {
            this.solidBuffers.clear();
            this.structureLighting = DefaultVertexFormats.field_176600_a;
            this.worldLighting = new VertexFormat();
            for (VertexFormatElement element : this.structureLighting.func_177343_g()) {
                if (DefaultVertexFormats.field_181716_p.equals((Object)element)) {
                    this.worldLighting.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.SHORT, VertexFormatElement.EnumUsage.PADDING, 2));
                    continue;
                }
                this.worldLighting.func_181721_a(element);
            }
        }
    }

    public void rebuild(Biome biome) {
        this.world.biome = biome;
        int ao = Minecraft.func_71410_x().field_71474_y.field_74348_k;
        Minecraft.func_71410_x().field_71474_y.field_74348_k = 0;
        this.solidBuffers.put(biome, this.render(0));
        this.cutoutBuffers.put(biome, this.render(1));
        this.translucentBuffers.put(biome, this.render(2));
        Minecraft.func_71410_x().field_71474_y.field_74348_k = ao;
        if (this.tileEntityLighting.isEmpty()) {
            for (TileEntity te : this.world.field_147482_g) {
                this.tileEntityLighting.put(te, this.world.func_175626_b(te.func_174877_v(), 0));
            }
        }
    }

    public void render(StructureMorph morph) {
        GL11.glNormal3f((float)0.0f, (float)0.6f, (float)0.0f);
        Biome biome = morph.getBiome();
        if (this.solidBuffers.get(biome) == null) {
            this.setupFormat();
            this.rebuild(biome);
        }
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buffer = tess.func_178180_c();
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        if (this.solidBuffers.get(biome) != null && this.solidBuffers.get(biome).length > 0) {
            buffer.func_181668_a(7, morph.lighting ? this.worldLighting : this.structureLighting);
            buffer.func_178981_a(this.solidBuffers.get(biome));
            tess.func_78381_a();
        }
        GlStateManager.func_179141_d();
        if (this.cutoutBuffers.get(biome) != null && this.cutoutBuffers.get(biome).length > 0) {
            buffer.func_181668_a(7, morph.lighting ? this.worldLighting : this.structureLighting);
            buffer.func_178981_a(this.cutoutBuffers.get(biome));
            tess.func_78381_a();
        }
        GlStateManager.func_179147_l();
        if (this.translucentBuffers.get(biome) != null && this.translucentBuffers.get(biome).length > 0) {
            buffer.func_181668_a(7, morph.lighting ? this.worldLighting : this.structureLighting);
            buffer.func_178981_a(this.translucentBuffers.get(biome));
            tess.func_78381_a();
        }
    }

    public int[] render(int type) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buffer = tess.func_178180_c();
        buffer.func_181668_a(7, this.structureLighting);
        BlockPos origin = new BlockPos(1, 1, 1);
        int w = this.size.func_177958_n();
        int h = this.size.func_177956_o();
        int d = this.size.func_177952_p();
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        buffer.func_178969_c((double)((float)(-w) / 2.0f - (float)origin.func_177958_n()), (double)(-origin.func_177956_o()), (double)((float)(-d) / 2.0f - (float)origin.func_177952_p()));
        for (BlockPos.MutableBlockPos pos : BlockPos.func_177975_b((BlockPos)origin, (BlockPos)origin.func_177982_a(w, h, d))) {
            IBlockState state = this.world.func_180495_p((BlockPos)pos);
            Block block = state.func_177230_c();
            if (block.func_176223_P().func_185901_i() == EnumBlockRenderType.INVISIBLE || (type != 0 || block.func_180664_k() != BlockRenderLayer.SOLID) && (type != 1 || block.func_180664_k() != BlockRenderLayer.CUTOUT && block.func_180664_k() != BlockRenderLayer.CUTOUT_MIPPED) && (type != 2 || block.func_180664_k() != BlockRenderLayer.TRANSLUCENT)) continue;
            dispatcher.func_175018_a(state, (BlockPos)pos, (IBlockAccess)this.world, buffer);
        }
        buffer.func_178969_c(0.0, 0.0, 0.0);
        buffer.func_178977_d();
        int count = buffer.func_178989_h();
        int[] vertexData = new int[count * this.structureLighting.func_181719_f()];
        buffer.func_178966_f().asIntBuffer().get(vertexData);
        return vertexData;
    }

    public void renderTEs(StructureMorph morph) {
        if (renderTimes >= 10 || GL11.glGetInteger((int)2979) >= GL11.glGetInteger((int)3382) - 4) {
            return;
        }
        if (this.world == null) {
            return;
        }
        ++renderTimes;
        for (Map.Entry<TileEntity, Integer> entry : this.tileEntityLighting.entrySet()) {
            if (!morph.lighting) {
                int block = entry.getValue() % 65536;
                int sky = entry.getValue() / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)block, (float)sky);
            }
            TileEntity te = entry.getKey();
            BlockPos pos = te.func_174877_v();
            TileEntityRendererDispatcher.field_147556_a.func_147549_a(te, (double)pos.func_177958_n() - (double)this.size.func_177958_n() / 2.0 - 1.0, (double)(pos.func_177956_o() - 1), (double)pos.func_177952_p() - (double)this.size.func_177952_p() / 2.0 - 1.0, 0.0f);
            GlStateManager.func_179106_n();
        }
        --renderTimes;
    }

    public void delete() {
        if (!this.solidBuffers.isEmpty()) {
            this.solidBuffers.clear();
            this.tileEntityLighting.clear();
            this.status = StructureStatus.UNLOADED;
        }
    }
}

