/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.morphs;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import mchorse.blockbuster.utils.mclib.BBIcons;
import mchorse.mclib.utils.Interpolations;
import mchorse.mclib.utils.MathUtils;
import mchorse.mclib.utils.NBTUtils;
import mchorse.metamorph.api.Morph;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.models.IMorphProvider;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.Animation;
import mchorse.metamorph.api.morphs.utils.IAnimationProvider;
import mchorse.metamorph.api.morphs.utils.IMorphGenerator;
import mchorse.metamorph.api.morphs.utils.ISyncableMorph;
import mchorse.metamorph.bodypart.BodyPart;
import mchorse.metamorph.bodypart.IBodyPartProvider;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SequencerMorph
extends AbstractMorph
implements IMorphProvider,
ISyncableMorph,
IMorphGenerator {
    public List<SequenceEntry> morphs = new ArrayList<SequenceEntry>();
    public Morph currentMorph = new Morph();
    public int current;
    public int timer;
    @SideOnly(value=Side.CLIENT)
    public int screenTimer;
    public float duration;
    public float lastDuration;
    public boolean morphSetDuration;
    public int loopCount;
    public boolean isFirstMorph = false;
    public float lastUpdate;
    public boolean reverse;
    public boolean isRandom;
    public boolean isTrulyRandom;
    public int loop;
    public float[] offset = new float[3];
    public int offsetCount;
    public boolean keepProgress;
    private Animation animation = new Animation();
    private Random random = new Random();

    public SequencerMorph() {
        this.name = "sequencer";
    }

    public void pause(AbstractMorph previous, int offset) {
        this.animation.pause(offset);
        FoundMorph found = this.getMorphAt(offset);
        if (found == null) {
            return;
        }
        AbstractMorph morph = MorphUtils.copy((AbstractMorph)found.getCurrentMorph());
        if (found.previous != null) {
            AbstractMorph prevMorph = MorphUtils.copy((AbstractMorph)found.getPreviousMorph());
            MorphUtils.pause((AbstractMorph)prevMorph, (AbstractMorph)previous, (int)((int)found.getPreviousDuration()));
            found.applyPrevious(prevMorph);
            previous = prevMorph;
        }
        MorphUtils.pause((AbstractMorph)morph, (AbstractMorph)previous, (int)((int)((float)offset - found.lastDuration)));
        MorphUtils.resume((AbstractMorph)morph);
        found.applyCurrent(morph);
        this.currentMorph.setDirect(morph);
        this.timer = offset;
        this.duration = found.totalDuration;
        this.current = found.index;
        this.loopCount = found.loopCount;
        this.isFirstMorph = found.isFirstMorph;
        this.lastDuration = found.lastDuration;
        this.morphSetDuration = found.current.setDuration;
        this.lastUpdate = offset;
    }

    public boolean isPaused() {
        return this.animation.paused;
    }

    public void resume() {
        this.animation.paused = false;
        MorphUtils.resume((AbstractMorph)this.currentMorph.get());
    }

    public AbstractMorph getMorph() {
        AbstractMorph morph = this.currentMorph.get();
        float progress = this.timer;
        float duration = this.duration - this.lastDuration;
        if (this.morphSetDuration) {
            if (duration > 0.0f) {
                float setDuration = (float)Math.ceil(duration);
                float ticks = (progress - this.lastDuration) * setDuration / duration;
                int tick = (int)ticks * 10000;
                this.updateSetDuration(morph, tick, (int)setDuration * 10000);
            } else {
                this.updateSetDuration(morph, 1, 1);
            }
        }
        return morph;
    }

    public boolean canGenerate() {
        AbstractMorph morph = this.currentMorph.get();
        if (morph instanceof IMorphGenerator) {
            return ((IMorphGenerator)morph).canGenerate();
        }
        return false;
    }

    public AbstractMorph genCurrentMorph(float partialTicks) {
        AbstractMorph morph = this.currentMorph.get();
        if (morph instanceof IMorphGenerator) {
            float setDuration;
            float ticks;
            int tick;
            float progress = (float)this.timer + partialTicks;
            float duration = this.duration - this.lastDuration;
            if (this.morphSetDuration && duration > 0.0f && this.updateSetDuration(morph, tick = (int)(ticks = (progress - this.lastDuration) * (setDuration = (float)Math.ceil(duration)) / duration), (int)setDuration)) {
                partialTicks = ticks - (float)tick;
            }
            return ((IMorphGenerator)morph).genCurrentMorph(partialTicks);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    protected String getSubclassDisplayName() {
        return I18n.func_135052_a((String)"blockbuster.morph.sequencer", (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOnScreen(EntityPlayer player, int x, int y, float scale, float alpha) {
        if (this.morphs.isEmpty()) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            BBIcons.CHICKEN.render(x - 8, y - 20);
            return;
        }
        ++this.screenTimer;
        this.screenTimer %= 2000;
        FoundMorph found = this.getMorphAt(this.screenTimer);
        AbstractMorph morph = MorphUtils.copy((AbstractMorph)found.getCurrentMorph());
        AbstractMorph prevMorph = MorphUtils.copy((AbstractMorph)found.getPreviousMorph());
        MorphUtils.pause((AbstractMorph)morph, (AbstractMorph)prevMorph, (int)((int)((float)this.screenTimer - found.lastDuration)));
        if (morph != null) {
            MorphUtils.renderOnScreen((AbstractMorph)morph, (EntityPlayer)player, (int)x, (int)y, (float)scale, (float)alpha);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(EntityLivingBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
        float progress = (float)this.timer + partialTicks;
        if (!this.isPaused()) {
            this.updateClient(entity, progress);
            partialTicks = progress - this.lastDuration;
            partialTicks -= (float)((int)partialTicks);
        } else {
            partialTicks = 0.0f;
            progress = this.timer;
        }
        AbstractMorph morph = this.currentMorph.get();
        if (morph != null) {
            if (this.offsetCount > -1) {
                Animation anim;
                int times = this.loopCount % (this.offsetCount + 1);
                double baseMul = 0.0625 * (double)(this.reverse ? -1 : 1);
                double offsetMul = baseMul * (double)times;
                Vec3d offset = new Vec3d((double)this.offset[0] * offsetMul, (double)this.offset[1] * offsetMul, (double)this.offset[2] * offsetMul);
                if (this.isFirstMorph && !this.currentMorph.isEmpty() && this.currentMorph.get() instanceof IAnimationProvider && (anim = ((IAnimationProvider)this.currentMorph.get()).getAnimation()).isInProgress()) {
                    double lastMul = baseMul * (double)(times - 1);
                    double lerpX = anim.interp.interpolate((double)this.offset[0] * lastMul, (double)this.offset[0] * offsetMul, (double)anim.getFactor(partialTicks));
                    double lerpY = anim.interp.interpolate((double)this.offset[1] * lastMul, (double)this.offset[1] * offsetMul, (double)anim.getFactor(partialTicks));
                    double lerpZ = anim.interp.interpolate((double)this.offset[2] * lastMul, (double)this.offset[2] * offsetMul, (double)anim.getFactor(partialTicks));
                    offset = new Vec3d(lerpX, lerpY, lerpZ);
                }
                float yaw = Interpolations.lerpYaw((float)entity.field_70760_ar, (float)entity.field_70761_aq, (float)partialTicks);
                offset = offset.func_178785_b((float)Math.toRadians(-yaw));
                x += offset.field_72450_a;
                y += offset.field_72448_b;
                z += offset.field_72449_c;
            }
            float duration = this.duration - this.lastDuration;
            if (this.morphSetDuration) {
                if (duration > 0.0f) {
                    float setDuration = (float)Math.ceil(duration);
                    float ticks = (progress - this.lastDuration) * setDuration / duration;
                    int tick = (int)ticks;
                    if (this.updateSetDuration(morph, tick, (int)setDuration)) {
                        partialTicks = ticks - (float)tick;
                    }
                } else {
                    this.updateSetDuration(morph, 1, 1);
                }
            }
            MorphUtils.render((AbstractMorph)morph, (EntityLivingBase)entity, (double)x, (double)y, (double)z, (float)entityYaw, (float)partialTicks);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderHand(EntityPlayer player, EnumHand hand) {
        AbstractMorph morph = this.currentMorph.get();
        if (morph != null) {
            return morph.renderHand(player, hand);
        }
        return false;
    }

    private Random getRandomSeed(float duration) {
        if (this.isTrulyRandom) {
            this.random.setSeed(System.nanoTime());
        } else {
            this.random.setSeed((long)(duration * 100000.0f));
        }
        return this.random;
    }

    public AbstractMorph getRandom() {
        if (this.morphs.isEmpty()) {
            return null;
        }
        double factor = this.isTrulyRandom ? Math.random() : this.random.nextDouble();
        return this.get((int)(factor * (double)this.morphs.size()));
    }

    public int getRandomIndex(float duration) {
        return (int)(this.getRandomSeed(duration * 2.0f + 5.0f).nextFloat() * (float)this.morphs.size());
    }

    public AbstractMorph get(int index) {
        if (index >= this.morphs.size() || index < 0) {
            return null;
        }
        return this.morphs.get((int)index).morph;
    }

    public FoundMorph getMorphAt(int tick) {
        int i;
        if (this.morphs.isEmpty() || tick < 0) {
            return null;
        }
        float duration = this.getMaxDuration();
        int size = this.morphs.size();
        if (duration <= 0.0f) {
            return new FoundMorph(size - 1, this.morphs.get(size - 1), size == 1 ? null : this.morphs.get(size - 2), 0.0f, 0.0f, 0.0f, 0, false);
        }
        SequenceEntry entry = null;
        SequenceEntry lastEntry = null;
        int lastIndex = i = this.reverse ? size - 1 : 0;
        duration = 0.0f;
        if (this.isRandom) {
            i = this.getRandomIndex(duration);
        }
        float lastDuration = 0.0f;
        float prevLastDuration = 0.0f;
        int loopCount = 0;
        int lastLoopCount = 0;
        boolean isFirstMorph = false;
        boolean lastIsFirstMorph = false;
        do {
            prevLastDuration = lastDuration;
            lastDuration = duration;
            lastEntry = entry;
            lastLoopCount = loopCount;
            lastIsFirstMorph = isFirstMorph;
            entry = this.morphs.get(i);
            lastIndex = i;
            if (entry != null && entry.endPoint && this.loop > 0 && loopCount >= this.loop - 1) break;
            isFirstMorph = false;
            if (this.isRandom) {
                if (entry != null && entry.endPoint) {
                    ++loopCount;
                    isFirstMorph = true;
                }
                i = this.getRandomIndex(duration);
                continue;
            }
            int next = i + (this.reverse ? -1 : 1);
            int current = MathUtils.cycler((int)next, (int)0, (int)(size - 1));
            if (current != next) {
                if (this.loop > 0 && loopCount >= this.loop - 1) break;
                ++loopCount;
                isFirstMorph = true;
            }
            i = current;
        } while ((duration += entry.getDuration(this.getRandomSeed(duration))) < (float)tick);
        return entry == null ? null : new FoundMorph(lastIndex, entry, lastEntry, duration, lastDuration, prevLastDuration, lastLoopCount, lastIsFirstMorph);
    }

    public int getTickAt(int index) {
        if (this.morphs.isEmpty() || index < 0 || this.getMaxDuration() < 1.0E-4f || this.isRandom && this.isTrulyRandom) {
            return (int)this.getDuration();
        }
        int size = this.morphs.size();
        int i = -1;
        float duration = 0.0f;
        int loopCount = 0;
        while (i != index) {
            SequenceEntry entry = null;
            if (i > 0 && i < size) {
                entry = this.morphs.get(i);
            }
            if (entry != null && entry.endPoint && this.loop > 0 && this.loopCount >= this.loop - 1) break;
            if (this.isRandom) {
                if (entry != null && entry.endPoint) {
                    ++loopCount;
                }
                i = this.getRandomIndex(duration);
            } else {
                int next = i + (this.reverse ? -1 : 1);
                int current = MathUtils.cycler((int)next, (int)0, (int)(size - 1));
                if (current != next) {
                    if (this.loop > 0 && loopCount >= this.loop - 1) break;
                    this.loopCount = i == -1 ? 0 : ++this.loopCount;
                }
                i = current;
            }
            duration += this.morphs.get(i).getDuration(this.getRandomSeed(duration));
        }
        return (int)duration;
    }

    public float getDuration() {
        float duration = 0.0f;
        for (SequenceEntry entry : this.morphs) {
            duration += entry.getDuration(this.getRandomSeed(duration));
        }
        return duration;
    }

    public float getMaxDuration() {
        float duration = 0.0f;
        for (SequenceEntry entry : this.morphs) {
            duration += entry.duration + Math.max(entry.random, 0.0f);
        }
        return duration;
    }

    public void update(EntityLivingBase target) {
        this.updateCycle();
        AbstractMorph morph = this.currentMorph.get();
        if (morph != null) {
            morph.update(target);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateClient(EntityLivingBase entity, float progress) {
        this.updateMorph(progress);
    }

    protected void updateCycle() {
        if (this.isPaused()) {
            return;
        }
        this.updateMorph(this.timer);
        ++this.timer;
    }

    protected void updateMorph(float timer) {
        while (!this.morphs.isEmpty() && timer >= this.duration) {
            int size = this.morphs.size();
            SequenceEntry entry = null;
            if (this.current >= 0 && this.current < size) {
                entry = this.morphs.get(this.current);
            }
            if (entry != null && entry.endPoint && this.loop > 0 && this.loopCount >= this.loop - 1) break;
            this.isFirstMorph = false;
            if (this.isRandom) {
                if (entry != null && entry.endPoint) {
                    ++this.loopCount;
                    this.isFirstMorph = true;
                }
                this.current = this.getRandomIndex(this.duration);
            } else {
                int next = this.current + (this.reverse ? -1 : 1);
                int current = MathUtils.cycler((int)next, (int)0, (int)(size - 1));
                if (current != next) {
                    if (this.loop > 0 && this.loopCount >= this.loop - 1) {
                        return;
                    }
                    this.loopCount = this.current == -1 ? 0 : ++this.loopCount;
                    this.isFirstMorph = true;
                }
                this.current = current;
            }
            if (this.current >= 0 && this.current < size) {
                entry = this.morphs.get(this.current);
                AbstractMorph morph = MorphUtils.copy((AbstractMorph)entry.morph);
                float duration = entry.getDuration(this.getRandomSeed(this.duration));
                this.updateProgress(this.currentMorph.get(), (int)(this.duration - this.lastDuration) - (int)Math.max(this.lastUpdate - this.lastDuration, 0.0f));
                if (this.morphSetDuration) {
                    this.updateSetDuration(this.currentMorph.get(), 1, 1);
                }
                this.currentMorph.set(morph);
                this.lastDuration = this.duration;
                this.duration += duration;
                this.morphSetDuration = entry.setDuration;
            }
            if (!((double)(this.duration - this.lastDuration) < 1.0E-4) || !((double)this.getMaxDuration() < 1.0E-4)) continue;
            break;
        }
    }

    protected boolean updateSetDuration(AbstractMorph morph, int progress, int duration) {
        boolean result = false;
        if (!(morph instanceof SequencerMorph) && morph instanceof IMorphProvider) {
            result |= this.updateSetDuration(((IMorphProvider)morph).getMorph(), progress, duration);
        }
        if (morph instanceof IAnimationProvider) {
            ((IAnimationProvider)morph).getAnimation().duration = duration;
            ((IAnimationProvider)morph).getAnimation().progress = progress;
            result = true;
        }
        if (morph instanceof IBodyPartProvider) {
            for (BodyPart part : ((IBodyPartProvider)morph).getBodyPart().parts) {
                result |= this.updateSetDuration(part.morph.get(), progress, duration);
            }
        }
        return result;
    }

    protected void updateProgress(AbstractMorph morph, int progress) {
        if (!(morph instanceof SequencerMorph) && morph instanceof IMorphProvider) {
            this.updateProgress(((IMorphProvider)morph).getMorph(), progress);
        }
        if (morph instanceof IAnimationProvider) {
            ((IAnimationProvider)morph).getAnimation().progress += progress;
        }
        if (morph instanceof IBodyPartProvider) {
            for (BodyPart part : ((IBodyPartProvider)morph).getBodyPart().parts) {
                this.updateProgress(part.morph.get(), progress);
            }
        }
    }

    public AbstractMorph create() {
        return new SequencerMorph();
    }

    public void copy(AbstractMorph from) {
        super.copy(from);
        if (from instanceof SequencerMorph) {
            SequencerMorph morph = (SequencerMorph)from;
            for (SequenceEntry entry : morph.morphs) {
                this.morphs.add(entry.clone());
            }
            this.reverse = morph.reverse;
            this.isRandom = morph.isRandom;
            this.isTrulyRandom = morph.isTrulyRandom;
            this.currentMorph.copy(morph.currentMorph);
            this.timer = morph.timer;
            this.current = morph.current;
            this.duration = morph.duration;
            this.loop = morph.loop;
            this.offset[0] = morph.offset[0];
            this.offset[1] = morph.offset[1];
            this.offset[2] = morph.offset[2];
            this.offsetCount = morph.offsetCount;
            this.keepProgress = morph.keepProgress;
        }
    }

    public float getWidth(EntityLivingBase target) {
        AbstractMorph morph = this.currentMorph.get();
        return morph == null ? 0.0f : morph.getWidth(target);
    }

    public float getHeight(EntityLivingBase target) {
        AbstractMorph morph = this.currentMorph.get();
        return morph == null ? 0.0f : morph.getHeight(target);
    }

    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (obj instanceof SequencerMorph) {
            SequencerMorph seq = (SequencerMorph)((Object)obj);
            result = result && Objects.equals(this.morphs, seq.morphs);
            result = result && this.reverse == seq.reverse;
            result = result && this.isRandom == seq.isRandom;
            result = result && this.isTrulyRandom == seq.isTrulyRandom;
            result = result && this.loop == seq.loop;
            result = result && Objects.deepEquals(this.offset, seq.offset);
            result = result && this.offsetCount == seq.offsetCount;
            result = result && this.keepProgress == seq.keepProgress;
        }
        return result;
    }

    public boolean canMerge(AbstractMorph morph) {
        if (morph instanceof SequencerMorph) {
            SequencerMorph sequencer = (SequencerMorph)morph;
            if (!sequencer.morphs.equals(this.morphs)) {
                this.mergeBasic(morph);
                this.morphs.clear();
                for (SequenceEntry entry : sequencer.morphs) {
                    this.morphs.add(entry.clone());
                }
                this.current = -1;
                this.duration = 0.0f;
                if (!sequencer.keepProgress) {
                    this.timer = 0;
                }
                this.reverse = sequencer.reverse;
                this.isRandom = sequencer.isRandom;
                this.loopCount = 0;
                this.isFirstMorph = false;
                this.loop = sequencer.loop;
                this.offset[0] = sequencer.offset[0];
                this.offset[1] = sequencer.offset[1];
                this.offset[2] = sequencer.offset[2];
                this.offsetCount = sequencer.offsetCount;
                this.lastDuration = 0.0f;
                this.lastUpdate = 0.0f;
                return true;
            }
        }
        return super.canMerge(morph);
    }

    public void afterMerge(AbstractMorph morph) {
        super.afterMerge(morph);
        this.currentMorph.setDirect(morph);
        this.current = -1;
        this.duration = 0.0f;
        this.timer = 0;
        this.loopCount = 0;
        this.isFirstMorph = false;
        this.lastDuration = 0.0f;
        this.lastUpdate = 0.0f;
        if (morph instanceof SequencerMorph) {
            SequencerMorph sequencer = (SequencerMorph)morph;
            if (this.keepProgress) {
                this.timer = sequencer.timer;
            }
        }
    }

    public void reset() {
        super.reset();
        this.current = -1;
        this.timer = 0;
        this.duration = 0.0f;
        this.loopCount = 0;
        this.reverse = false;
        this.currentMorph.setDirect(null);
        this.morphs.clear();
        this.loop = 0;
        this.offset[2] = 0.0f;
        this.offset[1] = 0.0f;
        this.offset[0] = 0.0f;
        this.offsetCount = 0;
        this.lastUpdate = 0.0f;
        this.keepProgress = false;
    }

    public void toNBT(NBTTagCompound tag) {
        super.toNBT(tag);
        if (this.reverse) {
            tag.func_74757_a("Reverse", this.reverse);
        }
        if (this.isRandom) {
            tag.func_74757_a("Random", this.isRandom);
        }
        if (this.isTrulyRandom) {
            tag.func_74757_a("TrulyRandom", this.isTrulyRandom);
        }
        if (this.loop > 0) {
            tag.func_74768_a("Loop", this.loop);
        }
        tag.func_74782_a("Offset", (NBTBase)NBTUtils.writeFloatList((NBTTagList)new NBTTagList(), (float[])this.offset));
        if (this.offsetCount > 0) {
            tag.func_74768_a("OffsetCount", this.offsetCount);
        }
        if (this.keepProgress) {
            tag.func_74757_a("KeepProgress", this.keepProgress);
        }
        if (!this.morphs.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (SequenceEntry entry : this.morphs) {
                list.func_74742_a((NBTBase)entry.toNBT());
            }
            tag.func_74782_a("List", (NBTBase)list);
        }
    }

    public void fromNBT(NBTTagCompound tag) {
        super.fromNBT(tag);
        if (tag.func_74764_b("Reverse")) {
            this.reverse = tag.func_74767_n("Reverse");
        }
        if (tag.func_74764_b("Random")) {
            this.isRandom = tag.func_74767_n("Random");
        }
        if (tag.func_74764_b("TrulyRandom")) {
            this.isTrulyRandom = tag.func_74767_n("TrulyRandom");
        }
        if (tag.func_74764_b("Loop")) {
            this.loop = tag.func_74762_e("Loop");
        }
        if (tag.func_74764_b("Offset")) {
            NBTUtils.readFloatList((NBTTagList)tag.func_150295_c("Offset", 5), (float[])this.offset);
        }
        if (tag.func_74764_b("OffsetCount")) {
            this.offsetCount = tag.func_74762_e("OffsetCount");
        }
        if (tag.func_74764_b("KeepProgress")) {
            this.keepProgress = tag.func_74767_n("KeepProgress");
        }
        if (tag.func_150297_b("List", 9)) {
            NBTTagList list = tag.func_150295_c("List", 10);
            int c = list.func_74745_c();
            for (int i = 0; i < c; ++i) {
                SequenceEntry entry = new SequenceEntry();
                entry.fromNBT(list.func_150305_b(i));
                this.morphs.add(entry);
            }
            this.current = -1;
            this.duration = 0.0f;
            this.timer = 0;
            this.loopCount = 0;
            this.lastUpdate = 0.0f;
        }
    }

    public static class FoundMorph {
        public int index;
        public SequenceEntry current;
        public SequenceEntry previous;
        public float totalDuration;
        public float lastDuration;
        public float prevLastDuration;
        public int loopCount;
        public boolean isFirstMorph;

        public FoundMorph(int index, SequenceEntry current, SequenceEntry previous, float totalDuration, float lastDuration, float prevLastDuration, int loopCount, boolean isFirstMorph) {
            this.index = index;
            this.current = current;
            this.previous = previous;
            this.totalDuration = totalDuration;
            this.lastDuration = lastDuration;
            this.prevLastDuration = prevLastDuration;
            this.loopCount = loopCount;
            this.isFirstMorph = isFirstMorph;
        }

        public AbstractMorph getCurrentMorph() {
            return this.current == null ? null : this.current.morph;
        }

        public AbstractMorph getPreviousMorph() {
            return this.previous == null ? null : this.previous.morph;
        }

        public float getCurrentDuration() {
            return this.totalDuration - this.lastDuration;
        }

        public float getPreviousDuration() {
            return this.lastDuration - this.prevLastDuration;
        }

        public void applyCurrent(AbstractMorph morph) {
            if (this.current.setDuration && morph instanceof IAnimationProvider) {
                ((IAnimationProvider)morph).getAnimation().duration = (int)this.getCurrentDuration();
            }
        }

        public void applyPrevious(AbstractMorph morph) {
            if (this.previous.setDuration && morph instanceof IAnimationProvider) {
                ((IAnimationProvider)morph).getAnimation().duration = (int)this.getPreviousDuration();
            }
        }
    }

    public static class SequenceEntry {
        public AbstractMorph morph;
        public float duration = 10.0f;
        public float random = 0.0f;
        public boolean setDuration;
        public boolean endPoint;

        public SequenceEntry() {
        }

        public SequenceEntry(AbstractMorph morph) {
            this.morph = morph;
        }

        public SequenceEntry(AbstractMorph morph, float duration) {
            this(morph, duration, 0.0f);
        }

        public SequenceEntry(AbstractMorph morph, float duration, float random) {
            this(morph, duration, random, true);
        }

        public SequenceEntry(AbstractMorph morph, float duration, float random, boolean setDuration) {
            this(morph, duration, random, setDuration, false);
        }

        public SequenceEntry(AbstractMorph morph, float duration, float random, boolean setDuration, boolean endPoint) {
            this.morph = morph;
            this.duration = duration;
            this.random = random;
            this.setDuration = setDuration;
            this.endPoint = endPoint;
        }

        public float getDuration(Random random) {
            return this.duration + (this.random != 0.0f ? random.nextFloat() * this.random : 0.0f);
        }

        public SequenceEntry clone() {
            return new SequenceEntry(MorphUtils.copy((AbstractMorph)this.morph), this.duration, this.random, this.setDuration, this.endPoint);
        }

        public boolean equals(Object obj) {
            if (obj instanceof SequenceEntry) {
                SequenceEntry entry = (SequenceEntry)obj;
                return Objects.equals(this.morph, entry.morph) && this.duration == entry.duration && this.random == entry.random && this.setDuration == entry.setDuration && this.endPoint == entry.endPoint;
            }
            return super.equals(obj);
        }

        public NBTTagCompound toNBT() {
            NBTTagCompound entryTag = new NBTTagCompound();
            if (this.morph != null) {
                entryTag.func_74782_a("Morph", (NBTBase)this.morph.toNBT());
            }
            entryTag.func_74776_a("Duration", this.duration);
            entryTag.func_74776_a("Random", this.random);
            entryTag.func_74757_a("SetDuration", this.setDuration);
            entryTag.func_74757_a("EndPoint", this.endPoint);
            return entryTag;
        }

        public void fromNBT(NBTTagCompound tag) {
            if (tag.func_150297_b("Morph", 10)) {
                this.morph = MorphManager.INSTANCE.morphFromNBT(tag.func_74775_l("Morph"));
            }
            if (tag.func_150297_b("Duration", 99)) {
                this.duration = tag.func_74760_g("Duration");
            }
            if (tag.func_150297_b("Random", 99)) {
                this.random = tag.func_74760_g("Random");
            }
            this.setDuration = tag.func_74764_b("SetDuration") && tag.func_74767_n("SetDuration");
            this.endPoint = tag.func_74764_b("EndPoint") && tag.func_74767_n("EndPoint");
        }
    }
}

