/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.morphs;

import com.jme3.math.Vector3f;
import dz.betterlights.BetterLightsMod;
import dz.betterlights.lighting.lightcasters.LightCaster;
import dz.betterlights.lighting.lightcasters.StaticLightCaster;
import dz.betterlights.lighting.lightcasters.features.ILightConfig;
import dz.betterlights.utils.ConfigProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.client.RenderingHandler;
import mchorse.blockbuster.client.render.tileentity.TileEntityGunItemStackRenderer;
import mchorse.blockbuster.client.render.tileentity.TileEntityModelItemStackRenderer;
import mchorse.blockbuster.events.TickHandler;
import mchorse.blockbuster.utils.ExpirableRunnable;
import mchorse.blockbuster_pack.morphs.BetterLightsMorphTemplate;
import mchorse.blockbuster_pack.trackers.ApertureCamera;
import mchorse.mclib.client.gui.framework.elements.GuiModelRenderer;
import mchorse.mclib.client.render.VertexBuilder;
import mchorse.mclib.config.values.GenericBaseValue;
import mchorse.mclib.config.values.GenericNumberValue;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueBoolean;
import mchorse.mclib.config.values.ValueColor;
import mchorse.mclib.config.values.ValueDouble;
import mchorse.mclib.config.values.ValueFloat;
import mchorse.mclib.config.values.ValueInt;
import mchorse.mclib.utils.BetterLightsHelper;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.Interpolations;
import mchorse.mclib.utils.MatrixUtils;
import mchorse.mclib.utils.OptifineHelper;
import mchorse.mclib.utils.RenderingUtils;
import mchorse.mclib.utils.ValueSerializer;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.Animation;
import mchorse.metamorph.api.morphs.utils.IAnimationProvider;
import mchorse.metamorph.api.morphs.utils.IMorphGenerator;
import mchorse.metamorph.api.morphs.utils.ISyncableMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.joml.Matrix3d;
import org.joml.Vector3dc;
import org.lwjgl.opengl.GL11;

public class BetterLightsMorph
extends BetterLightsMorphTemplate
implements IAnimationProvider,
ISyncableMorph,
IMorphGenerator {
    private BetterLightsRunnable dummy;
    private Object lightCaster;
    private final Vector3d position = new Vector3d();
    private final Vector3d prevPosition = new Vector3d();
    private final Matrix4d rotation = new Matrix4d();
    private boolean updateTick = false;
    private boolean renderedInHand = false;
    private boolean renderedItemGui = false;
    private boolean enableAlways = false;
    private final BetterLightsProperties properties = new BetterLightsProperties();
    private BetterLightsAnimation animation = new BetterLightsAnimation();
    private final ValueSerializer values = new ValueSerializer();
    private NBTTagCompound nbt;

    public BetterLightsMorph() {
        this.name = "betterLights";
        this.values.copy(BetterLightsProperties.TEMPLATE);
    }

    public ValueSerializer getValueManager() {
        return this.values;
    }

    public boolean isEnableAlways() {
        return this.enableAlways;
    }

    public void setEnableAlways(boolean enableAlways) {
        this.enableAlways = enableAlways;
    }

    public boolean isMorphEnabled() {
        return (Boolean)Blockbuster.enableBetterLights.get() != false || this.enableAlways;
    }

    @Optional.Method(modid="better_lights")
    public LightCaster getLightcaster() {
        if (this.lightCaster == null) {
            StaticLightCaster lightCaster = new StaticLightCaster();
            lightCaster.setPermanent(true);
            this.lightCaster = lightCaster;
        }
        return (LightCaster)this.lightCaster;
    }

    @Optional.Method(modid="better_lights")
    public void update(EntityLivingBase target) {
        this.updateTick = true;
        if (target.field_70170_p.field_72995_K && (!this.renderedItemGui || this.renderedInHand) && this.isMorphEnabled()) {
            this.createDummyEntitiy(target);
            this.dummy.setLifetime(this.dummy.getAge() + 1);
        }
        this.animation.update();
        super.update(target);
    }

    @SideOnly(value=Side.CLIENT)
    private void updateAnimation(float partialTicks) {
        this.properties.from(this);
        if (this.animation.isInProgress()) {
            this.animation.apply(this.properties, partialTicks);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="better_lights")
    protected void createDummyEntitiy() {
        this.createDummyEntitiy(null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="better_lights")
    protected void createDummyEntitiy(@Nullable EntityLivingBase target) {
        if ((this.dummy == null || this.dummy.shouldRemove()) && this.isMorphEnabled()) {
            if (this.position.equals((Tuple3d)new Vector3d(0.0, 0.0, 0.0)) && target != null) {
                this.position.set(target.field_70165_t, target.field_70163_u, target.field_70161_v);
                this.prevPosition.set(target.field_70165_t, target.field_70163_u, target.field_70161_v);
            }
            this.dummy = new BetterLightsRunnable((World)Minecraft.func_71410_x().field_71441_e, this.getLightcaster(), 0);
            this.updateLightcaster();
            this.addToWorld();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="better_lights")
    protected void addToWorld() {
        Blockbuster.proxy.tickHandler.addRunnable(TickHandler.WorldClientTickEvent.class, Side.CLIENT, TickEvent.Phase.START, this.dummy);
        BetterLightsMod.getLightManager().addTemporaryLightCaster((World)Minecraft.func_71410_x().field_71441_e, this.getLightcaster(), false);
    }

    @Override
    @Optional.Method(modid="better_lights")
    protected void updateLightcaster() {
        BetterLightsProperties.APPLY.forEach(consumer -> consumer.accept(this));
        this.getLightcaster().pos((float)this.position.x, (float)this.position.y, (float)this.position.z);
    }

    public void renderOnScreen(EntityPlayer entityPlayer, int x, int y, float scale, float alpha) {
        float partial = Minecraft.func_71410_x().func_184121_ak();
        this.updateAnimation(partial);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)((float)y - scale / 2.0f), (float)0.0f);
        GL11.glScalef((float)1.35f, (float)-1.35f, (float)1.35f);
        RenderingUtils.renderImage((ResourceLocation)new ResourceLocation("blockbuster", "textures/spotlight.png"), (float)scale);
        Optional oValue = this.properties.values.getValue("Color");
        if (oValue.isPresent()) {
            Color color = (Color)((ValueColor)oValue.get()).get();
            RenderingUtils.renderImage((ResourceLocation)new ResourceLocation("blockbuster", "textures/spotlight_light.png"), (float)scale, (Color)color);
        }
        GL11.glPopMatrix();
    }

    @Override
    @Optional.Method(modid="better_lights")
    public void render(EntityLivingBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
        boolean itemRendering;
        if (OptifineHelper.isOptifineShadowPass() || ApertureCamera.enable) {
            return;
        }
        this.updateAnimation(partialTicks);
        EntityLivingBase lastItemHolder = RenderingHandler.getLastItemHolder();
        ItemCameraTransforms.TransformType itemTransformType = RenderingHandler.itemTransformType;
        boolean renderedInHands = lastItemHolder != null && (itemTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || itemTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND);
        boolean renderedInThirdPerson = lastItemHolder != null && (itemTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND || itemTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
        boolean bl = itemRendering = TileEntityModelItemStackRenderer.isRendering() || TileEntityGunItemStackRenderer.isRendering();
        if (this.updateTick) {
            this.renderedInHand = false;
            this.renderedItemGui = false;
            this.updateTick = false;
        }
        if (renderedInHands || renderedInThirdPerson) {
            this.renderedInHand = true;
        }
        if (itemTransformType == ItemCameraTransforms.TransformType.GUI && itemRendering) {
            this.renderedItemGui = true;
        }
        GlStateManager.func_179094_E();
        GL11.glTranslated((double)x, (double)y, (double)z);
        Matrix4d[] transformation = MatrixUtils.getTransformation();
        transformation[1].transpose();
        this.rotation.set(transformation[1]);
        if (renderedInThirdPerson || lastItemHolder == null && (!itemRendering || itemTransformType == ItemCameraTransforms.TransformType.GROUND)) {
            this.position.x = (float)transformation[0].m03;
            this.position.y = (float)transformation[0].m13;
            this.position.z = (float)transformation[0].m23;
        } else if (renderedInHands) {
            this.position.x = (float)Interpolations.lerp((double)lastItemHolder.field_70169_q, (double)lastItemHolder.field_70165_t, (double)partialTicks);
            this.position.y = (float)Interpolations.lerp((double)lastItemHolder.field_70167_r, (double)lastItemHolder.field_70163_u, (double)partialTicks) + lastItemHolder.func_70047_e();
            this.position.z = (float)Interpolations.lerp((double)lastItemHolder.field_70166_s, (double)lastItemHolder.field_70161_v, (double)partialTicks);
            double offsetZ = lastItemHolder.func_174813_aQ().field_72334_f - lastItemHolder.func_174813_aQ().field_72339_c;
            Vector3d offset = new Vector3d(0.0, 0.0, offsetZ);
            this.rotation.transform(offset);
            this.position.add((Tuple3d)offset);
        }
        if (GuiModelRenderer.isRendering() && this.isMorphEnabled()) {
            this.createDummyEntitiy(entity);
            this.dummy.setLifetime(this.dummy.getAge() + 2);
        }
        this.updateLightcaster();
        if ((Minecraft.func_71410_x().field_71474_y.field_74330_P || GuiModelRenderer.isRendering()) && this.lightCaster != null) {
            this.renderSpotlightCone(2);
        }
        this.prevPosition.set((Tuple3d)this.position);
        GlStateManager.func_179121_F();
    }

    @Optional.Method(modid="better_lights")
    protected void renderSpotlightCone(int lineThickness) {
        float outerRadius = this.getLightcaster().getDistance() * (float)Math.tan(Math.toRadians(this.getLightcaster().getOuterAngle()));
        float innerRadius = Math.min(outerRadius, this.getLightcaster().getDistance() * (float)Math.tan(Math.toRadians(this.getLightcaster().getInnerAngle())));
        GenericNumberValue x = (GenericNumberValue)this.properties.values.getValue("DirectionX").flatMap(v -> Optional.ofNullable(v instanceof GenericNumberValue ? v : null)).orElse(new ValueDouble("", 0.0));
        GenericNumberValue y = (GenericNumberValue)this.properties.values.getValue("DirectionY").flatMap(v -> Optional.ofNullable(v instanceof GenericNumberValue ? v : null)).orElse(new ValueDouble("", 0.0));
        GenericNumberValue z = (GenericNumberValue)this.properties.values.getValue("DirectionZ").flatMap(v -> Optional.ofNullable(v instanceof GenericNumberValue ? v : null)).orElse(new ValueDouble("", 1.0));
        org.joml.Vector3d direction = new org.joml.Vector3d(((Number)x.get()).doubleValue(), ((Number)y.get()).doubleValue(), ((Number)z.get()).doubleValue());
        Vector3d directionNorm = new Vector3d(0.0, 0.0, (double)this.getLightcaster().getDistance());
        org.joml.Vector3d rot = new Matrix3d().rotateTowards((Vector3dc)direction, (Vector3dc)new org.joml.Vector3d(0.0, 0.0, 1.0)).getEulerAnglesXYZ(new org.joml.Vector3d());
        Color color = new Color(this.getLightcaster().getColor().x, this.getLightcaster().getColor().y, this.getLightcaster().getColor().z);
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(rot.x)), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(rot.y)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(rot.z)), (float)0.0f, (float)0.0f, (float)1.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        if (GuiModelRenderer.isRendering()) {
            GlStateManager.func_179097_i();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        RenderingUtils.renderCircle((Vector3d)directionNorm, (Vector3d)directionNorm, (float)outerRadius, (int)32, (Color)color, (float)lineThickness);
        RenderingUtils.renderCircleDotted((Vector3d)directionNorm, (Vector3d)directionNorm, (float)innerRadius, (int)32, (Color)color, (float)lineThickness, (int)1);
        builder.func_181668_a(3, VertexBuilder.getFormat((boolean)true, (boolean)false, (boolean)false, (boolean)false));
        GL11.glLineWidth((float)lineThickness);
        builder.func_181662_b(0.0, 0.0, 0.0).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        builder.func_181662_b((double)outerRadius, 0.0, (double)this.getLightcaster().getDistance()).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        builder.func_181662_b(0.0, 0.0, 0.0).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        builder.func_181662_b((double)(-outerRadius), 0.0, (double)this.getLightcaster().getDistance()).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        builder.func_181662_b(0.0, 0.0, 0.0).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        builder.func_181662_b(0.0, (double)outerRadius, (double)this.getLightcaster().getDistance()).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        builder.func_181662_b(0.0, 0.0, 0.0).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        builder.func_181662_b(0.0, (double)(-outerRadius), (double)this.getLightcaster().getDistance()).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
        if (GuiModelRenderer.isRendering()) {
            GlStateManager.func_179126_j();
        }
    }

    public boolean useTargetDefault() {
        return true;
    }

    public AbstractMorph create() {
        return new BetterLightsMorph();
    }

    public float getWidth(EntityLivingBase entityLivingBase) {
        return 0.0f;
    }

    public float getHeight(EntityLivingBase entityLivingBase) {
        return 0.0f;
    }

    public void fromNBT(NBTTagCompound tag) {
        super.fromNBT(tag);
        this.nbt = tag.func_74737_b();
        this.values.fromNBT(tag);
        if (tag.func_74764_b("Animation")) {
            this.animation.fromNBT(tag.func_74775_l("Animation"));
        }
        if (tag.func_74764_b("EnableAlways")) {
            this.enableAlways = tag.func_74767_n("EnableAlways");
        }
    }

    public void toNBT(NBTTagCompound tag) {
        super.toNBT(tag);
        if (BetterLightsHelper.isBetterLightsLoaded()) {
            this.values.toNBT(tag);
            NBTTagCompound animation = this.animation.toNBT();
            if (!animation.func_82582_d()) {
                tag.func_74782_a("Animation", (NBTBase)animation);
            }
            tag.func_74778_a("UUID", UUID.randomUUID().toString());
        } else if (this.nbt != null) {
            for (String key : this.nbt.func_150296_c()) {
                tag.func_74782_a(key, this.nbt.func_74781_a(key));
            }
        }
        if (this.enableAlways) {
            tag.func_74757_a("EnableAlways", this.enableAlways);
        }
    }

    public boolean canMerge(AbstractMorph morph0) {
        if (morph0 instanceof BetterLightsMorph) {
            BetterLightsMorph morph = (BetterLightsMorph)morph0;
            this.mergeBasic(morph0);
            if (!morph.animation.ignored) {
                if (this.animation.isInProgress()) {
                    BetterLightsProperties newLast = new BetterLightsProperties();
                    newLast.from(this);
                    this.animation.apply(newLast, 0.0f);
                    this.animation.last = newLast;
                } else {
                    this.animation.last = new BetterLightsProperties();
                    this.animation.last.from(this);
                }
                this.animation.merge(this, morph);
                this.copy(morph);
                this.animation.progress = 0;
            } else {
                this.animation.ignored = true;
            }
            return true;
        }
        return super.canMerge(morph0);
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public boolean canGenerate() {
        return this.animation.isInProgress();
    }

    public AbstractMorph genCurrentMorph(float partialTicks) {
        BetterLightsMorph morph = (BetterLightsMorph)this.copy();
        morph.properties.from(this);
        morph.animation.last = new BetterLightsProperties();
        morph.animation.last.from(this);
        morph.animation.apply(morph.properties, partialTicks);
        morph.animation.duration = this.animation.progress;
        return morph;
    }

    public void pause(AbstractMorph previous, int offset) {
        this.animation.pause(offset);
        if (previous instanceof BetterLightsMorph) {
            BetterLightsMorph morph = (BetterLightsMorph)previous;
            if (morph.animation.isInProgress()) {
                BetterLightsProperties newLast = new BetterLightsProperties();
                newLast.from(morph);
                morph.animation.apply(newLast, 1.0f);
                this.animation.last = newLast;
            } else {
                this.animation.last = new BetterLightsProperties();
                this.animation.last.from(morph);
            }
        }
    }

    public boolean isPaused() {
        return this.animation.paused;
    }

    public void reset() {
        super.reset();
        this.animation.reset();
    }

    public boolean equals(Object object) {
        boolean result = super.equals(object);
        if (object instanceof BetterLightsMorph) {
            BetterLightsMorph morph = (BetterLightsMorph)((Object)object);
            result = result && this.values.equalsValues(morph.values);
            result = result && Objects.equals((Object)morph.animation, (Object)this.animation);
            result = result && this.enableAlways == morph.enableAlways;
            return result;
        }
        return result;
    }

    public void copy(AbstractMorph from) {
        super.copy(from);
        if (from instanceof BetterLightsMorph) {
            BetterLightsMorph morph = (BetterLightsMorph)from;
            if (morph.nbt != null) {
                this.nbt = morph.nbt.func_74737_b();
            }
            this.values.copyValues(morph.values);
            this.animation.copy(morph.animation);
            this.animation.reset();
            this.enableAlways = morph.enableAlways;
        }
    }

    public static class BetterLightsRunnable
    extends ExpirableRunnable {
        private final Object lightcaster;
        private final World world;

        public BetterLightsRunnable(World world, Object lightCaster, int lifetime) {
            super(lifetime);
            this.lightcaster = lightCaster;
            this.world = world;
        }

        @Override
        @Optional.Method(modid="better_lights")
        public void run() {
            super.run();
            if (this.lightcaster == null) {
                return;
            }
            if (this.shouldRemove()) {
                BetterLightsMod.getLightManager().removeLightCaster(this.world, (LightCaster)this.lightcaster, false);
            }
        }
    }

    private static class FieldHierarchy {
        private Field field;
        private FieldHierarchy parent;

        public FieldHierarchy(Field field) {
            this.field = field;
            this.field.setAccessible(true);
        }

        public FieldHierarchy(FieldHierarchy parent, Field field) {
            this.field = field;
            this.field.setAccessible(true);
            this.parent = parent;
        }

        private Object getFieldHolder(Object root) {
            if (this.parent != null) {
                return this.parent.getValue(root);
            }
            return root;
        }

        private Object getValue(Object root) {
            try {
                if (this.parent != null) {
                    return this.field.get(this.parent.getValue(root));
                }
                return this.field.get(root);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
        }

        public void setField(Object root, Object value) {
            Object fieldHolder = this.getFieldHolder(root);
            if (fieldHolder != null) {
                try {
                    this.field.set(fieldHolder, value);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class BetterLightsProperties {
        public static final Value valueTree = new Value("");
        private static final ValueSerializer TEMPLATE = new ValueSerializer();
        private static final List<Consumer<BetterLightsMorph>> APPLY = new ArrayList<Consumer<BetterLightsMorph>>();
        private final ValueSerializer values = new ValueSerializer();

        @Optional.Method(modid="better_lights")
        private static void generate() {
            StaticLightCaster lightCaster = new StaticLightCaster();
            lightCaster.direction(0.0f, 0.0f, 1.0f);
            lightCaster.color(1.0f, 0.905f, 0.584f);
            BetterLightsProperties.generateValuesTemplate(LightCaster.class, null, valueTree, (LightCaster)lightCaster);
        }

        @Optional.Method(modid="better_lights")
        private static void generateValuesTemplate(Class<?> clazz, @Nullable FieldHierarchy parentField, Value parent, LightCaster defaultLightCaster) {
            if (ILightConfig.class.isAssignableFrom(clazz)) {
                boolean defaultValue;
                if (parentField == null) {
                    defaultValue = defaultLightCaster.isEnabled();
                } else {
                    Object value = parentField.getValue(defaultLightCaster);
                    if (value == null) {
                        return;
                    }
                    defaultValue = ((ILightConfig)value).isEnabled();
                }
                ValueBoolean vb = new ValueBoolean("Enabled", defaultValue);
                parent.addSubValue((Value)vb);
                TEMPLATE.registerValue((GenericBaseValue)vb).serializeNBT(vb.getPath(), true);
                APPLY.add(morph -> {
                    LightCaster lightCaster = morph.getLightcaster();
                    ((BetterLightsMorph)morph).properties.values.getValue(vb.getPath()).ifPresent(genericBaseValue -> {
                        Boolean bool = (Boolean)genericBaseValue.get();
                        if (parentField == null) {
                            lightCaster.setEnabled(bool.booleanValue());
                        } else {
                            Object value = parentField.getValue(lightCaster);
                            if (value == null) {
                                return;
                            }
                            ((ILightConfig)value).setEnabled(bool.booleanValue());
                        }
                    });
                });
            }
            for (Field field : clazz.getDeclaredFields()) {
                ValueFloat vf;
                Object value;
                FieldHierarchy fieldSetter = new FieldHierarchy(field);
                if (parentField != null) {
                    fieldSetter.parent = parentField;
                }
                field.setAccessible(true);
                ConfigProperty configProperty = field.getAnnotation(ConfigProperty.class);
                if (configProperty == null || configProperty.name().equals("Position")) continue;
                String name = configProperty.name();
                if (field.getType().equals(Float.TYPE)) {
                    float defaultValue = 0.0f;
                    if (configProperty.defaultValue().isEmpty()) {
                        value = fieldSetter.getValue(defaultLightCaster);
                        defaultValue = value == null ? 0.0f : ((Float)value).floatValue();
                    } else {
                        try {
                            defaultValue = Float.parseFloat(configProperty.defaultValue());
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    }
                    vf = new ValueFloat(name, defaultValue, configProperty.min(), configProperty.max());
                    parent.addSubValue((Value)vf);
                    BetterLightsProperties.registerBasicValue(vf, fieldSetter);
                    continue;
                }
                if (field.getType().equals(Integer.TYPE)) {
                    int defaultValue = 0;
                    if (configProperty.defaultValue().isEmpty()) {
                        value = fieldSetter.getValue(defaultLightCaster);
                        defaultValue = value == null ? 0 : (Integer)value;
                    } else {
                        try {
                            defaultValue = Integer.parseInt(configProperty.defaultValue());
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    }
                    vf = new ValueInt(name, defaultValue, (int)configProperty.min(), (int)configProperty.max());
                    parent.addSubValue((Value)vf);
                    BetterLightsProperties.registerBasicValue(vf, fieldSetter);
                    continue;
                }
                if (field.getType().equals(Vector3f.class)) {
                    Vector3f defaultValue;
                    Object value2 = fieldSetter.getValue(defaultLightCaster);
                    Vector3f vector3f = defaultValue = value2 == null ? new Vector3f() : (Vector3f)value2;
                    if (configProperty.type().equals((Object)ConfigProperty.EnumPropertyType.COLOR_PICKER)) {
                        ValueColor vc = new ValueColor(name, new Color(defaultValue.x, defaultValue.y, defaultValue.z));
                        parent.addSubValue((Value)vc);
                        TEMPLATE.registerValue((GenericBaseValue)vc).serializeNBT(vc.getPath(), true);
                        APPLY.add(morph -> {
                            LightCaster lightCaster = morph.getLightcaster();
                            ((BetterLightsMorph)morph).properties.values.getValue(vc.getPath()).ifPresent(genericBaseValue -> {
                                Color c = (Color)genericBaseValue.get();
                                fieldSetter.setField(lightCaster, new Vector3f(c.r, c.g, c.b));
                            });
                        });
                        continue;
                    }
                    ValueFloat vfx = new ValueFloat(name + "X", defaultValue.x);
                    ValueFloat vfy = new ValueFloat(name + "Y", defaultValue.y);
                    ValueFloat vfz = new ValueFloat(name + "Z", defaultValue.z);
                    parent.addSubValue((Value)vfx);
                    parent.addSubValue((Value)vfy);
                    parent.addSubValue((Value)vfz);
                    TEMPLATE.registerValue((GenericBaseValue)vfx).serializeNBT(vfx.getPath(), true);
                    TEMPLATE.registerValue((GenericBaseValue)vfy).serializeNBT(vfy.getPath(), true);
                    TEMPLATE.registerValue((GenericBaseValue)vfz).serializeNBT(vfz.getPath(), true);
                    APPLY.add(morph -> {
                        LightCaster lightCaster = morph.getLightcaster();
                        Optional vx = ((BetterLightsMorph)morph).properties.values.getValue(vfx.getPath());
                        Optional vy = ((BetterLightsMorph)morph).properties.values.getValue(vfy.getPath());
                        Optional vz = ((BetterLightsMorph)morph).properties.values.getValue(vfz.getPath());
                        if (!(vx.isPresent() && vy.isPresent() && vz.isPresent())) {
                            return;
                        }
                        javax.vecmath.Vector3f vec = new javax.vecmath.Vector3f(((Float)((GenericBaseValue)vx.get()).get()).floatValue(), ((Float)((GenericBaseValue)vy.get()).get()).floatValue(), ((Float)((GenericBaseValue)vz.get()).get()).floatValue());
                        if (name.equals("Direction")) {
                            ((BetterLightsMorph)morph).rotation.transform(vec);
                        }
                        fieldSetter.setField(lightCaster, new Vector3f(vec.x, vec.y, vec.z));
                    });
                    continue;
                }
                if (field.getType().equals(Boolean.TYPE)) {
                    boolean defaultValue = configProperty.defaultValue().isEmpty() ? (value = fieldSetter.getValue(defaultLightCaster)) != null && (Boolean)value != false : Boolean.parseBoolean(configProperty.defaultValue());
                    ValueBoolean vb = new ValueBoolean(name, defaultValue);
                    parent.addSubValue((Value)vb);
                    BetterLightsProperties.registerBasicValue(vb, fieldSetter);
                    continue;
                }
                if (!ILightConfig.class.isAssignableFrom(field.getType())) continue;
                Value subCategory = new Value(configProperty.name());
                parent.addSubValue(subCategory);
                BetterLightsProperties.generateValuesTemplate(field.getType(), fieldSetter, subCategory, defaultLightCaster);
            }
        }

        private static void registerBasicValue(GenericBaseValue<?> value, FieldHierarchy fieldSetter) {
            TEMPLATE.registerValue(value).serializeNBT(value.getPath(), true);
            APPLY.add(morph -> {
                LightCaster lightCaster = morph.getLightcaster();
                ((BetterLightsMorph)morph).properties.values.getValue(value.getPath()).ifPresent(genericBaseValue -> fieldSetter.setField(lightCaster, genericBaseValue.get()));
            });
        }

        public BetterLightsProperties() {
            this.values.copy(TEMPLATE);
        }

        public void from(BetterLightsMorph from) {
            this.values.copyValues(from.values);
        }

        static {
            try {
                Class.forName("dz.betterlights.lighting.lightcasters.LightCaster");
                BetterLightsProperties.generate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class BetterLightsAnimation
    extends Animation {
        public BetterLightsProperties last;

        public void merge(BetterLightsMorph last, BetterLightsMorph next) {
            this.merge(next.animation);
            if (this.last == null) {
                this.last = new BetterLightsProperties();
            }
            this.last.from(last);
        }

        public void apply(BetterLightsProperties properties, float partialTicks) {
            if (this.last == null) {
                return;
            }
            float factor = this.getFactor(partialTicks);
            properties.values.interpolateFrom(this.interp, this.last.values, factor);
        }
    }
}

