/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.client.gui;

import java.util.ArrayList;
import java.util.List;
import mchorse.blockbuster.ClientProxy;
import mchorse.blockbuster.client.gui.dashboard.panels.model_editor.utils.GuiPoseTransformations;
import mchorse.blockbuster_pack.client.gui.GuiCustomMorph;
import mchorse.blockbuster_pack.morphs.ImageMorph;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiModelRenderer;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiCirculateElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiColorElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTexturePicker;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.Label;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.RenderingUtils;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.Animation;
import mchorse.metamorph.client.gui.creative.GuiMorphRenderer;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiAnimation;
import mchorse.metamorph.client.gui.editor.GuiMorphPanel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

@SideOnly(value=Side.CLIENT)
public class GuiImageMorph
extends GuiAbstractMorph<ImageMorph> {
    public GuiImageMorphPanel general;

    public GuiImageMorph(Minecraft mc) {
        super(mc);
        this.general = new GuiImageMorphPanel(mc, this);
        this.defaultPanel = this.general;
        this.registerPanel(this.general, IKey.lang((String)"blockbuster.morph.image"), Icons.GEAR);
        this.keys().register(IKey.lang((String)"blockbuster.gui.builder.pick_texture"), 18, () -> {
            if (!this.general.picker.hasParent()) {
                this.general.texture.clickItself(GuiBase.getCurrent());
            }
        }).held(new int[]{42});
    }

    protected GuiModelRenderer createMorphRenderer(Minecraft mc) {
        return new GuiMorphRenderer(mc){

            protected void drawUserModel(GuiContext context) {
                if (this.morph != null) {
                    MorphUtils.render((AbstractMorph)this.morph, (EntityLivingBase)this.entity, (double)0.0, (double)0.0, (double)0.0, (float)0.0f, (float)context.partialTicks);
                }
            }
        };
    }

    public boolean canEdit(AbstractMorph morph) {
        return morph instanceof ImageMorph;
    }

    public List<Label<NBTTagCompound>> getPresets(ImageMorph morph) {
        ArrayList<Label<NBTTagCompound>> list = new ArrayList<Label<NBTTagCompound>>();
        GuiCustomMorph.addSkins(morph, list, "Texture", ClientProxy.tree.getByPath("image/skins", null));
        return list;
    }

    public static class GuiImageMorphPanel
    extends GuiMorphPanel<ImageMorph, GuiImageMorph> {
        public static final RenderingUtils.Facing[] SORTED_FACING_MODES = new RenderingUtils.Facing[]{RenderingUtils.Facing.ROTATE_XYZ, RenderingUtils.Facing.ROTATE_Y, RenderingUtils.Facing.LOOKAT_XYZ, RenderingUtils.Facing.LOOKAT_Y};
        public GuiPoseTransformations pose;
        public GuiTexturePicker picker;
        public GuiButtonElement texture;
        public GuiTrackpadElement scale;
        public GuiToggleElement shaded;
        public GuiToggleElement lighting;
        public GuiToggleElement billboard;
        public GuiToggleElement removeParentScaleRotation;
        public GuiLabel facingModeLabel;
        public GuiCirculateElement facingMode;
        public GuiTrackpadElement left;
        public GuiTrackpadElement right;
        public GuiTrackpadElement top;
        public GuiTrackpadElement bottom;
        public GuiToggleElement resizeCrop;
        public GuiColorElement color;
        public GuiTrackpadElement offsetX;
        public GuiTrackpadElement offsetY;
        public GuiTrackpadElement rotation;
        public GuiToggleElement keying;
        public GuiToggleElement thickness;
        public GuiToggleElement shadow;
        public GuiAnimation animation;

        public GuiImageMorphPanel(Minecraft mc, GuiImageMorph editor) {
            super(mc, (GuiAbstractMorph)editor);
            this.pose = new GuiPoseTransformations(mc);
            this.pose.flex().relative((IResizer)this.area).set(0.0f, 0.0f, 256.0f, 70.0f).x(0.5f, -128).y(1.0f, -75);
            this.texture = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.builder.pick_texture"), b -> {
                this.picker.refresh();
                this.picker.fill(((ImageMorph)this.morph).texture);
                this.add((IGuiElement)this.picker);
                this.picker.resize();
            });
            this.shaded = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.shading"), false, b -> {
                ((ImageMorph)this.morph).shaded = b.isToggled();
            });
            this.lighting = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.lighting"), false, b -> {
                ((ImageMorph)this.morph).lighting = b.isToggled();
            });
            this.billboard = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.billboard"), false, b -> {
                ((ImageMorph)this.morph).billboard = b.isToggled();
                if (b.isToggled()) {
                    ((ImageMorph)this.morph).removeParentScaleRotation = true;
                    this.removeParentScaleRotation.toggled(true);
                }
            });
            this.picker = new GuiTexturePicker(mc, rl -> {
                ((ImageMorph)this.morph).texture = rl;
            });
            this.removeParentScaleRotation = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.image.remove_parent_space_effects"), false, b -> {
                ((ImageMorph)this.morph).removeParentScaleRotation = b.isToggled();
            });
            this.removeParentScaleRotation.tooltip(IKey.lang((String)"blockbuster.gui.image.remove_parent_space_effects_tooltip"));
            this.facingMode = new GuiCirculateElement(mc, b -> {
                ((ImageMorph)this.morph).facing = SORTED_FACING_MODES[this.facingMode.getValue()];
            });
            this.facingMode.addLabel(IKey.lang((String)"blockbuster.gui.snowstorm.appearance.camera_facing.rotate_xyz"));
            this.facingMode.addLabel(IKey.lang((String)"blockbuster.gui.snowstorm.appearance.camera_facing.rotate_y"));
            this.facingMode.addLabel(IKey.lang((String)"blockbuster.gui.snowstorm.appearance.camera_facing.lookat_xyz"));
            this.facingMode.addLabel(IKey.lang((String)"blockbuster.gui.snowstorm.appearance.camera_facing.lookat_y"));
            this.facingModeLabel = Elements.label((IKey)IKey.lang((String)"blockbuster.gui.snowstorm.appearance.camera_facing.label"), (int)20).anchor(0.0f, 0.5f);
            this.left = new GuiTrackpadElement(mc, value -> {
                ((ImageMorph)this.morph).crop.x = value.intValue();
            });
            this.left.tooltip(IKey.lang((String)"blockbuster.gui.image.left"));
            this.left.integer();
            this.right = new GuiTrackpadElement(mc, value -> {
                ((ImageMorph)this.morph).crop.z = value.intValue();
            });
            this.right.tooltip(IKey.lang((String)"blockbuster.gui.image.right"));
            this.right.integer();
            this.top = new GuiTrackpadElement(mc, value -> {
                ((ImageMorph)this.morph).crop.y = value.intValue();
            });
            this.top.tooltip(IKey.lang((String)"blockbuster.gui.image.top"));
            this.top.integer();
            this.bottom = new GuiTrackpadElement(mc, value -> {
                ((ImageMorph)this.morph).crop.w = value.intValue();
            });
            this.bottom.tooltip(IKey.lang((String)"blockbuster.gui.image.bottom"));
            this.bottom.integer();
            this.resizeCrop = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.image.resize_crop"), false, b -> {
                ((ImageMorph)this.morph).resizeCrop = b.isToggled();
            });
            this.color = new GuiColorElement(mc, value -> {
                ((ImageMorph)this.morph).color = value;
            }).direction(Direction.TOP);
            this.color.picker.editAlpha();
            this.offsetX = new GuiTrackpadElement(mc, value -> {
                ((ImageMorph)this.morph).offsetX = value.floatValue();
            });
            this.offsetX.tooltip(IKey.lang((String)"blockbuster.gui.image.offset_x"));
            this.offsetY = new GuiTrackpadElement(mc, value -> {
                ((ImageMorph)this.morph).offsetY = value.floatValue();
            });
            this.offsetY.tooltip(IKey.lang((String)"blockbuster.gui.image.offset_y"));
            this.rotation = new GuiTrackpadElement(mc, value -> {
                ((ImageMorph)this.morph).rotation = value.floatValue();
            });
            this.rotation.tooltip(IKey.lang((String)"blockbuster.gui.image.rotation"));
            this.keying = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.image.keying"), false, b -> {
                ((ImageMorph)this.morph).keying = b.isToggled();
            });
            this.keying.tooltip(IKey.lang((String)"blockbuster.gui.image.keying_tooltip"), Direction.TOP);
            this.thickness = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.image.thickness"), false, b -> {
                ((ImageMorph)this.morph).thickness = b.isToggled();
            });
            this.thickness.tooltip(IKey.lang((String)"blockbuster.gui.image.thickness_tooltip"), Direction.TOP);
            this.shadow = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.image.shadow"), false, b -> {
                ((ImageMorph)this.morph).shadow = b.isToggled();
            });
            this.shadow.tooltip(IKey.lang((String)"blockbuster.gui.image.shadow_tooltip"), Direction.TOP);
            this.picker.flex().relative((IResizer)this.area).wh(1.0f, 1.0f);
            GuiScrollElement column = new GuiScrollElement(mc);
            column.scroll.opposite = true;
            column.flex().relative((GuiElement)this).w(150).h(1.0f).column(5).vertical().stretch().scroll().height(20).padding(10);
            column.add(new IGuiElement[]{this.texture, this.scale, this.shaded, this.lighting, this.billboard, this.removeParentScaleRotation, this.facingModeLabel, this.facingMode, Elements.label((IKey)IKey.lang((String)"blockbuster.gui.image.crop"))});
            column.add(new IGuiElement[]{this.left, this.right, this.top, this.bottom, this.resizeCrop, this.color, this.offsetX, this.offsetY, this.rotation, this.keying, this.thickness, this.shadow});
            this.animation = new GuiAnimation(mc, true);
            this.animation.flex().relative((GuiElement)this).x(1.0f, -130).w(130);
            this.add(new IGuiElement[]{this.pose, column, this.animation});
        }

        public void fillData(ImageMorph morph) {
            super.fillData((AbstractMorph)morph);
            this.picker.removeFromParent();
            this.pose.set(morph.pose);
            this.shaded.toggled(morph.shaded);
            this.lighting.toggled(morph.lighting);
            this.billboard.toggled(morph.billboard);
            this.removeParentScaleRotation.toggled(morph.removeParentScaleRotation);
            this.facingMode.setValue(ArrayUtils.indexOf((Object[])SORTED_FACING_MODES, (Object)((ImageMorph)this.morph).facing));
            this.left.setValue((double)morph.crop.x);
            this.right.setValue((double)morph.crop.z);
            this.top.setValue((double)morph.crop.y);
            this.bottom.setValue((double)morph.crop.w);
            this.resizeCrop.toggled(morph.resizeCrop);
            this.color.picker.setColor(morph.color);
            this.offsetX.setValue((double)morph.offsetX);
            this.offsetY.setValue((double)morph.offsetY);
            this.keying.toggled(morph.keying);
            this.thickness.toggled(morph.thickness);
            this.shadow.toggled(morph.shadow);
            this.animation.fill((Animation)morph.animation);
        }

        public void finishEditing() {
            this.picker.close();
            super.finishEditing();
        }

        public void draw(GuiContext context) {
            this.mc.field_71446_o.func_110577_a(((ImageMorph)this.morph).texture);
            int w = ((ImageMorph)this.morph).getWidth();
            int h = ((ImageMorph)this.morph).getHeight();
            String label = I18n.func_135052_a((String)"blockbuster.gui.image.dimensions", (Object[])new Object[]{w, h});
            this.font.func_175063_a(label, (float)this.area.x(0.5f, this.font.func_78256_a(label)), (float)(this.area.y + 16), 0xAAAAAA);
            super.draw(context);
        }
    }
}

