/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mchorse.blockbuster_pack.morphs.BetterLightsMorph;
import mchorse.mclib.client.gui.framework.elements.GuiCollapseSection;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiColorElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.modals.GuiModal;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.GuiUtils;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.config.values.GenericNumberValue;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueBoolean;
import mchorse.mclib.config.values.ValueColor;
import mchorse.mclib.utils.BetterLightsHelper;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.Direction;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiAnimation;
import mchorse.metamorph.client.gui.editor.GuiMorphPanel;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiBetterLightsMorph
extends GuiAbstractMorph<BetterLightsMorph> {
    public GuiBetterLightsMorph(Minecraft mc) {
        super(mc);
        this.defaultPanel = new GuiBetterLightsMorphPanel(mc, this);
        this.registerPanel(this.defaultPanel, IKey.lang((String)"blockbuster.gui.betterlights_morph.name"), Icons.GEAR);
    }

    public boolean canEdit(AbstractMorph morph) {
        return morph instanceof BetterLightsMorph;
    }

    public static class GuiBetterLightsMessage
    extends GuiModal {
        public GuiBetterLightsMessage(Minecraft mc, IKey label) {
            super(mc, label);
            GuiButtonElement button = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.betterlights_morph.mod_page_button"), b -> GuiUtils.openWebLink((String)"https://www.patreon.com/user?u=30961255"));
            this.bar.add((IGuiElement)button);
        }
    }

    public static class GuiBetterLightsMorphPanel
    extends GuiMorphPanel<BetterLightsMorph, GuiBetterLightsMorph> {
        private GuiAnimation animation;
        private final List<Consumer<BetterLightsMorph>> apply = new ArrayList<Consumer<BetterLightsMorph>>();
        private GuiToggleElement enableAlways;

        public GuiBetterLightsMorphPanel(Minecraft mc, GuiBetterLightsMorph editor) {
            super(mc, (GuiAbstractMorph)editor);
            this.animation = new GuiAnimation(mc, true);
            this.animation.flex().column(0).padding(0);
            this.animation.ignored.removeFromParent();
            this.animation.interpolations.removeFromParent();
            this.enableAlways = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.betterlights_morph.enable_always"), b -> ((BetterLightsMorph)this.morph).setEnableAlways(b.isToggled()));
            GuiElement left = new GuiElement(mc);
            left.flex().relative((GuiElement)this).x(0.0f).w(200).h(1.0f).column(0).vertical().stretch().padding(10);
            GuiLabel sponsors = Elements.label((IKey)IKey.lang((String)"blockbuster.gui.betterlights_morph.sponsored_title"));
            sponsors.tooltip(IKey.comp((IKey[])new IKey[]{IKey.lang((String)"blockbuster.gui.betterlights_morph.sponsored_tooltip"), IKey.str((String)"\n\nMarlon\nHerr Bergmann\nAreon Pictures\nJunder\nPhoenixMedia\nLouis Angerer\nGewenzsko\nKatzen48")}));
            left.add((IGuiElement)sponsors);
            this.add((IGuiElement)left);
            if (BetterLightsHelper.isBetterLightsLoaded()) {
                GuiScrollElement scroll = new GuiScrollElement(mc);
                scroll.flex().relative((GuiElement)this).x(1.0f).w(200).h(1.0f).anchorX(1.0f).column(5).vertical().stretch().scroll().padding(10);
                scroll.add(new IGuiElement[]{this.enableAlways, this.animation});
                this.generateUITree((GuiElement)scroll, BetterLightsMorph.BetterLightsProperties.valueTree);
                this.add(new IGuiElement[]{scroll, this.animation.interpolations});
            } else {
                GuiBetterLightsMessage modal = new GuiBetterLightsMessage(this.mc, IKey.lang((String)"blockbuster.gui.betterlights_morph.not_installed_message"));
                modal.flex().relative((GuiElement)this).x(0.5f).y(0.5f).anchorX(0.5f).anchorY(0.5f).w(128).h(128);
                this.add((IGuiElement)modal);
            }
        }

        private void generateUITree(GuiElement parentElement, Value value) {
            for (Value subValue : value.getSubValues()) {
                String path = subValue.getPath();
                String langPath = "blockbuster.gui.betterlights_morph.options." + path.toLowerCase().replace(" ", "_");
                if (subValue instanceof ValueBoolean) {
                    this.addToggleElement(parentElement, path, langPath);
                } else if (subValue instanceof GenericNumberValue) {
                    this.addTrackpad(parentElement, (GenericNumberValue)subValue, path, langPath);
                } else if (subValue instanceof ValueColor) {
                    this.addColor(parentElement, path, langPath);
                }
                if (subValue.getSubValues().size() == 0) continue;
                GuiCollapseSection section = new GuiCollapseSection(this.mc, IKey.lang((String)(langPath + ".title")));
                section.setCollapsed(true);
                parentElement.add((IGuiElement)section);
                this.generateUITree((GuiElement)section, subValue);
            }
        }

        private void addColor(GuiElement parentElement, String path, String langPath) {
            GuiColorElement color = new GuiColorElement(this.mc, value -> ((BetterLightsMorph)this.morph).getValueManager().getValue(path).ifPresent(v -> v.setValue((Object)new Color(value.intValue())))).direction(Direction.TOP);
            color.picker.editAlpha();
            color.tooltip(IKey.lang((String)langPath));
            parentElement.add((IGuiElement)color);
            this.apply.add(morph -> morph.getValueManager().getValue(path).ifPresent(v -> color.picker.setColor(((Color)v.get()).getRGBAColor())));
        }

        private void addTrackpad(GuiElement parentElement, GenericNumberValue<?> numberValue, String path, String langPath) {
            GuiTrackpadElement trackpad = new GuiTrackpadElement(this.mc, value -> ((BetterLightsMorph)this.morph).getValueManager().getValue(path).ifPresent(v -> v.setValue((Object)Float.valueOf(value.floatValue()))));
            trackpad.tooltip(IKey.lang((String)(langPath + "_tooltip")));
            trackpad.limit(numberValue.getMin().doubleValue(), numberValue.getMax().doubleValue());
            boolean isInteger = numberValue.isInteger();
            if (isInteger) {
                trackpad.integer();
            }
            parentElement.add((IGuiElement)trackpad);
            this.apply.add(morph -> morph.getValueManager().getValue(path).ifPresent(genericBaseValue -> {
                if (!(genericBaseValue instanceof GenericNumberValue)) {
                    return;
                }
                GenericNumberValue numberValue0 = (GenericNumberValue)genericBaseValue;
                trackpad.setValue(isInteger ? (double)((Number)numberValue0.get()).longValue() : ((Number)numberValue0.get()).doubleValue());
            }));
        }

        private void addToggleElement(GuiElement parentElement, String path, String langPath) {
            GuiToggleElement toggleElement = new GuiToggleElement(this.mc, IKey.lang((String)langPath), v -> ((BetterLightsMorph)this.morph).getValueManager().getValue(path).ifPresent(value -> value.setValue((Object)v.isToggled())));
            parentElement.add((IGuiElement)toggleElement);
            this.apply.add(morph -> morph.getValueManager().getValue(path).ifPresent(genericBaseValue -> toggleElement.toggled(((Boolean)genericBaseValue.get()).booleanValue())));
        }

        public void fillData(BetterLightsMorph morph) {
            super.fillData((AbstractMorph)morph);
            this.animation.fill(morph.getAnimation());
            this.apply.forEach(consumer -> consumer.accept(morph));
            this.enableAlways.toggled(morph.isEnableAlways());
        }
    }
}

