/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording.scene;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.recording.Utils;
import mchorse.blockbuster.recording.data.Mode;
import mchorse.blockbuster.recording.scene.Replay;
import mchorse.blockbuster.recording.scene.Scene;
import mchorse.blockbuster.recording.scene.SceneSender;
import mchorse.mclib.utils.Patterns;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class SceneManager {
    private Map<String, Scene> scenes = new ConcurrentHashMap<String, Scene>();
    private List<String> toRemove = new ArrayList<String>();
    private Map<String, Scene> toPut = new HashMap<String, Scene>();
    private boolean ticking;

    public Map<String, Scene> getScenes() {
        return new HashMap<String, Scene>(this.scenes);
    }

    public static boolean isValidFilename(String filename) {
        return !filename.isEmpty() && Patterns.FILENAME.matcher(filename).matches();
    }

    public void reset() {
        this.ticking = false;
        this.toRemove.clear();
        this.toPut.clear();
        this.scenes.clear();
    }

    public void worldTick(World world) {
        for (Map.Entry<String, Scene> entry : this.scenes.entrySet()) {
            Scene scene = entry.getValue();
            scene.worldTick(world);
        }
    }

    public void tick() {
        this.ticking = true;
        try {
            for (Map.Entry<String, Scene> entry : this.scenes.entrySet()) {
                Scene scene = entry.getValue();
                scene.tick();
                if (scene.playing) continue;
                this.toRemove.add(entry.getKey());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ticking = false;
        for (String scene : this.toRemove) {
            this.scenes.remove(scene);
        }
        this.scenes.putAll(this.toPut);
        this.toRemove.clear();
        this.toPut.clear();
    }

    public boolean play(String filename, World world) {
        Scene scene = this.get(filename, world);
        if (scene == null) {
            return false;
        }
        scene.startPlayback(0);
        return true;
    }

    public void record(String filename, String record, EntityPlayerMP player) {
        this.record(filename, record, 0, player);
    }

    public void record(String filename, String record, int offset, EntityPlayerMP player) {
        Scene scene = this.get(filename, player.field_70170_p);
        if (scene != null) {
            scene.setWorld(player.field_70170_p);
            Replay replay = scene.getByFile(record);
            if (replay != null) {
                CommonProxy.manager.record(replay.id, (EntityPlayer)player, Mode.ACTIONS, replay.teleportBack, true, offset, () -> {
                    if (!CommonProxy.manager.recorders.containsKey(player)) {
                        this.put(filename, scene);
                        scene.startPlayback(record, offset);
                    } else {
                        scene.stopPlayback(true);
                    }
                    replay.apply((EntityPlayer)player);
                });
            }
        }
    }

    public boolean toggle(String filename, World world) {
        Scene scene = this.scenes.get(filename);
        if (scene != null) {
            scene.stopPlayback(true);
            return false;
        }
        return this.play(filename, world);
    }

    public Scene get(String filename, World world) {
        Scene scene = this.scenes.get(filename);
        if (scene != null) {
            return scene;
        }
        try {
            scene = this.load(filename);
            if (scene != null) {
                scene.setWorld(world);
                scene.setSender(new SceneSender(scene));
                this.put(filename, scene);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return scene;
    }

    public Scene load(String filename) throws IOException {
        File file = this.sceneFile(filename);
        if (!file.isFile()) {
            return null;
        }
        NBTTagCompound compound = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
        Scene scene = new Scene();
        scene.setId(filename);
        scene.fromNBT(compound);
        return scene;
    }

    public void save(String filename, Scene scene) throws IOException {
        this.save(filename, scene, (Boolean)Blockbuster.sceneSaveUpdate.get());
    }

    public void save(String filename, Scene scene, boolean reload) throws IOException {
        Scene present = this.scenes.get(scene.getId());
        if (reload && present != null) {
            present.copy(scene);
            present.reload(present.getCurrentTick());
        }
        File file = this.sceneFile(filename);
        NBTTagCompound compound = new NBTTagCompound();
        scene.toNBT(compound);
        CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)new FileOutputStream(file));
    }

    public boolean rename(String from, String to) {
        File fromFile = this.sceneFile(from);
        File toFile = this.sceneFile(to);
        if (fromFile.isFile() && !toFile.exists()) {
            return fromFile.renameTo(toFile);
        }
        return false;
    }

    public boolean remove(String filename) {
        File file = this.sceneFile(filename);
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    private File sceneFile(String filename) {
        return Utils.serverFile("blockbuster/scenes", filename);
    }

    private void put(String filename, Scene scene) {
        (this.ticking ? this.toPut : this.scenes).put(filename, scene);
    }

    public List<String> sceneFiles() {
        return Utils.serverFiles("blockbuster/scenes");
    }
}

