/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording.scene;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.audio.AudioHandler;
import mchorse.blockbuster.audio.AudioState;
import mchorse.blockbuster.capabilities.recording.IRecording;
import mchorse.blockbuster.capabilities.recording.Recording;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster.recording.RecordPlayer;
import mchorse.blockbuster.recording.RecordUtils;
import mchorse.blockbuster.recording.data.Mode;
import mchorse.blockbuster.recording.data.Record;
import mchorse.blockbuster.recording.scene.Replay;
import mchorse.blockbuster.recording.scene.fake.FakeContext;
import mchorse.vanilla_pack.morphs.PlayerMorph;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.EnumPacketDirection;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketClientSettings;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class Scene {
    public static long lastUpdate;
    public static final Pattern NUMBERED_SUFFIX;
    public static final Pattern PREFIX;
    public static final Pattern INDEXES;
    private String id = "";
    public List<Replay> replays = new ArrayList<Replay>();
    public String title = "";
    public String startCommand = "";
    public String stopCommand = "";
    public boolean loops;
    private AudioHandler audioHandler = new AudioHandler();
    public boolean playing;
    public Map<Replay, RecordPlayer> actors = new HashMap<Replay, RecordPlayer>();
    public int actorsCount = 0;
    private ICommandSender sender;
    private int tick = 0;
    private boolean wasRecording;
    private boolean paused;
    private World world;
    private List<PlayerState> targetPlayers = new ArrayList<PlayerState>();

    public boolean isPlayerTargetPlayback(EntityPlayer player) {
        for (PlayerState state : this.targetPlayers) {
            if (state.getPlayer() != player) continue;
            return true;
        }
        return false;
    }

    public List<EntityPlayer> getTargetPlaybackPlayers() {
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
        for (PlayerState state : this.targetPlayers) {
            players.add(state.getPlayer());
        }
        return players;
    }

    public String getAudio() {
        return this.audioHandler.getAudioName();
    }

    public void setAudio(String audio) {
        this.audioHandler.setAudioName(audio);
    }

    public int getAudioShift() {
        return this.audioHandler.getAudioShift();
    }

    public void setAudioShift(int audioShift) {
        this.audioHandler.setAudioShift(audioShift);
        if (this.world != null && !this.world.field_72995_K) {
            this.audioHandler.goTo(this.tick);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public World getWorld() {
        return this.world;
    }

    public int getTick() {
        return this.tick;
    }

    public int getCurrentTick() {
        for (RecordPlayer player : this.actors.values()) {
            if (player.isFinished() || player.actor.field_70128_L) continue;
            return player.tick;
        }
        return 0;
    }

    public AudioState getAudioState() {
        return this.audioHandler.getAudioState();
    }

    public void setSender(ICommandSender sender) {
        this.sender = sender;
    }

    public Replay getByFile(String filename) {
        for (Replay replay : this.replays) {
            if (!replay.id.equals(filename)) continue;
            return replay;
        }
        return null;
    }

    public int getMaxLength() {
        int max = 0;
        for (Replay replay : this.replays) {
            Record record = null;
            try {
                record = CommonProxy.manager.get(replay.id);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (record == null) continue;
            max = Math.max(max, record.getFullLength());
        }
        return max;
    }

    public void tick() {
        if (((Boolean)Blockbuster.debugPlaybackTicks.get()).booleanValue()) {
            this.logTicks();
        }
        for (RecordPlayer player : this.actors.values()) {
            if (!player.realPlayer && player.actor instanceof EntityPlayer) {
                ((EntityPlayerMP)player.actor).func_71127_g();
            } else if (!player.actorUpdated) {
                player.next();
            }
            player.actorUpdated = false;
        }
        if (this.playing && !this.paused) {
            if (this.tick % 4 == 0 && !this.checkActors()) {
                return;
            }
            this.audioHandler.update();
            ++this.tick;
        }
    }

    public void worldTick(World world) {
        for (RecordPlayer player : this.actors.values()) {
            if (player.actor.field_70170_p != world) continue;
            if (this.playing) {
                player.checkAndSpawn();
            }
            player.playActions();
        }
    }

    public boolean areActorsFinished() {
        int count = 0;
        for (Map.Entry<Replay, RecordPlayer> entry : this.actors.entrySet()) {
            Replay replay = entry.getKey();
            RecordPlayer actor = entry.getValue();
            if (this.loops && actor.isFinished()) {
                actor.record.reset(actor.actor);
                actor.startPlaying(replay.id, actor.kill);
                actor.record.applyAction(0, actor.actor);
                CommonProxy.manager.players.put(actor.actor, actor);
            }
            if ((!actor.isFinished() || !actor.playing) && !actor.actor.field_70128_L) continue;
            ++count;
        }
        return count == this.actorsCount;
    }

    public boolean checkActors() {
        if (this.areActorsFinished() && !this.loops && !this.wasRecording) {
            this.stopPlayback(false);
            return false;
        }
        return true;
    }

    public void startPlayback(int tick) {
        if (this.getWorld().field_72995_K || this.playing || this.replays.isEmpty()) {
            return;
        }
        for (Replay replay : this.replays) {
            if (!replay.id.isEmpty()) continue;
            RecordUtils.broadcastError("director.empty_filename", new Object[0]);
            return;
        }
        this.collectActors(null);
        EntityLivingBase firstActor = null;
        for (Map.Entry<Replay, RecordPlayer> entry : this.actors.entrySet()) {
            Replay replay = entry.getKey();
            RecordPlayer actor = entry.getValue();
            if (firstActor == null) {
                firstActor = actor.actor;
            }
            actor.startPlaying(replay.id, tick, !this.loops);
        }
        this.playing = true;
        this.sendCommand(this.startCommand);
        if (firstActor != null) {
            CommonProxy.damage.addDamageControl(this, firstActor);
        }
        this.audioHandler.startAudio(tick);
        this.wasRecording = false;
        this.paused = false;
        this.tick = tick;
    }

    public void startPlayback(String exception, int tick) {
        if (this.getWorld().field_72995_K || this.playing) {
            return;
        }
        this.collectActors(this.getByFile(exception));
        for (Map.Entry<Replay, RecordPlayer> entry : this.actors.entrySet()) {
            Replay replay = entry.getKey();
            RecordPlayer actor = entry.getValue();
            actor.startPlaying(replay.id, tick, true);
        }
        this.playing = true;
        this.sendCommand(this.startCommand);
        this.audioHandler.startAudio(tick);
        this.wasRecording = true;
        this.paused = false;
        this.tick = tick;
    }

    public boolean spawn(int tick) {
        if (this.replays.isEmpty()) {
            return false;
        }
        if (!this.actors.isEmpty()) {
            this.stopPlayback(true);
        }
        for (Replay replay : this.replays) {
            if (!replay.id.isEmpty()) continue;
            RecordUtils.broadcastError("director.empty_filename", new Object[0]);
            return false;
        }
        this.collectActors(null);
        this.playing = true;
        this.paused = true;
        int j = 0;
        for (Map.Entry<Replay, RecordPlayer> entry : this.actors.entrySet()) {
            Replay replay = entry.getKey();
            RecordPlayer actor = entry.getValue();
            if (j == 0 && actor.actor != null) {
                CommonProxy.damage.addDamageControl(this, actor.actor);
            }
            actor.playing = false;
            actor.startPlaying(replay.id, tick, true);
            actor.sync = true;
            actor.pause();
            for (int i = 0; i <= tick; ++i) {
                actor.record.applyAction(i - actor.record.preDelay, actor.actor);
            }
            actor.record.applyPreviousMorph(actor.actor, replay, tick, Record.MorphType.PAUSE);
            ++j;
        }
        this.audioHandler.pauseAudio(tick);
        this.tick = tick;
        return true;
    }

    public void stopPlayback(boolean triggered) {
        if (!triggered && !this.wasRecording || triggered) {
            this.wasRecording = false;
        }
        if (this.getWorld().field_72995_K || !this.playing) {
            return;
        }
        this.tick = 0;
        for (Map.Entry<Replay, RecordPlayer> entry : this.actors.entrySet()) {
            RecordPlayer actor = entry.getValue();
            actor.kill = true;
            actor.stopPlaying();
        }
        CommonProxy.damage.restoreDamageControl(this, this.getWorld());
        this.targetPlayers.forEach(playerState -> playerState.resetPlayerState());
        this.targetPlayers.clear();
        this.audioHandler.stopAudio();
        this.actors.clear();
        this.playing = false;
        this.sendCommand(this.stopCommand);
    }

    public boolean togglePlayback() {
        if (this.playing) {
            this.stopPlayback(true);
        } else {
            this.startPlayback(0);
        }
        return this.playing;
    }

    private void collectActors(Replay exception) {
        this.actors.clear();
        this.actorsCount = 0;
        for (Replay replay : this.replays) {
            Object player;
            if (replay == exception || !replay.enabled) continue;
            World world = this.getWorld();
            Object actor = null;
            boolean real = false;
            if (!replay.target.isEmpty() && (player = this.getTargetPlayer(replay.target)) != null) {
                if (!this.isPlayerTargetPlayback((EntityPlayer)player)) {
                    this.targetPlayers.add(new PlayerState((EntityPlayer)player));
                }
                actor = player;
                real = true;
            }
            if (actor == null && replay.fake) {
                GameProfile profile = new GameProfile(new UUID(0L, this.actorsCount), replay.name.isEmpty() ? "Player" : replay.name);
                if (replay.morph instanceof PlayerMorph) {
                    profile = ((PlayerMorph)replay.morph).profile;
                }
                EntityPlayerMP player2 = new EntityPlayerMP(world.func_73046_m(), (WorldServer)world, profile, new PlayerInteractionManager(world));
                NetworkManager manager = new NetworkManager(EnumPacketDirection.SERVERBOUND);
                try {
                    manager.channelActive((ChannelHandlerContext)new FakeContext());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                IRecording recording = Recording.get((EntityPlayer)player2);
                recording.setFakePlayer(true);
                PacketBuffer buffer = new PacketBuffer(Unpooled.buffer((int)64));
                buffer.func_180714_a("en_US");
                buffer.writeByte(10);
                buffer.func_179249_a((Enum)EntityPlayer.EnumChatVisibility.FULL);
                buffer.writeBoolean(true);
                buffer.writeByte(127);
                buffer.func_179249_a((Enum)EnumHandSide.RIGHT);
                CPacketClientSettings packet = new CPacketClientSettings();
                try {
                    packet.func_148837_a(buffer);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                player2.func_147100_a(packet);
                player2.field_71135_a = new NetHandlerPlayServer(world.func_73046_m(), manager, player2);
                actor = player2;
            } else if (actor == null) {
                EntityActor entity = new EntityActor(this.getWorld());
                entity.wasAttached = true;
                actor = entity;
            }
            player = CommonProxy.manager.play(replay.id, (EntityLivingBase)actor, Mode.BOTH, 0, true);
            if (real) {
                ((RecordPlayer)player).realPlayer();
            }
            if (player == null) continue;
            ((RecordPlayer)player).setReplay(replay);
            ++this.actorsCount;
            replay.apply((EntityLivingBase)actor);
            this.actors.put(replay, (RecordPlayer)player);
        }
        if (((Boolean)Blockbuster.modelBlockResetOnPlayback.get()).booleanValue()) {
            lastUpdate = System.currentTimeMillis();
        }
    }

    private EntityPlayerMP getTargetPlayer(String target) {
        ScorePlayerTeam team;
        PlayerList list = this.world.func_73046_m().func_184103_al();
        if (target.equals("@r")) {
            return (EntityPlayerMP)list.func_181057_v().get((int)((double)list.func_181057_v().size() * Math.random()));
        }
        if (target.startsWith("@") && (team = this.world.func_96441_U().func_96508_e(target.substring(1))) != null && !team.func_96670_d().isEmpty()) {
            return list.func_152612_a((String)team.func_96670_d().iterator().next());
        }
        return list.func_152612_a(target);
    }

    public boolean isPlaying() {
        for (RecordPlayer player : this.actors.values()) {
            if (!player.playing) continue;
            return true;
        }
        return false;
    }

    public void pause() {
        for (RecordPlayer actor : this.actors.values()) {
            actor.pause();
        }
        this.audioHandler.pauseAudio();
        this.paused = true;
    }

    public void resume(int tick) {
        if (tick >= 0) {
            this.tick = tick;
        }
        for (RecordPlayer player : this.actors.values()) {
            player.resume(tick);
        }
        this.audioHandler.resume(this.tick);
        this.paused = false;
    }

    public void goTo(int tick, boolean actions) {
        this.tick = tick;
        for (Map.Entry<Replay, RecordPlayer> entry : this.actors.entrySet()) {
            Replay replay = entry.getKey();
            if (tick == 0) {
                replay.apply(entry.getValue().actor);
            }
            entry.getValue().goTo(tick, actions);
        }
        this.audioHandler.goTo(tick);
    }

    public void reload(int tick) {
        this.stopPlayback(true);
        this.spawn(tick);
    }

    public boolean dupe(int index) {
        if (index < 0 || index >= this.replays.size()) {
            return false;
        }
        Replay replay = this.replays.get(index).copy();
        replay.id = this.getNextSuffix(replay.id);
        this.replays.add(replay);
        return true;
    }

    public String getNextBaseSuffix(String filename) {
        if (filename.isEmpty()) {
            return filename;
        }
        return this.getNextSuffix(filename + "_0");
    }

    public String getNextSuffix(String filename) {
        if (filename.isEmpty()) {
            return filename;
        }
        Matcher matcher = NUMBERED_SUFFIX.matcher(filename);
        String prefix = filename;
        boolean found = matcher.find();
        int max = 0;
        if (found) {
            prefix = filename.substring(0, matcher.start());
        }
        for (Replay other : this.replays) {
            if (!other.id.startsWith(prefix) || !(matcher = NUMBERED_SUFFIX.matcher(other.id)).find() || !other.id.substring(0, matcher.start()).equals(prefix)) continue;
            max = Math.max(max, Integer.parseInt(matcher.group(1)));
        }
        return prefix + "_" + (max + 1);
    }

    public void setupIds() {
        for (Replay replay : this.replays) {
            if (!replay.id.isEmpty()) continue;
            replay.id = this.getNextBaseSuffix(this.getId());
        }
    }

    public void renamePrefix(String newPrefix) {
        this.renamePrefix(null, newPrefix, null);
    }

    public void renamePrefix(@Nullable String oldPrefix, String newPrefix, Function<String, String> process) {
        for (Replay replay : this.replays) {
            Matcher matcher = PREFIX.matcher(replay.id);
            if (oldPrefix != null && replay.id.startsWith(oldPrefix + "_")) {
                String indexes = replay.id.substring(oldPrefix.length() + 1);
                Matcher matcherIndexes = INDEXES.matcher(indexes);
                int counter = 0;
                while (matcherIndexes.find()) {
                    ++counter;
                }
                if (counter > 1) {
                    replay.id = newPrefix + "_" + indexes;
                    continue;
                }
            }
            if (matcher.find()) {
                replay.id = newPrefix + "_" + matcher.group(2);
                continue;
            }
            if (process == null) continue;
            replay.id = process.apply(replay.id);
        }
    }

    public void sendCommand(String command) {
        if (this.sender != null && !command.isEmpty()) {
            this.getWorld().func_73046_m().field_71321_q.func_71556_a(this.sender, command);
        }
    }

    public void logTicks() {
        if (this.actors.isEmpty()) {
            return;
        }
        RecordPlayer actor = this.actors.values().iterator().next();
        if (actor != null) {
            Blockbuster.LOGGER.info("Director tick: " + actor.getTick());
        }
    }

    public void syncAudio(EntityPlayerMP player) {
        this.audioHandler.syncPlayer(player);
    }

    public void copy(Scene scene) {
        if (this == scene) {
            return;
        }
        this.replays.clear();
        scene.replays.forEach(element -> this.replays.add(element.copy()));
        this.loops = scene.loops;
        this.title = scene.title;
        this.startCommand = scene.startCommand;
        this.stopCommand = scene.stopCommand;
        this.audioHandler.copy(scene.audioHandler);
    }

    public void fromNBT(NBTTagCompound compound) {
        this.replays.clear();
        NBTTagList tagList = compound.func_150295_c("Actors", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            Replay replay = new Replay();
            replay.fromNBT(tagList.func_150305_b(i));
            this.replays.add(replay);
        }
        this.loops = compound.func_74767_n("Loops");
        this.title = compound.func_74779_i("Title");
        this.startCommand = compound.func_74779_i("StartCommand");
        this.stopCommand = compound.func_74779_i("StopCommand");
        this.audioHandler.fromNBT(compound);
    }

    public void toNBT(NBTTagCompound compound) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.replays.size(); ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            this.replays.get(i).toNBT(tag);
            tagList.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("Actors", (NBTBase)tagList);
        compound.func_74757_a("Loops", this.loops);
        compound.func_74778_a("Title", this.title);
        compound.func_74778_a("StartCommand", this.startCommand);
        compound.func_74778_a("StopCommand", this.stopCommand);
        this.audioHandler.toNBT(compound);
    }

    public void fromBuf(ByteBuf buffer) {
        this.id = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.replays.clear();
        int c = buffer.readInt();
        for (int i = 0; i < c; ++i) {
            Replay replay = new Replay();
            this.replays.add(replay);
            replay.fromBuf(buffer);
        }
        this.loops = buffer.readBoolean();
        this.title = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.startCommand = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.stopCommand = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.audioHandler.fromBytes(buffer);
    }

    public void toBuf(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.id);
        buffer.writeInt(this.replays.size());
        for (Replay replay : this.replays) {
            replay.toBuf(buffer);
        }
        buffer.writeBoolean(this.loops);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.title);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.startCommand);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.stopCommand);
        this.audioHandler.toBytes(buffer);
    }

    static {
        NUMBERED_SUFFIX = Pattern.compile("_(\\d+)$");
        PREFIX = Pattern.compile("^(.+)_([^_]+)$");
        INDEXES = Pattern.compile("[^_]+");
    }

    public class PlayerState {
        private EntityPlayer player;
        private NonNullList<ItemStack> mainInventory;
        private int experienceLevel;
        private int experienceTotal;
        private float experience;
        private int foodLevel;

        public PlayerState(EntityPlayer player) {
            this.player = player;
            this.mainInventory = NonNullList.func_191197_a((int)36, (Object)ItemStack.field_190927_a);
            for (int i = 0; i < this.mainInventory.size(); ++i) {
                this.mainInventory.set(i, (Object)((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77946_l());
            }
            this.experience = player.field_71106_cc;
            this.experienceLevel = player.field_71068_ca;
            this.experienceTotal = player.field_71067_cb;
            this.foodLevel = player.func_71024_bL().func_75116_a();
        }

        public EntityPlayer getPlayer() {
            return this.player;
        }

        public void resetPlayerState() {
            for (int i = 0; i < this.player.field_71071_by.field_70462_a.size(); ++i) {
                this.player.field_71071_by.field_70462_a.set(i, (Object)((ItemStack)this.mainInventory.get(i)).func_77946_l());
            }
            this.player.field_71106_cc = this.experience;
            this.player.field_71068_ca = this.experienceLevel;
            this.player.field_71067_cb = this.experienceTotal;
            this.player.func_71024_bL().func_75114_a(this.foodLevel);
        }
    }
}

