/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.aperture.CameraHandler;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.blockbuster.recording.actions.ActionRegistry;
import mchorse.blockbuster.recording.actions.MorphAction;
import mchorse.blockbuster.recording.actions.MountingAction;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.recording.scene.Replay;
import mchorse.mclib.utils.MathUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.ISyncableMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MovementInput;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FilenameUtils;

public class Record {
    public static final FoundAction ACTION = new FoundAction();
    public static final MorphAction MORPH = new MorphAction();
    public static final short SIGNATURE = 148;
    public String filename;
    public short version = (short)148;
    public int preDelay = 0;
    public int postDelay = 0;
    public List<List<Action>> actions = new ArrayList<List<Action>>();
    public List<Frame> frames = new ArrayList<Frame>();
    public NBTTagCompound playerData;
    public int unload;
    public boolean dirty;
    private Replay replay;

    public Record(String filename) {
        this.filename = filename;
        this.resetUnload();
    }

    public void setReplay(Replay replay) {
        this.replay = replay;
    }

    public Replay getReplay() {
        return this.replay;
    }

    public int getFullLength() {
        return this.preDelay + this.getLength() + this.postDelay;
    }

    public int getLength() {
        return Math.max(this.actions.size(), this.frames.size());
    }

    public List<Action> getActions(int tick) {
        if (tick >= this.actions.size() || tick < 0) {
            return null;
        }
        return this.actions.get(tick);
    }

    public Action getAction(int tick, int index) {
        List<Action> actions = this.getActions(tick);
        if (actions != null && index >= 0 && index < actions.size()) {
            return actions.get(index);
        }
        return null;
    }

    public List<List<Action>> getActions(int fromTick0, int toTick0, int fromIndex0, int toIndex0) {
        int fromIndex = Math.min(fromIndex0, toIndex0);
        int toIndex = Math.max(fromIndex0, toIndex0);
        int fromTick = Math.min(fromTick0, toTick0);
        int toTick = Math.max(fromTick0, toTick0);
        if (fromTick0 < 0 || toTick0 < 0 || (fromIndex0 != -1 || toIndex0 != -1) && fromIndex0 < 0 && toIndex0 < 0 || toTick >= this.actions.size()) {
            return new ArrayList<List<Action>>();
        }
        List<List<Action>> actionRange = this.actions.subList(fromTick, toTick + 1);
        if (actionRange != null) {
            actionRange = new ArrayList<List<Action>>(actionRange);
            for (int i = 0; i < actionRange.size(); ++i) {
                List<Action> frame = actionRange.get(i);
                if (frame != null && !frame.isEmpty()) {
                    if (fromIndex == -1 && toIndex == -1) {
                        actionRange.set(i, new ArrayList<Action>(frame));
                        continue;
                    }
                    if (fromIndex >= frame.size()) {
                        actionRange.set(i, null);
                        continue;
                    }
                    int i0 = MathUtils.clamp((int)fromIndex, (int)0, (int)(frame.size() - 1));
                    int i1 = MathUtils.clamp((int)(toIndex + 1), (int)0, (int)frame.size());
                    actionRange.set(i, new ArrayList<Action>(frame.subList(i0, i1)));
                    continue;
                }
                actionRange.set(i, null);
            }
        }
        return actionRange;
    }

    public List<List<Action>> getActions(int fromTick0, int toTick0) {
        return this.getActions(fromTick0, toTick0, -1, -1);
    }

    public List<List<Boolean>> getActionsMask(int fromTick, List<List<Action>> actions) {
        if (fromTick < 0 || fromTick >= this.actions.size()) {
            return new ArrayList<List<Boolean>>();
        }
        ArrayList<List<Boolean>> mask = new ArrayList<List<Boolean>>();
        for (int t = fromTick; t < this.actions.size() && t - fromTick < actions.size(); ++t) {
            ArrayList<Boolean> maskFrame = new ArrayList<Boolean>();
            if (actions.get(t - fromTick) != null && this.actions.get(t) != null && !this.actions.get(t).isEmpty()) {
                for (int a = 0; a < this.actions.get(t).size(); ++a) {
                    maskFrame.add(actions.get(t - fromTick).contains(this.actions.get(t).get(a)));
                }
            } else {
                maskFrame.add(false);
            }
            mask.add(maskFrame);
        }
        return mask;
    }

    public int getActionIndex(int tick, Action action) {
        if (tick < 0 || tick >= this.actions.size() || this.actions.get(tick) == null || this.actions.get(tick).isEmpty() || action == null) {
            return -1;
        }
        for (int a = 0; a < this.actions.get(tick).size(); ++a) {
            if (this.actions.get(tick).get(a) != action) continue;
            return a;
        }
        return -1;
    }

    public int[] findAction(Action action) {
        if (action == null) {
            return new int[]{-1, -1};
        }
        for (int t = 0; t < this.actions.size(); ++t) {
            int i = this.getActionIndex(t, action);
            if (i == -1) continue;
            return new int[]{t, i};
        }
        return new int[]{-1, -1};
    }

    public Frame getFrame(int tick) {
        if (tick >= this.frames.size() || tick < 0) {
            return null;
        }
        return this.frames.get(tick);
    }

    public void resetUnload() {
        this.unload = (Integer)Blockbuster.recordUnloadTime.get();
    }

    public void applyFrame(int tick, EntityLivingBase actor, boolean force) {
        this.applyFrame(tick, actor, force, false);
    }

    public void applyFrame(int tick, EntityLivingBase actor, boolean force, boolean realPlayer) {
        if (tick >= this.frames.size() || tick < 0) {
            return;
        }
        Frame frame = this.frames.get(tick);
        frame.apply(actor, this.replay, force);
        if (realPlayer) {
            actor.func_70012_b(frame.x, frame.y, frame.z, frame.yaw, frame.pitch);
            actor.field_70159_w = frame.motionX;
            actor.field_70181_x = frame.motionY;
            actor.field_70179_y = frame.motionZ;
            actor.field_70122_E = frame.onGround;
            if (frame.hasBodyYaw) {
                actor.field_70761_aq = frame.bodyYaw;
            }
            if (actor.field_70170_p.field_72995_K) {
                this.applyClientMovement(actor, frame);
            }
            actor.func_70095_a(frame.isSneaking);
            actor.func_70031_b(frame.isSprinting);
            if (actor.field_70170_p.field_72995_K) {
                this.applyFrameClient(actor, null, frame);
            }
        }
        if (actor.field_70170_p.field_72995_K && ((Boolean)Blockbuster.actorFixY.get()).booleanValue()) {
            actor.field_70163_u = frame.y;
        }
        Frame prev = this.frames.get(Math.max(0, tick - 1));
        if (realPlayer || !actor.field_70170_p.field_72995_K) {
            actor.field_70142_S = prev.x;
            actor.field_70137_T = prev.y;
            actor.field_70136_U = prev.z;
            actor.field_70169_q = prev.x;
            actor.field_70167_r = prev.y;
            actor.field_70166_s = prev.z;
            actor.field_70126_B = prev.yaw;
            actor.field_70127_C = prev.pitch;
            actor.field_70758_at = prev.yawHead;
            if (prev.hasBodyYaw) {
                actor.field_70760_ar = prev.bodyYaw;
            }
            if (actor.field_70170_p.field_72995_K) {
                this.applyFrameClient(actor, prev, frame);
            }
        } else if (actor instanceof EntityActor) {
            ((EntityActor)actor).prevRoll = prev.roll;
        }
        actor.field_70143_R = prev.fallDistance;
        if (tick < this.frames.size() - 1) {
            Frame next = this.frames.get(tick + 1);
            if (actor instanceof EntityPlayer) {
                double dx = next.x - frame.x;
                double dy = next.y - frame.y;
                double dz = next.z - frame.z;
                actor.field_70140_Q += MathHelper.func_76133_a((double)(dx * dx + dz * dz)) * 0.32f;
                actor.field_82151_R += MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz)) * 0.32f;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void applyClientMovement(EntityLivingBase actor, Frame frame) {
        if (actor instanceof EntityPlayerSP) {
            MovementInput input = ((EntityPlayerSP)actor).field_71158_b;
            input.field_78899_d = frame.isSneaking;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void applyFrameClient(EntityLivingBase actor, Frame prev, Frame frame) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (actor == player) {
            CameraHandler.setRoll(prev == null ? frame.roll : prev.roll, frame.roll);
        }
    }

    public Frame getFrameSafe(int tick) {
        if (this.frames.isEmpty()) {
            return null;
        }
        return this.frames.get(MathUtils.clamp((int)tick, (int)0, (int)(this.frames.size() - 1)));
    }

    public void applyAction(int tick, EntityLivingBase actor) {
        this.applyAction(tick, actor, false);
    }

    public void applyAction(int tick, EntityLivingBase actor, boolean safe) {
        if (tick >= this.actions.size() || tick < 0) {
            return;
        }
        List<Action> actions = this.actions.get(tick);
        if (actions != null) {
            for (Action action : actions) {
                if (safe && !action.isSafe()) continue;
                try {
                    action.apply(actor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public FoundAction seekMorphAction(int tick, MorphAction last) {
        boolean canRet;
        int threshold = 0;
        boolean bl = canRet = last == null;
        while (tick >= threshold) {
            List<Action> actions = this.actions.get(tick);
            if (actions == null) {
                --tick;
                continue;
            }
            for (int i = actions.size() - 1; i >= 0; --i) {
                Action action = actions.get(i);
                if (!canRet && action == last) {
                    canRet = true;
                    continue;
                }
                if (!canRet || !(action instanceof MorphAction)) continue;
                ACTION.set(tick, (MorphAction)action);
                return ACTION;
            }
            --tick;
        }
        return null;
    }

    public void applyPreviousMorph(EntityLivingBase actor, Replay replay, int tick, MorphType type) {
        block11: {
            AbstractMorph replayMorph;
            boolean pause = type != MorphType.REGULAR && (Boolean)Blockbuster.recordPausePreview.get() != false;
            AbstractMorph abstractMorph = replayMorph = replay == null ? null : replay.morph;
            if (tick >= this.actions.size()) {
                return;
            }
            FoundAction found = this.seekMorphAction(tick, null);
            if (found != null) {
                try {
                    MorphAction action = found.action;
                    if (pause && action.morph instanceof ISyncableMorph) {
                        int foundTick = found.tick;
                        int offset = tick - foundTick;
                        found = this.seekMorphAction(foundTick, action);
                        AbstractMorph previous = found == null ? replayMorph : found.action.morph;
                        int previousOffset = foundTick - (found == null ? 0 : found.tick);
                        action.applyWithOffset(actor, offset, previous, previousOffset, type == MorphType.FORCE);
                        break block11;
                    }
                    action.apply(actor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (replay != null) {
                if (pause && replay.morph != null) {
                    Record.MORPH.morph = replay.morph;
                    MORPH.applyWithOffset(actor, tick, null, 0, type == MorphType.FORCE);
                } else if (type == MorphType.FORCE && replay.morph != null) {
                    Record.MORPH.morph = replay.morph;
                    MORPH.applyWithForce(actor);
                } else {
                    replay.apply(actor);
                }
            }
        }
    }

    public void reset(EntityLivingBase actor) {
        if (actor.func_184218_aH()) {
            this.resetMount(actor);
        }
        if (actor.func_110143_aJ() > 0.0f) {
            this.applyFrame(0, actor, true);
            actor.func_70095_a(false);
            actor.func_70031_b(false);
            actor.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
            actor.func_184201_a(EntityEquipmentSlot.CHEST, ItemStack.field_190927_a);
            actor.func_184201_a(EntityEquipmentSlot.LEGS, ItemStack.field_190927_a);
            actor.func_184201_a(EntityEquipmentSlot.FEET, ItemStack.field_190927_a);
            actor.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
            actor.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
        }
    }

    protected void resetMount(EntityLivingBase actor) {
        Entity mount;
        Frame frame;
        int index = -1;
        int c = this.actions.size();
        block0: for (int i = 0; i < c; ++i) {
            List<Action> actions = this.actions.get(i);
            if (actions == null) continue;
            for (Action action : actions) {
                if (!(action instanceof MountingAction)) continue;
                MountingAction act = (MountingAction)action;
                if (!act.isMounting) continue;
                index = i + 1;
                continue block0;
            }
        }
        actor.func_184210_p();
        if (index != -1 && (frame = this.frames.get(index)) != null && (mount = actor.func_184187_bx()) != null && !(mount instanceof EntityActor)) {
            mount.func_70080_a(frame.x, frame.y, frame.z, frame.yaw, frame.pitch);
        }
    }

    public void addAction(int tick, Action action) {
        List<Action> actions = this.actions.get(tick);
        if (actions != null) {
            actions.add(action);
        } else {
            actions = new ArrayList<Action>();
            actions.add(action);
            this.actions.set(tick, actions);
        }
    }

    public void addAction(int tick, int index, Action action) {
        List<Action> actions = this.actions.get(tick);
        if (actions != null) {
            if (index == -1 || index > actions.size()) {
                actions.add(action);
            } else {
                actions.add(index, action);
            }
        } else {
            actions = new ArrayList<Action>();
            actions.add(action);
            this.actions.set(tick, actions);
        }
    }

    public void addActionCollection(int tick, List<List<Action>> actions) {
        this.addActionCollection(tick, -1, actions);
    }

    public void addActionCollection(int tick, int index, List<List<Action>> actions) {
        if (index < -1 || tick < 0 || tick >= this.actions.size() || actions == null) {
            return;
        }
        for (int i = tick; i < this.actions.size() && i - tick < actions.size(); ++i) {
            ArrayList actionFrame;
            List<Action> frame = this.actions.get(i);
            ArrayList arrayList = actionFrame = actions.get(i - tick) != null && !actions.get(i - tick).isEmpty() ? new ArrayList(actions.get(i - tick)) : null;
            if (frame == null) {
                this.actions.set(i, actionFrame);
                continue;
            }
            if (actionFrame == null) continue;
            if (index > frame.size() || index == -1) {
                frame.addAll(actionFrame);
                continue;
            }
            frame.addAll(index, actionFrame);
        }
    }

    public void addActions(int tick, List<Action> actions) {
        if (tick < 0 || tick >= this.actions.size()) {
            return;
        }
        List<Action> present = this.actions.get(tick);
        if (present == null) {
            this.actions.set(tick, actions);
        } else if (actions != null) {
            present.addAll(actions);
        }
    }

    public void removeAction(int tick, int index) {
        if (index == -1) {
            this.actions.set(tick, null);
        } else {
            List<Action> actions = this.actions.get(tick);
            if (index >= 0 && index < actions.size()) {
                actions.remove(index);
                if (actions.isEmpty()) {
                    this.actions.set(tick, null);
                }
            }
        }
    }

    public void removeActions(int fromTick, List<List<Action>> actions) {
        int tick = fromTick;
        for (int c = 0; tick < this.actions.size() && c < actions.size(); ++tick, ++c) {
            if (this.actions.get(tick) != null && actions.get(c) != null) {
                this.actions.get(tick).removeAll((Collection)actions.get(c));
            }
            if (this.actions.get(tick) == null || !this.actions.get(tick).isEmpty()) continue;
            this.actions.set(tick, null);
        }
    }

    public void removeActionsMask(int fromTick, List<List<Boolean>> mask) {
        int tick = fromTick;
        for (int c = 0; tick < this.actions.size() && c < mask.size(); ++tick, ++c) {
            if (this.actions.get(tick) == null || mask.get(c) == null) continue;
            ArrayList<Action> remove = new ArrayList<Action>();
            for (int a = 0; a < this.actions.get(tick).size() && a < mask.get(c).size(); ++a) {
                if (!mask.get(c).get(a).booleanValue()) continue;
                remove.add(this.actions.get(tick).get(a));
            }
            this.actions.get(tick).removeAll(remove);
        }
    }

    public void removeActions(int fromTick0, int toTick0, int fromIndex0, int toIndex0) {
        int fromIndex = Math.min(fromIndex0, toIndex0);
        int toIndex = Math.max(fromIndex0, toIndex0);
        int fromTick = Math.min(fromTick0, toTick0);
        int toTick = Math.max(fromTick0, toTick0);
        int frameCount = this.actions.size();
        if (fromIndex == -1 && toIndex == -1) {
            for (int tick = fromTick; tick <= toTick && tick < frameCount; ++tick) {
                this.actions.set(tick, null);
            }
        } else {
            for (int tick = fromTick; tick <= toTick && tick < frameCount; ++tick) {
                List<Action> actions = this.actions.get(tick);
                if (actions == null) continue;
                if (fromIndex != -1 && toIndex != -1) {
                    for (int max = toIndex; fromIndex <= max && fromIndex < actions.size(); --max) {
                        actions.remove(fromIndex);
                    }
                } else {
                    int index;
                    int n = index = fromIndex == -1 ? toIndex : fromIndex;
                    if (index < actions.size()) {
                        actions.remove(index);
                    }
                }
                if (!actions.isEmpty()) continue;
                this.actions.set(tick, null);
            }
        }
    }

    public void replaceAction(int tick, int index, Action action) {
        if (tick < 0 || tick >= this.actions.size()) {
            return;
        }
        List<Action> actions = this.actions.get(tick);
        if (actions == null || index < 0 || index >= actions.size()) {
            this.addAction(tick, action);
        } else {
            actions.set(index, action);
        }
    }

    public Record clone() {
        Record record = new Record(this.filename);
        record.version = this.version;
        record.preDelay = this.preDelay;
        record.postDelay = this.postDelay;
        for (Frame frame : this.frames) {
            record.frames.add(frame.copy());
        }
        for (List list : this.actions) {
            if (list == null || list.isEmpty()) {
                record.actions.add(null);
                continue;
            }
            ArrayList<Action> newActions = new ArrayList<Action>();
            for (Action action : list) {
                try {
                    NBTTagCompound tag = new NBTTagCompound();
                    action.toNBT(tag);
                    Action newAction = ActionRegistry.fromType(ActionRegistry.getType(action));
                    newAction.fromNBT(tag);
                    newActions.add(newAction);
                }
                catch (Exception e) {
                    System.out.println("Failed to clone an action!");
                    e.printStackTrace();
                }
            }
            record.actions.add(newActions);
        }
        return record;
    }

    public void save(File file) throws IOException {
        this.save(file, true);
    }

    public void save(File file, boolean savePast) throws IOException {
        if (savePast && file.isFile()) {
            this.savePastCopies(file);
        }
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList frames = new NBTTagList();
        compound.func_74777_a("Version", (short)148);
        compound.func_74768_a("PreDelay", this.preDelay);
        compound.func_74768_a("PostDelay", this.postDelay);
        compound.func_74782_a("Actions", (NBTBase)this.createActionMap());
        if (this.playerData != null) {
            compound.func_74782_a("PlayerData", (NBTBase)this.playerData);
        }
        int c = this.frames.size();
        int d = this.actions.size() - this.frames.size();
        if (d < 0) {
            d = 0;
        }
        for (int i = 0; i < c; ++i) {
            NBTTagCompound frameTag = new NBTTagCompound();
            Frame frame = this.frames.get(i);
            List<Action> actions = null;
            if (d + i <= this.actions.size() - 1) {
                actions = this.actions.get(d + i);
            }
            frame.toNBT(frameTag);
            if (actions != null) {
                NBTTagList actionsTag = new NBTTagList();
                for (Action action : actions) {
                    NBTTagCompound actionTag = new NBTTagCompound();
                    action.toNBT(actionTag);
                    actionTag.func_74774_a("Type", ((Byte)ActionRegistry.CLASS_TO_ID.get(action.getClass())).byteValue());
                    actionsTag.func_74742_a((NBTBase)actionTag);
                }
                frameTag.func_74782_a("Action", (NBTBase)actionsTag);
            }
            frames.func_74742_a((NBTBase)frameTag);
        }
        compound.func_74782_a("Frames", (NBTBase)frames);
        CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)new FileOutputStream(file));
    }

    private void savePastCopies(File file) {
        int copies = 5;
        String name = FilenameUtils.removeExtension((String)file.getName());
        for (int counter = 5; counter >= 0 && file.exists(); --counter) {
            File current = this.getPastFile(file, name, counter);
            if (!current.exists()) continue;
            if (counter == 5) {
                current.delete();
                continue;
            }
            File previous = this.getPastFile(file, name, counter + 1);
            current.renameTo(previous);
        }
    }

    private File getPastFile(File file, String name, int iteration) {
        return new File(file.getParentFile(), name + (iteration == 0 ? ".dat" : ".dat~" + iteration));
    }

    private NBTTagCompound createActionMap() {
        NBTTagCompound tag = new NBTTagCompound();
        for (Map.Entry<String, Byte> entry : ActionRegistry.NAME_TO_ID.entrySet()) {
            tag.func_74778_a(entry.getValue().toString(), entry.getKey());
        }
        return tag;
    }

    public void load(File file) throws IOException {
        this.load(CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file)));
    }

    public void load(NBTTagCompound compound) {
        NBTTagCompound map = null;
        this.version = compound.func_74765_d("Version");
        this.preDelay = compound.func_74762_e("PreDelay");
        this.postDelay = compound.func_74762_e("PostDelay");
        if (compound.func_150297_b("Actions", 10)) {
            map = compound.func_74775_l("Actions");
        }
        if (compound.func_150297_b("PlayerData", 10)) {
            this.playerData = compound.func_74775_l("PlayerData");
        }
        NBTTagList frames = (NBTTagList)compound.func_74781_a("Frames");
        int c = frames.func_74745_c();
        for (int i = 0; i < c; ++i) {
            NBTTagCompound frameTag = frames.func_150305_b(i);
            NBTBase actionTag = frameTag.func_74781_a("Action");
            Frame frame = new Frame();
            frame.fromNBT(frameTag);
            if (actionTag != null) {
                try {
                    ArrayList<Action> actions = new ArrayList<Action>();
                    if (actionTag instanceof NBTTagCompound) {
                        Action action = this.actionFromNBT((NBTTagCompound)actionTag, map);
                        if (action != null) {
                            actions.add(action);
                        }
                    } else if (actionTag instanceof NBTTagList) {
                        NBTTagList list = (NBTTagList)actionTag;
                        int cc = list.func_74745_c();
                        for (int ii = 0; ii < cc; ++ii) {
                            Action action = this.actionFromNBT(list.func_150305_b(ii), map);
                            if (action == null) continue;
                            actions.add(action);
                        }
                    }
                    this.actions.add(actions);
                }
                catch (Exception e) {
                    System.out.println("Failed to load an action at frame " + i);
                    e.printStackTrace();
                }
            } else {
                this.actions.add(null);
            }
            this.frames.add(frame);
        }
    }

    private Action actionFromNBT(NBTTagCompound tag, NBTTagCompound map) throws Exception {
        byte type = tag.func_74771_c("Type");
        Action action = null;
        if (map == null) {
            action = ActionRegistry.fromType(type);
        } else {
            String name = map.func_74779_i(String.valueOf(type));
            if (ActionRegistry.NAME_TO_CLASS.containsKey((Object)name)) {
                action = ActionRegistry.fromName(name);
            }
        }
        if (action != null) {
            action.fromNBT(tag);
        }
        return action;
    }

    public void reverse() {
        Collections.reverse(this.frames);
        Collections.reverse(this.actions);
    }

    public void fillMissingActions() {
        while (this.actions.size() < this.frames.size()) {
            this.actions.add(null);
        }
    }

    public static enum MorphType {
        REGULAR,
        PAUSE,
        FORCE;

    }

    public static class FoundAction {
        public int tick;
        public MorphAction action;

        public void set(int tick, MorphAction action) {
            this.tick = tick;
            this.action = action;
        }
    }
}

