/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording.actions;

import io.netty.buffer.ByteBuf;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.common.GunProps;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster.network.server.gun.ServerHandlerGunInteract;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.utils.EntityUtils;
import mchorse.blockbuster.utils.NBTUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class ShootGunAction
extends Action {
    private ItemStack stack;

    public ShootGunAction() {
        this(ItemStack.field_190927_a);
    }

    public ShootGunAction(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public void apply(EntityLivingBase actor) {
        EntityPlayer player;
        Frame frame = EntityUtils.getRecordPlayer(actor).getCurrentFrame();
        Object object = player = actor instanceof EntityPlayer ? (EntityPlayer)actor : ((EntityActor)actor).fakePlayer;
        if (frame == null) {
            return;
        }
        if (player != null) {
            GunProps props = NBTUtils.getGunProps(this.stack);
            if (props != null) {
                player.field_70130_N = actor.field_70130_N;
                player.field_70131_O = actor.field_70131_O;
                player.eyeHeight = actor.func_70047_e();
                player.func_174826_a(actor.func_174813_aQ());
                player.field_70165_t = actor.field_70165_t;
                player.field_70163_u = actor.field_70163_u;
                player.field_70161_v = actor.field_70161_v;
                player.field_70177_z = frame.yaw;
                player.field_70125_A = frame.pitch;
                player.func_184201_a(EntityEquipmentSlot.MAINHAND, actor.func_184614_ca());
                player.func_184201_a(EntityEquipmentSlot.OFFHAND, actor.func_184592_cb());
                ServerHandlerGunInteract.interactWithGun(null, (Entity)actor, this.stack);
            } else {
                Blockbuster.LOGGER.error("Null gun props");
            }
        }
    }

    @Override
    public void fromBuf(ByteBuf buf) {
        super.fromBuf(buf);
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    @Override
    public void toBuf(ByteBuf buf) {
        super.toBuf(buf);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        this.stack = new ItemStack(tag.func_74775_l("Stack"));
    }

    @Override
    public void toNBT(NBTTagCompound tag) {
        tag.func_74782_a("Stack", (NBTBase)this.stack.serializeNBT());
    }
}

