/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording.actions;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.utils.EntityUtils;
import mchorse.mclib.utils.RayTracing;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;

public class MountingAction
extends Action {
    public static final UUID DEFAULT = new UUID(0L, 0L);
    public UUID target = DEFAULT;
    public boolean isMounting;

    public MountingAction() {
    }

    public MountingAction(UUID target, boolean isMounting) {
        this.target = target;
        this.isMounting = isMounting;
    }

    @Override
    public void apply(EntityLivingBase actor) {
        Entity mount = EntityUtils.entityByUUID(actor.field_70170_p, this.target);
        if (mount == null) {
            Frame frame = EntityUtils.getRecordPlayer(actor).getCurrentFrame();
            if (frame == null) {
                return;
            }
            float yaw = actor.field_70177_z;
            float pitch = actor.field_70125_A;
            float yawHead = actor.field_70759_as;
            actor.field_70177_z = frame.yaw;
            actor.field_70125_A = frame.pitch;
            actor.field_70759_as = frame.yawHead;
            mount = RayTracing.getTargetEntity((Entity)actor, (double)5.0);
            actor.field_70177_z = yaw;
            actor.field_70125_A = pitch;
            actor.field_70759_as = yawHead;
        }
        if (mount == null && this.isMounting) {
            return;
        }
        if (this.isMounting) {
            actor.func_184220_m(mount);
        } else {
            actor.func_184210_p();
        }
    }

    @Override
    public void fromBuf(ByteBuf buf) {
        super.fromBuf(buf);
        this.target = new UUID(buf.readLong(), buf.readLong());
        this.isMounting = buf.readBoolean();
    }

    @Override
    public void toBuf(ByteBuf buf) {
        super.toBuf(buf);
        buf.writeLong(this.target.getMostSignificantBits());
        buf.writeLong(this.target.getLeastSignificantBits());
        buf.writeBoolean(this.isMounting);
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        this.target = new UUID(tag.func_74763_f("Most"), tag.func_74763_f("Least"));
        this.isMounting = tag.func_74767_n("Mounting");
    }

    @Override
    public void toNBT(NBTTagCompound tag) {
        tag.func_74772_a("Most", this.target.getMostSignificantBits());
        tag.func_74772_a("Least", this.target.getLeastSignificantBits());
        tag.func_74757_a("Mounting", this.isMounting);
    }
}

