/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording.actions;

import io.netty.buffer.ByteBuf;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.mclib.utils.NBTUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class HotbarChangeAction
extends Action {
    private int slotToChange = -1;
    private NBTTagCompound newItemStack = new NBTTagCompound();

    public HotbarChangeAction() {
    }

    public HotbarChangeAction(int slotToChange, ItemStack newItemStack) {
        this();
        this.slotToChange = slotToChange;
        if (newItemStack != null) {
            this.newItemStack = newItemStack.func_77955_b(new NBTTagCompound());
        }
    }

    public int getSlot() {
        return this.slotToChange;
    }

    public void setSlot(int slot) {
        this.slotToChange = slot;
    }

    public ItemStack getItemStack() {
        return new ItemStack(this.newItemStack);
    }

    public void setItemStack(ItemStack itemStack) {
        if (itemStack != null) {
            this.newItemStack = itemStack.func_77955_b(new NBTTagCompound());
        }
    }

    @Override
    public void apply(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer && this.slotToChange != -1) {
            EntityPlayer player = (EntityPlayer)entity;
            player.field_71071_by.func_70299_a(this.slotToChange, new ItemStack(this.newItemStack));
        }
    }

    @Override
    public void fromBuf(ByteBuf buf) {
        super.fromBuf(buf);
        this.slotToChange = buf.readInt();
        this.newItemStack = NBTUtils.readInfiniteTag((ByteBuf)buf);
    }

    @Override
    public void toBuf(ByteBuf buf) {
        super.toBuf(buf);
        buf.writeInt(this.slotToChange);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.newItemStack);
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        int n = this.slotToChange = tag.func_74764_b("Slot") ? tag.func_74762_e("Slot") : this.slotToChange;
        if (tag.func_74764_b("ItemStack")) {
            this.newItemStack = tag.func_74775_l("ItemStack");
        }
    }

    @Override
    public void toNBT(NBTTagCompound tag) {
        if (this.slotToChange != -1) {
            tag.func_74768_a("Slot", this.slotToChange);
        }
        if (this.newItemStack != null) {
            tag.func_74782_a("ItemStack", (NBTBase)this.newItemStack);
        }
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

