/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording.actions;

import io.netty.buffer.ByteBuf;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.recording.RecordUtils;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.mclib.utils.TextUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class ChatAction
extends Action {
    public String message = "";

    public ChatAction() {
    }

    public ChatAction(String message) {
        this.message = message;
    }

    public String getMessage(EntityLivingBase actor) {
        String message = this.message;
        String prefix = (String)Blockbuster.recordChatPrefix.get();
        if (!prefix.isEmpty()) {
            message = prefix.replace("%NAME%", actor == null ? "Player" : actor.func_70005_c_()) + message;
        }
        return TextUtils.processColoredText((String)message);
    }

    @Override
    public void apply(EntityLivingBase actor) {
        RecordUtils.broadcastMessage(this.getMessage(actor));
    }

    @Override
    public void fromBuf(ByteBuf buf) {
        super.fromBuf(buf);
        this.message = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    @Override
    public void toBuf(ByteBuf buf) {
        super.toBuf(buf);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.message);
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        this.message = tag.func_74779_i("Message");
    }

    @Override
    public void toNBT(NBTTagCompound tag) {
        tag.func_74778_a("Message", this.message);
    }
}

