/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.capabilities.recording.IRecording;
import mchorse.blockbuster.capabilities.recording.Recording;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.recording.PacketApplyFrame;
import mchorse.blockbuster.network.common.recording.PacketFramesLoad;
import mchorse.blockbuster.network.common.recording.PacketRequestedFrames;
import mchorse.blockbuster.network.common.recording.PacketUnloadFrames;
import mchorse.blockbuster.recording.RecordManager;
import mchorse.blockbuster.recording.Utils;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.recording.data.Record;
import mchorse.mclib.utils.ForgeUtils;
import mchorse.mclib.utils.MathUtils;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.DimensionManager;

public class RecordUtils {
    public static void broadcastMessage(String message) {
        RecordUtils.broadcastMessage((ITextComponent)new TextComponentString(message));
    }

    public static void broadcastMessage(String string, Object ... args) {
        RecordUtils.broadcastMessage((ITextComponent)new TextComponentTranslation(string, args));
    }

    public static void broadcastMessage(ITextComponent message) {
        for (EntityPlayerMP player : ForgeUtils.getServerPlayers()) {
            player.func_145747_a(message);
        }
    }

    public static void broadcastError(String string, Object ... objects) {
        for (EntityPlayerMP player : ForgeUtils.getServerPlayers()) {
            Blockbuster.l10n.error((ICommandSender)player, string, objects);
        }
    }

    public static void broadcastInfo(String string, Object ... objects) {
        for (EntityPlayerMP player : ForgeUtils.getServerPlayers()) {
            Blockbuster.l10n.info((ICommandSender)player, string, objects);
        }
    }

    public static boolean isReplayExists(String filename) {
        return RecordUtils.replayFile(filename).exists() || CommonProxy.manager.records.containsKey(filename);
    }

    public static File replayFile(String filename) {
        return Utils.serverFile("blockbuster/records", filename);
    }

    public static InputStream getLocalReplay(String filename) {
        return RecordUtils.class.getResourceAsStream("/assets/blockbuster/records/" + filename + ".dat");
    }

    public static List<String> getReplays() {
        return Utils.serverFiles("blockbuster/records");
    }

    public static List<String> getReplayIterations(String replay) {
        ArrayList<String> list = new ArrayList<String>();
        File replays = new File(DimensionManager.getCurrentSaveRootDirectory() + "/blockbuster/records");
        File[] files = replays.listFiles();
        if (files == null) {
            return list;
        }
        for (File file : files) {
            String name = file.getName();
            if (!file.isFile() || !name.startsWith(replay) || !name.contains(".dat~")) continue;
            list.add(name.substring(name.indexOf("~") + 1));
        }
        return list;
    }

    public static void sendRecordTo(String filename, EntityPlayerMP player) {
        RecordUtils.sendRecordTo(filename, player, -1);
    }

    public static void sendRecordTo(String filename, EntityPlayerMP player, int callbackID) {
        PacketFramesLoad packet;
        if (!RecordUtils.playerNeedsAction(filename, (EntityPlayer)player)) {
            PacketFramesLoad packet2 = callbackID == -1 ? new PacketFramesLoad(filename, PacketFramesLoad.State.NOCHANGES) : new PacketFramesLoad(filename, PacketFramesLoad.State.NOCHANGES, callbackID);
            Dispatcher.sendTo(packet2, player);
            return;
        }
        RecordManager manager = CommonProxy.manager;
        Record record = manager.records.get(filename);
        if (record == null) {
            try {
                record = new Record(filename);
                record.load(RecordUtils.replayFile(filename));
                manager.records.put(filename, record);
            }
            catch (FileNotFoundException e) {
                Blockbuster.l10n.error((ICommandSender)player, "recording.not_found", new Object[]{filename});
                record = null;
            }
            catch (Exception e) {
                Blockbuster.l10n.error((ICommandSender)player, "recording.read", new Object[]{filename});
                e.printStackTrace();
                record = null;
            }
        }
        if (record != null) {
            record.resetUnload();
            packet = callbackID == -1 ? new PacketFramesLoad(filename, record.preDelay, record.postDelay, record.frames) : new PacketFramesLoad(filename, record.preDelay, record.postDelay, record.frames, callbackID);
            Dispatcher.sendTo(packet, player);
            System.out.println("Sent " + filename + " to " + player.func_70005_c_());
        } else {
            packet = callbackID == -1 ? new PacketFramesLoad(filename, PacketFramesLoad.State.ERROR) : new PacketFramesLoad(filename, PacketFramesLoad.State.ERROR, callbackID);
            Dispatcher.sendTo(packet, player);
        }
    }

    public static void sendRequestedRecord(int id, String filename, EntityPlayerMP player) {
        Record record = CommonProxy.manager.records.get(filename);
        if (RecordUtils.playerNeedsAction(filename, (EntityPlayer)player) && record != null) {
            record.resetUnload();
            Dispatcher.sendTo(new PacketRequestedFrames(id, record.filename, record.preDelay, record.postDelay, record.frames), player);
            System.out.println("Sent " + filename + " to " + player.func_70005_c_() + " with " + id);
        } else if (record == null) {
            Blockbuster.l10n.error((ICommandSender)player, "recording.not_found", new Object[]{filename});
        }
    }

    private static boolean playerNeedsAction(String filename, EntityPlayer player) {
        if (RecordUtils.getLocalReplay(filename) != null) {
            return false;
        }
        IRecording recording = Recording.get(player);
        if (recording.isFakePlayer()) {
            return false;
        }
        boolean has = recording.hasRecording(filename);
        long time = RecordUtils.replayFile(filename).lastModified();
        if (has && time > recording.recordingTimestamp(filename)) {
            recording.updateRecordingTimestamp(filename, time);
            return true;
        }
        if (!has) {
            recording.addRecording(filename, time);
        }
        return !has;
    }

    public static void unloadRecord(Record record) {
        String filename = record.filename;
        for (EntityPlayerMP player : ForgeUtils.getServerPlayers()) {
            IRecording recording = Recording.get((EntityPlayer)player);
            if (!recording.hasRecording(filename)) continue;
            recording.removeRecording(filename);
            Dispatcher.sendTo(new PacketUnloadFrames(filename), player);
        }
    }

    public static void saveRecord(Record record) throws IOException {
        RecordUtils.saveRecord(record, true);
    }

    public static void saveRecord(Record record, boolean unload) throws IOException {
        RecordUtils.saveRecord(record, true, unload);
    }

    public static void saveRecord(Record record, boolean savePast, boolean unload) throws IOException {
        record.dirty = false;
        record.save(RecordUtils.replayFile(record.filename), savePast);
        if (unload) {
            RecordUtils.unloadRecord(record);
        }
    }

    public static void dirtyRecord(Record record) {
        record.dirty = true;
        RecordUtils.unloadRecord(record);
    }

    public static List<Frame> discontinuityEulerFilter(List<Frame> frames, int from, int to, Frame.RotationChannel channel) {
        ArrayList<Frame> filteredFrames = new ArrayList<Frame>();
        if (to - from + 1 < 2) {
            return filteredFrames;
        }
        for (int i = from; i < frames.size() && i <= to; ++i) {
            if (i == 0) {
                filteredFrames.add(frames.get(i));
                continue;
            }
            Frame filteredFrame = frames.get(i).copy();
            Frame prevFrame = frames.get(i - 1);
            if (i > from) {
                prevFrame = (Frame)filteredFrames.get(i - from - 1);
            }
            switch (channel) {
                case BODY_YAW: {
                    float prev = (float)Math.toRadians(prevFrame.bodyYaw);
                    float current = (float)Math.toRadians(frames.get((int)i).bodyYaw);
                    filteredFrame.bodyYaw = (float)Math.toDegrees(MathUtils.filterFlips((float)prev, (float)current));
                    break;
                }
                case HEAD_PITCH: {
                    float prev = (float)Math.toRadians(prevFrame.pitch);
                    float current = (float)Math.toRadians(frames.get((int)i).pitch);
                    filteredFrame.pitch = (float)Math.toDegrees(MathUtils.filterFlips((float)prev, (float)current));
                    break;
                }
                case HEAD_YAW: {
                    float prev = (float)Math.toRadians(prevFrame.yawHead);
                    float current = (float)Math.toRadians(frames.get((int)i).yawHead);
                    filteredFrame.yawHead = (float)Math.toDegrees(MathUtils.filterFlips((float)prev, (float)current));
                    prev = (float)Math.toRadians(prevFrame.yaw);
                    current = (float)Math.toRadians(frames.get((int)i).yaw);
                    filteredFrame.yaw = (float)Math.toDegrees(MathUtils.filterFlips((float)prev, (float)current));
                }
            }
            filteredFrames.add(filteredFrame);
        }
        return filteredFrames;
    }

    public static void applyFrameOnEntity(EntityLivingBase entity, Record record, int tick) {
        tick = MathUtils.clamp((int)tick, (int)0, (int)(record.frames.size() - 1));
        Frame frame = record.frames.get(tick);
        frame.apply(entity, true);
        entity.field_70761_aq = frame.bodyYaw;
        PacketApplyFrame packet = new PacketApplyFrame(frame, entity.func_145782_y());
        if (entity.field_70170_p.field_72995_K) {
            Dispatcher.sendToServer(packet);
        } else {
            for (EntityPlayerMP player : ForgeUtils.getServerPlayers()) {
                Dispatcher.sendTo(packet, player);
            }
        }
    }
}

