/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording;

import com.google.common.collect.Queues;
import java.util.Queue;
import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.PacketActorPause;
import mchorse.blockbuster.network.common.recording.PacketPlayback;
import mchorse.blockbuster.recording.MPMHelper;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.recording.data.Mode;
import mchorse.blockbuster.recording.data.Record;
import mchorse.blockbuster.recording.scene.Replay;
import mchorse.blockbuster.utils.EntityUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class RecordPlayer {
    public Record record;
    public Mode mode;
    public EntityLivingBase actor;
    public int tick = 0;
    public boolean kill = false;
    public boolean playing = true;
    public boolean sync = false;
    private Replay replay;
    public boolean realPlayer;
    public Queue<IMessage> unsentPackets = Queues.newArrayDeque();
    public boolean actorUpdated;

    public RecordPlayer(Record record, Mode mode, EntityLivingBase actor) {
        this.record = record;
        this.mode = mode;
        this.actor = actor;
    }

    public Replay getReplay() {
        return this.replay;
    }

    public void setReplay(Replay replay) {
        this.replay = replay;
        if (this.record != null) {
            this.record.setReplay(this.replay);
        }
    }

    public RecordPlayer realPlayer() {
        this.realPlayer = true;
        return this;
    }

    public boolean isFinished() {
        boolean isFinished;
        boolean bl = isFinished = this.record != null && this.tick - this.record.preDelay - this.record.postDelay >= this.record.getLength();
        if (isFinished && this.sync && this.playing) {
            this.pause();
            return false;
        }
        return isFinished;
    }

    public int getTick() {
        return Math.max(0, this.record == null ? this.tick : this.tick - this.record.preDelay);
    }

    public Frame getCurrentFrame() {
        return this.record.getFrame(this.getTick());
    }

    public void playActions() {
        if (!this.playing || this.isFinished()) {
            return;
        }
        if (this.record != null) {
            if (this.mode == Mode.ACTIONS || this.mode == Mode.BOTH) {
                this.applyAction(this.tick, this.actor, false);
            }
            this.record.resetUnload();
        }
    }

    public void next() {
        this.next(this.actor);
    }

    public void next(EntityLivingBase actor) {
        if (this.record != null) {
            this.record.resetUnload();
        }
        if (!this.playing || this.isFinished()) {
            return;
        }
        if (this.record != null) {
            if (this.mode == Mode.FRAMES || this.mode == Mode.BOTH) {
                this.applyFrame(this.tick, actor, false);
            }
            this.record.resetUnload();
        }
        if (this.tick == 0) {
            actor.field_70761_aq = actor.field_70177_z;
        }
        ++this.tick;
        this.actorUpdated = true;
    }

    public void pause() {
        this.playing = false;
        this.actor.field_70145_X = true;
        this.actor.func_184224_h(true);
        this.applyFrame(this.tick - 1, this.actor, true);
        if (this.actor.func_70613_aW()) {
            this.record.applyPreviousMorph(this.actor, this.replay, this.tick, Record.MorphType.PAUSE);
            this.sendToTracked(new PacketActorPause(this.actor.func_145782_y(), true, this.tick));
        }
    }

    public void resume(int tick) {
        if (tick >= 0) {
            this.tick = tick;
        }
        this.playing = true;
        this.actor.field_70145_X = false;
        if (!this.actor.field_70170_p.field_72995_K && this.replay != null) {
            this.actor.func_184224_h(this.replay.invincible);
        }
        this.applyFrame(this.tick, this.actor, true);
        if (this.actor.func_70613_aW()) {
            this.record.applyPreviousMorph(this.actor, this.replay, tick, Record.MorphType.FORCE);
            this.sendToTracked(new PacketActorPause(this.actor.func_145782_y(), false, this.tick));
        }
    }

    public void goTo(int tick, boolean actions) {
        int preDelay = this.record.preDelay;
        int original = tick;
        if (tick > this.record.frames.size() + this.record.preDelay) {
            tick = this.record.frames.size() + this.record.preDelay - 1;
        }
        int min = Math.min(this.tick - this.record.preDelay, tick -= preDelay);
        int max = Math.max(this.tick - this.record.preDelay, tick);
        if (actions) {
            for (int i = min; i < max; ++i) {
                this.record.applyAction(i, this.actor);
            }
        }
        this.tick = original;
        this.record.resetUnload();
        this.record.applyFrame(this.playing ? tick : Math.max(0, tick - 1), this.actor, true, this.realPlayer);
        if (actions) {
            this.record.applyAction(tick, this.actor);
            if (this.replay != null) {
                this.record.applyPreviousMorph(this.actor, this.replay, tick, this.playing ? Record.MorphType.FORCE : Record.MorphType.PAUSE);
            }
        }
        if (this.actor.func_70613_aW()) {
            this.sendToTracked(new PacketActorPause(this.actor.func_145782_y(), !this.playing, this.tick));
        }
    }

    public void startPlaying(String filename, boolean kill) {
        this.startPlaying(filename, 0, kill);
    }

    public void startPlaying(String filename, int tick, boolean kill) {
        this.tick = tick;
        this.kill = kill;
        this.sync = false;
        if (!this.actor.field_70170_p.field_72995_K && this.replay != null) {
            this.actor.func_184224_h(this.replay.invincible);
        }
        this.applyFrame(this.playing ? tick : tick - 1, this.actor, true);
        EntityUtils.setRecordPlayer(this.actor, this);
        this.sendToTracked(new PacketPlayback(this.actor.func_145782_y(), true, this.realPlayer, filename, this.replay));
        if (this.realPlayer && this.actor instanceof EntityPlayerMP) {
            Dispatcher.sendTo(new PacketPlayback(this.actor.func_145782_y(), true, this.realPlayer, filename, this.replay), (EntityPlayerMP)this.actor);
        }
    }

    public void stopPlaying() {
        CommonProxy.manager.stop(this);
        this.actor.field_70145_X = false;
        if (!this.actor.field_70170_p.field_72995_K && this.replay != null && this.replay.invincible) {
            this.actor.func_184224_h(false);
        }
    }

    public void applyFrame(int tick, EntityLivingBase target, boolean force) {
        if ((tick -= this.record.preDelay) < 0) {
            tick = 0;
        } else if (tick >= this.record.frames.size()) {
            tick = this.record.frames.size() - 1;
        }
        this.record.applyFrame(tick, target, force, this.realPlayer);
    }

    public void applyAction(int tick, EntityLivingBase target, boolean safe) {
        this.record.applyAction(tick - this.record.preDelay, target, safe);
    }

    public void sendToTracked(IMessage packet) {
        if (this.actor.field_70170_p.func_73045_a(this.actor.func_145782_y()) != this.actor) {
            this.unsentPackets.add(packet);
        } else {
            Dispatcher.sendToTracked((Entity)this.actor, packet);
        }
    }

    public void checkAndSpawn() {
        if (this.actor.field_70170_p.func_73045_a(this.actor.func_145782_y()) != this.actor) {
            if (this.actor instanceof EntityActor) {
                if (!this.actor.field_70128_L) {
                    this.actor.field_70170_p.func_72838_d((Entity)this.actor);
                    EntityActor.EntityFakePlayer player = ((EntityActor)this.actor).fakePlayer;
                    player.field_70165_t = this.actor.field_70165_t;
                    player.field_70163_u = this.actor.field_70163_u;
                    player.field_70161_v = this.actor.field_70161_v;
                    this.actor.field_70170_p.field_72996_f.add(((EntityActor)this.actor).fakePlayer);
                }
            } else if (this.actor instanceof EntityPlayer) {
                if (this.record.playerData != null) {
                    if (!this.realPlayer) {
                        this.actor.func_70037_a(this.record.playerData);
                    }
                    if (MPMHelper.isLoaded() && this.record.playerData.func_150297_b("MPMData", 10)) {
                        MPMHelper.setMPMData((EntityPlayer)this.actor, this.record.playerData.func_74775_l("MPMData"));
                    }
                }
                if (!this.realPlayer && !this.actor.field_70128_L) {
                    this.actor.field_70170_p.func_73046_m().func_184103_al().func_72377_c((EntityPlayerMP)this.actor);
                }
            }
            while (!this.unsentPackets.isEmpty()) {
                Dispatcher.sendToTracked((Entity)this.actor, this.unsentPackets.poll());
            }
        }
    }
}

