/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.network.server.recording;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.recording.PacketFramesOverwrite;
import mchorse.blockbuster.recording.RecordUtils;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.recording.data.Record;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.network.AbstractDispatcher;
import mchorse.mclib.network.ServerMessageHandler;
import mchorse.mclib.network.mclib.client.ClientHandlerAnswer;
import mchorse.mclib.network.mclib.common.IAnswerRequest;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ServerHandlerFramesOverwrite
extends ServerMessageHandler<PacketFramesOverwrite> {
    private static Map<OverwriteIdentifier, List<Frame>> overwriteQueue = new HashMap<OverwriteIdentifier, List<Frame>>();

    public void run(EntityPlayerMP entityPlayerMP, PacketFramesOverwrite packet) {
        Record targetRecord;
        IKey answer = null;
        boolean status = false;
        if (packet.frames.isEmpty()) {
            System.out.println("Received an empty chunk...");
            return;
        }
        try {
            targetRecord = CommonProxy.manager.get(packet.filename);
            if (targetRecord == null) {
                this.sendAnswer(packet, entityPlayerMP, IKey.format((String)"blockbuster.error.recording.not_found", (Object[])new Object[]{packet.filename}), false);
                return;
            }
        }
        catch (Exception e) {
            this.sendAnswer(packet, entityPlayerMP, IKey.lang((String)"blockbuster.gui.director.rotation_filter.record_save_error"), false);
            return;
        }
        OverwriteIdentifier key = null;
        OverwriteIdentifier targetKey = new OverwriteIdentifier(packet.getFrom(), packet.getTo(), packet.filename);
        for (Map.Entry<OverwriteIdentifier, List<Frame>> entry : overwriteQueue.entrySet()) {
            if (!entry.getKey().equals(targetKey)) continue;
            key = entry.getKey();
            break;
        }
        if (key == null) {
            key = targetKey;
            overwriteQueue.put(key, new ArrayList());
        }
        List<Frame> frames = overwriteQueue.get(key);
        if (this.insertChunk(packet.frames, packet.getIndex(), frames)) {
            if (frames.size() == key.toTick - key.fromTick + 1 && !frames.contains(null)) {
                if (key.toTick >= targetRecord.frames.size()) {
                    status = false;
                    answer = IKey.lang((String)"blockbuster.gui.director.rotation_filter.record_save_error");
                    System.out.println("toTick " + key.toTick + " out of range of record frames size.");
                } else {
                    for (int i = key.fromTick; i <= key.toTick; ++i) {
                        targetRecord.frames.set(i, frames.get(i - key.fromTick));
                    }
                    try {
                        RecordUtils.saveRecord(targetRecord);
                        status = true;
                        answer = IKey.lang((String)"blockbuster.gui.director.rotation_filter.success");
                    }
                    catch (IOException e) {
                        status = false;
                        answer = IKey.lang((String)"blockbuster.gui.director.rotation_filter.record_save_error");
                        e.printStackTrace();
                    }
                }
                overwriteQueue.remove(key);
            }
        } else {
            status = false;
            answer = IKey.lang((String)"blockbuster.gui.director.rotation_filter.frame_chunk_error");
            overwriteQueue.remove(key);
        }
        if (answer != null) {
            this.sendAnswer(packet, entityPlayerMP, answer, status);
        }
    }

    private void sendAnswer(PacketFramesOverwrite packet, EntityPlayerMP player, IKey message, boolean status) {
        if (packet.getCallbackID().isPresent()) {
            ClientHandlerAnswer.sendAnswerTo((EntityPlayerMP)player, packet.getAnswer(new AbstractMap.SimpleEntry<IKey, Boolean>(message, status)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendFramesToServer(String filename, List<Frame> frames, int from, int to) {
        ServerHandlerFramesOverwrite.sendFramesToServer(filename, frames, from, to, null);
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendFramesToServer(String filename, List<Frame> frames, int from, int to, @Nullable Consumer<AbstractMap.SimpleEntry<IKey, Boolean>> callback) {
        int cap = 400;
        if (frames.size() <= cap) {
            if (callback != null) {
                ClientHandlerAnswer.requestServerAnswer((AbstractDispatcher)Dispatcher.DISPATCHER, (IAnswerRequest)new PacketFramesOverwrite(from, to, 0, filename, frames), callback);
            } else {
                Dispatcher.sendToServer(new PacketFramesOverwrite(from, to, 0, filename, frames));
            }
            return;
        }
        ArrayList<Frame> chunk = new ArrayList<Frame>();
        int chunkStart = 0;
        for (int i = 0; i < frames.size(); ++i) {
            chunk.add(frames.get(i));
            if (chunk.size() != cap && i != frames.size() - 1) continue;
            if (callback != null) {
                ClientHandlerAnswer.requestServerAnswer((AbstractDispatcher)Dispatcher.DISPATCHER, (IAnswerRequest)new PacketFramesOverwrite(from, to, chunkStart, filename, chunk), callback);
            } else {
                Dispatcher.sendToServer(new PacketFramesOverwrite(from, to, chunkStart, filename, chunk));
            }
            chunk.clear();
            chunkStart += cap;
        }
    }

    protected boolean insertChunk(List<Frame> chunk, int targetIndex, List<Frame> frames) {
        if (targetIndex > frames.size()) {
            Frame[] nulls = new Frame[targetIndex - frames.size()];
            frames.addAll(Arrays.asList(nulls));
            frames.addAll(chunk);
        } else if (targetIndex == frames.size()) {
            frames.addAll(chunk);
        } else {
            int i;
            for (i = targetIndex; i < frames.size() && i < targetIndex + chunk.size() && frames.get(i) == null; ++i) {
            }
            if (i == targetIndex + chunk.size()) {
                for (int j = targetIndex; j < targetIndex + chunk.size(); ++j) {
                    frames.set(j, chunk.get(j - targetIndex));
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static class OverwriteIdentifier {
        private int fromTick;
        private int toTick;
        private String filename;

        public OverwriteIdentifier(int from, int to, String filename) {
            this.fromTick = Math.min(from, to);
            this.toTick = Math.max(from, to);
            this.filename = filename;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OverwriteIdentifier) {
                OverwriteIdentifier framesOverwrite = (OverwriteIdentifier)obj;
                return framesOverwrite.filename.equals(this.filename) && framesOverwrite.fromTick == this.fromTick && framesOverwrite.toTick == this.toTick;
            }
            return false;
        }
    }
}

