/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.network.common.recording.actions;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.blockbuster.recording.actions.ActionRegistry;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketActions
implements IMessage {
    public String filename;
    public List<List<Action>> actions;
    public boolean open;

    public PacketActions() {
        this.actions = new ArrayList<List<Action>>();
    }

    public PacketActions(String filename, List<List<Action>> actions, boolean open) {
        this.filename = filename;
        this.actions = actions;
        this.open = open;
    }

    public void fromBytes(ByteBuf buf) {
        this.filename = ByteBufUtils.readUTF8String((ByteBuf)buf);
        int c = buf.readInt();
        for (int i = 0; i < c; ++i) {
            int count = buf.readByte();
            if (count != 0) {
                ArrayList<Action> actions = new ArrayList<Action>();
                for (int j = 0; j < count; ++j) {
                    Action action = ActionRegistry.fromByteBuf(buf);
                    if (action == null) continue;
                    actions.add(action);
                }
                this.actions.add(actions);
                continue;
            }
            this.actions.add(null);
        }
        this.open = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        boolean i = false;
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.filename);
        buf.writeInt(this.actions.size());
        for (List<Action> list : this.actions) {
            int count = list == null ? 0 : list.size();
            buf.writeByte(count);
            if (count == 0) continue;
            for (Action action : list) {
                ActionRegistry.toByteBuf(action, buf);
            }
        }
        buf.writeBoolean(this.open);
    }
}

