/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.network.common.recording;

import io.netty.buffer.ByteBuf;
import java.util.AbstractMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import mchorse.blockbuster.network.common.recording.PacketFrames;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.network.mclib.common.IAnswerRequest;
import mchorse.mclib.network.mclib.common.PacketAnswer;

public class PacketFramesOverwrite
extends PacketFrames
implements IAnswerRequest<AbstractMap.SimpleEntry<IKey, Boolean>> {
    private int from;
    private int to;
    private int index;
    private int callbackID = -1;

    public PacketFramesOverwrite() {
    }

    public PacketFramesOverwrite(int from, int to, int index, String filename, List<Frame> frames) {
        super(filename, 0, 0, frames);
        this.from = from;
        this.to = to;
        this.index = index;
    }

    public PacketFramesOverwrite(int from, int to, int index, String filename, List<Frame> frames, int callbackID) {
        this(from, to, index, filename, frames);
        this.callbackID = callbackID;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public int getIndex() {
        return this.index;
    }

    public void setCallbackID(int callbackID) {
        this.callbackID = callbackID;
    }

    public Optional<Integer> getCallbackID() {
        return Optional.ofNullable(this.callbackID == -1 ? null : Integer.valueOf(this.callbackID));
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.from = buf.readInt();
        this.to = buf.readInt();
        this.index = buf.readInt();
        this.callbackID = buf.readInt();
        super.fromBytes(buf);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.from);
        buf.writeInt(this.to);
        buf.writeInt(this.index);
        buf.writeInt(this.callbackID);
        super.toBytes(buf);
    }

    public PacketAnswer<AbstractMap.SimpleEntry<IKey, Boolean>> getAnswer(AbstractMap.SimpleEntry<IKey, Boolean> value) throws NoSuchElementException {
        return new PacketAnswer(this.getCallbackID().get().intValue(), value);
    }
}

