/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.network.common.audio;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import mchorse.blockbuster.audio.AudioState;
import mchorse.mclib.utils.LatencyTimer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketAudio
implements IMessage {
    public String audio;
    public AudioState state;
    public int shift;
    public LatencyTimer delay;

    public PacketAudio() {
    }

    public PacketAudio(String audio, AudioState state, int shift) {
        this(audio, state, shift, null);
    }

    public PacketAudio(String audio, AudioState state, int shift, @Nullable LatencyTimer delay) {
        this.audio = audio;
        this.state = state;
        this.shift = shift;
        this.delay = delay;
    }

    public void fromBytes(ByteBuf buf) {
        this.audio = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.state = AudioState.values()[buf.readInt()];
        this.shift = buf.readInt();
        if (buf.readBoolean()) {
            this.delay = new LatencyTimer();
            this.delay.fromBytes(buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.audio);
        buf.writeInt(this.state.ordinal());
        buf.writeInt(this.shift);
        buf.writeBoolean(this.delay != null);
        if (this.delay != null) {
            this.delay.toBytes(buf);
        }
    }
}

