/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.network.client.recording;

import java.util.ArrayList;
import mchorse.blockbuster.ClientProxy;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.recording.PacketFramesChunk;
import mchorse.blockbuster.network.common.recording.PacketPlayerRecording;
import mchorse.blockbuster.recording.RecordRecorder;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.recording.data.Mode;
import mchorse.blockbuster.recording.data.Record;
import mchorse.mclib.network.ClientMessageHandler;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientHandlerPlayerRecording
extends ClientMessageHandler<PacketPlayerRecording> {
    @SideOnly(value=Side.CLIENT)
    public void run(EntityPlayerSP player, PacketPlayerRecording message) {
        ClientProxy.recordingOverlay.setVisible(message.recording);
        ClientProxy.recordingOverlay.setCaption(message.filename, true);
        if (message.recording) {
            ClientProxy.manager.record(message.filename, (EntityPlayer)player, Mode.FRAMES, false, false, message.offset, null);
        } else {
            if (!message.canceled) {
                this.sendFrames(ClientProxy.manager.recorders.get(player));
            }
            ClientProxy.manager.halt((EntityPlayer)player, false, false, message.canceled);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void sendFrames(RecordRecorder recorder) {
        Record record = recorder.record;
        int cap = 400;
        int length = record.getLength();
        int offset = recorder.offset;
        if (length < cap) {
            Dispatcher.sendToServer(new PacketFramesChunk(0, 1, offset, record.filename, record.frames));
            return;
        }
        int c = length / cap + 1;
        for (int i = 0; i < c; ++i) {
            int d;
            ArrayList<Frame> frames = new ArrayList<Frame>();
            int n = d = length - i * cap > cap ? cap : length % cap;
            for (int j = 0; j < d; ++j) {
                frames.add(record.frames.get(j + i * cap));
            }
            Dispatcher.sendToServer(new PacketFramesChunk(i, c, offset, record.filename, frames));
        }
    }
}

