/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.events;

import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class TickHandler {
    private final Map<TickIdentifier, Set<Runnable>> runnables = new HashMap<TickIdentifier, Set<Runnable>>();

    public void addRunnable(Class<? extends TickEvent> eventType, Side side, Runnable runnable) {
        this.addRunnable(eventType, side, TickEvent.Phase.START, runnable);
    }

    public void addRunnable(Class<? extends TickEvent> eventType, Side side, TickEvent.Phase phase, Runnable runnable) {
        this.runnables.computeIfAbsent(new TickIdentifier(eventType, phase, side), k -> Collections.newSetFromMap(new IdentityHashMap())).add(runnable);
    }

    public void removeRunnable(Class<? extends TickEvent> eventType, Side side, TickEvent.Phase phase, Runnable runnable) {
        TickIdentifier identifier = new TickIdentifier(eventType, phase, side);
        Set<Runnable> runnableSet = this.runnables.get(identifier);
        if (runnableSet != null) {
            runnableSet.remove(runnable);
            if (runnableSet.isEmpty()) {
                this.runnables.remove(identifier);
            }
        }
    }

    public void removeRunnable(Class<? extends TickEvent> eventType, Side side, Runnable runnable) {
        this.removeRunnable(eventType, side, TickEvent.Phase.START, runnable);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        this.runRunnables(new TickIdentifier(TickEvent.WorldTickEvent.class, event.phase, event.side));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Class eventType = TickEvent.PlayerTickEvent.class;
        if (event.side == Side.CLIENT && Minecraft.func_71410_x().field_71439_g == event.player) {
            eventType = WorldClientTickEvent.class;
        }
        this.runRunnables(new TickIdentifier(eventType, event.phase, event.side));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        this.runRunnables(new TickIdentifier(TickEvent.ClientTickEvent.class, event.phase, event.side));
    }

    private void runRunnables(TickIdentifier identifier) {
        Set<Runnable> runnableSet = this.runnables.get(identifier);
        if (runnableSet == null) {
            return;
        }
        Iterator<Runnable> i = runnableSet.iterator();
        while (i.hasNext()) {
            Runnable runnable = i.next();
            runnable.run();
            if (!(runnable instanceof IRunnable) || !((IRunnable)runnable).shouldRemove()) continue;
            i.remove();
        }
        if (runnableSet.isEmpty()) {
            this.runnables.remove(identifier);
        }
    }

    public static class WorldClientTickEvent
    extends TickEvent.WorldTickEvent {
        public WorldClientTickEvent(TickEvent.Phase phase, World world) {
            super(Side.CLIENT, phase, world);
        }
    }

    public static class TickIdentifier {
        public final Class<? extends TickEvent> eventType;
        public final TickEvent.Phase eventPhase;
        public final Side side;

        public TickIdentifier(Class<? extends TickEvent> eventType, TickEvent.Phase eventPhase, Side side) {
            this.eventType = eventType;
            this.eventPhase = eventPhase;
            this.side = side;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TickIdentifier)) {
                return false;
            }
            TickIdentifier that = (TickIdentifier)o;
            return Objects.equals(this.eventType, that.eventType) && this.eventPhase == that.eventPhase && this.side == that.side;
        }

        public int hashCode() {
            return Objects.hash(this.eventType, this.eventPhase, this.side);
        }
    }

    public static interface IRunnable
    extends Runnable {
        public boolean shouldRemove();
    }
}

