/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.events;

import java.lang.reflect.Field;
import mchorse.blockbuster.client.KeyboardHandler;
import mchorse.blockbuster.common.GunProps;
import mchorse.blockbuster.common.item.ItemGun;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.guns.PacketGunInteract;
import mchorse.blockbuster.network.common.guns.PacketGunReloading;
import mchorse.blockbuster.utils.NBTUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GunShootHandler {
    private boolean canBeShotPress = true;
    private boolean canBeReloaded = true;
    private Field leftClickCounter = null;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        ItemStack stack = mc.field_71439_g.func_184614_ca();
        if (stack.func_77973_b() instanceof ItemGun) {
            this.blockLeftClick(mc);
            this.handleShootKey(mc, stack);
            this.handleReloading(mc, stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void handleShootKey(Minecraft mc, ItemStack stack) {
        GunProps props = NBTUtils.getGunProps(stack);
        if (KeyboardHandler.gunShoot.func_151470_d()) {
            if (this.canBeShotPress && props.storedShotDelay == 0L && props.state == ItemGun.GunState.READY_TO_SHOOT) {
                Dispatcher.sendToServer(new PacketGunInteract(stack, mc.field_71439_g.func_145782_y()));
                this.canBeShotPress = false;
                return;
            }
            if (props.storedShotDelay == 0L && props.shootWhenHeld) {
                this.canBeShotPress = true;
            }
        } else {
            this.canBeShotPress = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void handleReloading(Minecraft mc, ItemStack stack) {
        GunProps props = NBTUtils.getGunProps(stack);
        if (KeyboardHandler.gunReload.func_151470_d() && this.canBeReloaded && props.state == ItemGun.GunState.READY_TO_SHOOT) {
            Dispatcher.sendToServer(new PacketGunReloading(stack, mc.field_71439_g.func_145782_y()));
            this.canBeReloaded = false;
        } else {
            this.canBeReloaded = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void blockLeftClick(Minecraft mc) {
        if (KeyboardHandler.gunShoot.conflicts(mc.field_71474_y.field_74312_F)) {
            if (this.leftClickCounter == null) {
                try {
                    this.leftClickCounter = Minecraft.class.getDeclaredField("field_71429_W");
                    this.leftClickCounter.setAccessible(true);
                }
                catch (NoSuchFieldException | SecurityException e) {
                    try {
                        this.leftClickCounter = Minecraft.class.getDeclaredField("leftClickCounter");
                        this.leftClickCounter.setAccessible(true);
                    }
                    catch (NoSuchFieldException | SecurityException exception) {
                        // empty catch block
                    }
                }
            }
            try {
                this.leftClickCounter.setInt(mc, 10000);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }
}

