/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.core.transformers;

import java.util.ListIterator;
import mchorse.blockbuster.utils.mclib.coremod.ClassTransformer;
import mchorse.blockbuster.utils.mclib.coremod.CoreClassTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class RenderGlobalTransformer
extends ClassTransformer {
    @Override
    public void process(String name, ClassNode node) {
        for (MethodNode method : node.methods) {
            String methodName = this.checkName(method, "a", "(FI)V", "renderSky", "(FI)V");
            if (methodName != null) {
                this.processRenderSky(method);
            }
            if ((methodName = this.checkName(method, "a", "(FIDDD)V", "renderClouds", "(FIDDD)V")) != null) {
                this.processRenderClouds(method);
            }
            if ((methodName = this.checkName(method, "a", "(Lvg;Lbxy;F)V", "renderEntities", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/client/renderer/culling/ICamera;F)V")) == null) continue;
            this.processRenderEntities(method);
        }
    }

    private void processRenderSky(MethodNode method) {
        LabelNode label = this.getFirstLabel(method);
        if (label != null) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new MethodInsnNode(184, "mchorse/blockbuster/client/RenderingHandler", "isGreenSky", "()Z", false));
            list.add((AbstractInsnNode)new JumpInsnNode(153, label));
            list.add((AbstractInsnNode)new MethodInsnNode(184, "mchorse/blockbuster/client/RenderingHandler", "renderGreenSky", "()V", false));
            list.add((AbstractInsnNode)new InsnNode(177));
            method.instructions.insert(list);
            System.out.println("BBCoreMod: successfully patched renderSky!");
        }
    }

    private void processRenderClouds(MethodNode method) {
        LabelNode label = this.getFirstLabel(method);
        if (label != null) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new MethodInsnNode(184, "mchorse/blockbuster/client/RenderingHandler", "isGreenSky", "()Z", false));
            list.add((AbstractInsnNode)new JumpInsnNode(153, label));
            list.add((AbstractInsnNode)new InsnNode(177));
            method.instructions.insert(list);
            System.out.println("BBCoreMod: successfully patched renderClouds!");
        }
    }

    private void processRenderEntities(MethodNode method) {
        LabelNode releaseLabel = null;
        LabelNode renderEntityLabel = null;
        LabelNode lastLabel = null;
        boolean captureNext = false;
        int renderCounter = 0;
        ListIterator it = method.instructions.iterator();
        boolean insertedRenderLastCall = false;
        boolean foundAllForAddEntitiesHook = false;
        while (it.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)it.next();
            if (!foundAllForAddEntitiesHook && node instanceof LabelNode) {
                lastLabel = (LabelNode)node;
                if (captureNext && renderEntityLabel == null) {
                    renderEntityLabel = lastLabel;
                    captureNext = false;
                }
            }
            if (!(node instanceof MethodInsnNode)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)node;
            if (!foundAllForAddEntitiesHook) {
                if (CoreClassTransformer.checkName(methodInsnNode.owner, "bzf", "net/minecraft/client/renderer/entity/RenderManager") && CoreClassTransformer.checkName(methodInsnNode.name, "a", "renderEntityStatic") && CoreClassTransformer.checkName(methodInsnNode.desc, "(Lvg;FZ)V", "(Lnet/minecraft/entity/Entity;FZ)V")) {
                    if (renderCounter == 1) {
                        captureNext = true;
                    }
                    ++renderCounter;
                }
                if (CoreClassTransformer.checkName(methodInsnNode.owner, "et$b", "net/minecraft/util/math/BlockPos$PooledMutableBlockPos") && CoreClassTransformer.checkName(methodInsnNode.name, "t", "release") && methodInsnNode.desc.equals("()V")) {
                    releaseLabel = lastLabel;
                    foundAllForAddEntitiesHook = true;
                }
            }
            if (!CoreClassTransformer.checkName(methodInsnNode.owner, "buy", "net/minecraft/client/renderer/RenderGlobal") || !CoreClassTransformer.checkName(methodInsnNode.name, "v", "postRenderDamagedBlocks") || !methodInsnNode.desc.equals("()V")) continue;
            method.instructions.insert((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new MethodInsnNode(184, "mchorse/blockbuster/client/RenderingHandler", "renderLastEntities", "()V", false));
            insertedRenderLastCall = true;
            break;
        }
        if (renderEntityLabel != null && releaseLabel != null) {
            String entity = CoreClassTransformer.get("Lvg;", "Lnet/minecraft/entity/Entity;");
            int localIndex = 0;
            for (LocalVariableNode var : method.localVariables) {
                if (!var.desc.equals(entity)) continue;
                localIndex = Math.max(localIndex, var.index);
            }
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, localIndex));
            list.add((AbstractInsnNode)new MethodInsnNode(184, "mchorse/blockbuster/client/RenderingHandler", "addRenderedEntity", "(" + entity + ")V", false));
            if (insertedRenderLastCall) {
                method.instructions.insert((AbstractInsnNode)renderEntityLabel, list);
                System.out.println("BBCoreMod: successfully patched renderEntities!");
            }
        }
    }
}

