/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.common.item;

import java.util.List;
import java.util.Objects;
import javax.vecmath.Matrix3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.client.render.tileentity.TileEntityGunItemStackRenderer;
import mchorse.blockbuster.common.GunProps;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster.common.entity.EntityGunProjectile;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.guns.PacketGunInfo;
import mchorse.blockbuster.network.common.guns.PacketGunShot;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.blockbuster.recording.actions.ShootGunAction;
import mchorse.blockbuster.utils.NBTUtils;
import mchorse.blockbuster_pack.morphs.SequencerMorph;
import mchorse.mclib.utils.Interpolation;
import mchorse.mclib.utils.OpHelper;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ItemGun
extends Item {
    public static float getRandom(float a, float b) {
        return (float)Math.random() * (a - b) + b;
    }

    public ItemGun() {
        this.func_77625_d(1);
        this.setRegistryName("gun");
        this.func_77655_b("blockbuster.gun");
        this.func_77637_a(Blockbuster.blockbusterTab);
    }

    public boolean shouldCauseReequipAnimation(ItemStack from, ItemStack to, boolean changed) {
        if (!changed && to.func_77973_b() instanceof ItemGun) {
            TileEntityGunItemStackRenderer.GunEntry oldEntry = TileEntityGunItemStackRenderer.models.get(from);
            TileEntityGunItemStackRenderer.GunEntry newEntry = TileEntityGunItemStackRenderer.models.get(to);
            if (oldEntry != null) {
                GunProps newProps = NBTUtils.getGunProps(to);
                boolean isSameModel = true;
                isSameModel &= Objects.equals(oldEntry.props.defaultMorph, newProps.defaultMorph);
                isSameModel &= Objects.equals(oldEntry.props.firingMorph, newProps.firingMorph);
                isSameModel &= Objects.equals(oldEntry.props.crosshairMorph, newProps.crosshairMorph);
                isSameModel &= Objects.equals(oldEntry.props.handsMorph, newProps.handsMorph);
                isSameModel &= Objects.equals(oldEntry.props.reloadMorph, newProps.reloadMorph);
                if ((isSameModel &= Objects.equals(oldEntry.props.zoomOverlayMorph, newProps.zoomOverlayMorph)) && newEntry == null) {
                    TileEntityGunItemStackRenderer.models.put(to, TileEntityGunItemStackRenderer.models.remove(from));
                }
                return !isSameModel;
            }
        }
        return true;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        GunProps props = NBTUtils.getGunProps(stack);
        boolean result = super.func_77644_a(stack, target, attacker);
        if (props == null) {
            return result;
        }
        if (!result) {
            if (!props.meleeCommand.isEmpty() && attacker instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)attacker;
                player.func_184102_h().field_71321_q.func_71556_a((ICommandSender)player, props.meleeCommand);
            }
            target.func_70606_j(target.func_110143_aJ() - props.meleeDamage);
            return false;
        }
        return true;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return 0;
    }

    public static void decreaseTime(ItemStack stack, EntityPlayer player) {
        GunProps props = NBTUtils.getGunProps(stack);
        if (props == null) {
            return;
        }
        if (props.storedShotDelay > 0L) {
            props.storedShotDelay = Math.max(props.storedShotDelay - 1L, 0L);
            NBTUtils.saveGunProps(stack, props.toNBT());
            if (!player.field_70170_p.field_72995_K) {
                Dispatcher.sendTo(new PacketGunInfo(props.toNBT(), player.func_145782_y()), (EntityPlayerMP)player);
                Dispatcher.sendToTracked((Entity)player, new PacketGunInfo(props.toNBT(), player.func_145782_y()));
            }
        }
    }

    private void resetTime(ItemStack stack, EntityPlayer player) {
        GunProps props = NBTUtils.getGunProps(stack);
        if (props == null) {
            return;
        }
        props.storedShotDelay = props.shotDelay;
        NBTUtils.saveGunProps(stack, props.toNBT());
    }

    public static void decreaseReload(ItemStack stack, EntityPlayer player) {
        GunProps props = NBTUtils.getGunProps(stack);
        if (props == null) {
            return;
        }
        if (props.state == GunState.RELOADING) {
            --props.storedReloadingTime;
            if (props.storedReloadingTime <= 0L) {
                props.storedReloadingTime = 0L;
                props.state = GunState.READY_TO_SHOOT;
            }
            NBTUtils.saveGunProps(stack, props.toNBT());
            if (!player.field_70170_p.field_72995_K) {
                Dispatcher.sendTo(new PacketGunInfo(props.toNBT(), player.func_145782_y()), (EntityPlayerMP)player);
                Dispatcher.sendToTracked((Entity)player, new PacketGunInfo(props.toNBT(), player.func_145782_y()));
            }
        }
    }

    public void decreaseDurability(GunProps props, ItemStack stack, EntityPlayer player) {
        if (props == null) {
            return;
        }
        if (props.durability != 0) {
            int val = props.storedDurability - 1;
            if (val <= 0) {
                if (!props.destroyCommand.isEmpty()) {
                    player.func_184102_h().field_71321_q.func_71556_a((ICommandSender)player, props.destroyCommand);
                }
                player.func_184614_ca().func_190920_e(0);
            }
            props.storedDurability = val;
            if (NBTUtils.saveGunProps(stack, props.toNBT())) {
                PacketGunInfo packet = new PacketGunInfo(props.toNBT(), player.func_145782_y());
                this.synchronize((EntityPlayerMP)player, props.toNBT());
                Dispatcher.sendTo(packet, (EntityPlayerMP)player);
                Dispatcher.sendToTracked((Entity)player, packet);
            }
        }
    }

    private void synchronize(EntityPlayerMP player, NBTTagCompound tag) {
        if (!OpHelper.isPlayerOp((EntityPlayerMP)player)) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (NBTUtils.saveGunProps(stack, tag)) {
            PacketGunInfo packet = new PacketGunInfo(tag, player.func_145782_y());
            Dispatcher.sendTo(packet, player);
            Dispatcher.sendToTracked((Entity)player, packet);
        }
    }

    public boolean onLeftClickEntity(ItemStack p_onLeftClickEntity_1_, EntityPlayer p_onLeftClickEntity_2_, Entity p_onLeftClickEntity_3_) {
        return false;
    }

    public void shootIt(ItemStack stack, EntityPlayer player, World world) {
        this.resetTime(stack, player);
        GunProps props = NBTUtils.getGunProps(stack);
        if (world.field_72995_K && props != null) {
            if (props.staticRecoil) {
                player.field_70125_A += Interpolation.QUINT_IN.interpolate(player.field_70127_C, player.field_70127_C + props.recoilXMin, 1.0f) - player.field_70127_C;
                player.field_70177_z += Interpolation.QUINT_IN.interpolate(player.field_70126_B, player.field_70126_B + props.recoilYMin, 1.0f) - player.field_70126_B;
            } else {
                player.field_70125_A += Interpolation.SINE_IN.interpolate(player.field_70127_C, player.field_70127_C + ItemGun.getRandom(props.recoilXMin, props.recoilXMax), 1.0f) - player.field_70127_C;
                player.field_70177_z += Interpolation.SINE_IN.interpolate(player.field_70126_B, player.field_70126_B + ItemGun.getRandom(props.recoilYMin, props.recoilYMax), 1.0f) - player.field_70126_B;
            }
            if (props.launch) {
                float pitch = player.field_70125_A + (float)((Math.random() - 0.5) * (double)props.scatterY);
                float yaw = player.field_70177_z + (float)((Math.random() - 0.5) * (double)props.scatterX);
                this.setThrowableHeading((EntityLivingBase)player, pitch, yaw, 0.0f, props.speed);
            }
        }
        this.shoot(stack, props, player, world);
    }

    public boolean shoot(ItemStack stack, GunProps props, EntityPlayer player, World world) {
        if (props == null) {
            return false;
        }
        if (props.launch) {
            float pitch = player.field_70125_A + (float)((Math.random() - 0.5) * (double)props.scatterY);
            float yaw = player.field_70177_z + (float)((Math.random() - 0.5) * (double)props.scatterX);
            this.setThrowableHeading((EntityLivingBase)player, pitch, yaw, 0.0f, props.speed);
            if (!props.fireCommand.isEmpty()) {
                player.func_184102_h().field_71321_q.func_71556_a((ICommandSender)player, props.fireCommand);
            }
        } else {
            if (!this.consumeInnerAmmo(stack, player)) {
                return false;
            }
            EntityGunProjectile last = null;
            for (int i = 0; i < Math.max(props.projectiles, 1); ++i) {
                AbstractMorph morph = props.projectileMorph;
                if (props.sequencer && morph instanceof SequencerMorph) {
                    SequencerMorph seq = (SequencerMorph)morph;
                    morph = props.random ? seq.getRandom() : seq.get(i % seq.morphs.size());
                }
                morph = MorphUtils.copy((AbstractMorph)morph);
                EntityGunProjectile projectile = new EntityGunProjectile(world, props, morph);
                float pitch = player.field_70125_A + (float)((Math.random() - 0.5) * (double)props.scatterY);
                float yaw = player.field_70177_z + (float)((Math.random() - 0.5) * (double)props.scatterX);
                double x = player.field_70165_t;
                double y = player.field_70163_u + (double)player.func_70047_e();
                double z = player.field_70161_v;
                Vector3f offset = new Vector3f(props.shootingOffsetX, props.shootingOffsetY, props.shootingOffsetZ);
                Vector3f vector = this.rotate(offset, player.field_70177_z, player.field_70125_A);
                projectile.func_70107_b(x += (double)vector.x, y += (double)vector.y, z += (double)vector.z);
                projectile.func_184538_a((Entity)player, pitch, yaw, 0.0f, props.speed, 0.0f);
                projectile.setInitialMotion();
                if (props.projectiles > 0 && !world.field_72995_K) {
                    world.func_72838_d((Entity)projectile);
                }
                last = projectile;
            }
            if (!props.fireCommand.isEmpty()) {
                player.func_184102_h().field_71321_q.func_71556_a(last, props.fireCommand);
            }
        }
        if (!world.field_72995_K) {
            EntityPlayer entity = player instanceof EntityActor.EntityFakePlayer ? ((EntityActor.EntityFakePlayer)player).actor : player;
            int id = entity.func_145782_y();
            if (player instanceof EntityPlayerMP) {
                Dispatcher.sendTo(new PacketGunShot(id), (EntityPlayerMP)player);
            }
            Dispatcher.sendToTracked((Entity)entity, new PacketGunShot(id));
            List<Action> events = CommonProxy.manager.getActions(player);
            if (events != null) {
                events.add(new ShootGunAction(stack));
            }
            this.decreaseDurability(NBTUtils.getGunProps(stack), stack, player);
            if (player instanceof EntityPlayerMP) {
                GunProps p = NBTUtils.getGunProps(stack);
                NBTUtils.saveGunProps(stack, p.toNBT());
                Dispatcher.sendTo(new PacketGunInfo(p.toNBT(), entity.func_145782_y()), (EntityPlayerMP)player);
                Dispatcher.sendToTracked((Entity)player, new PacketGunInfo(p.toNBT(), entity.func_145782_y()));
            }
        }
        return true;
    }

    private Vector3f rotate(Vector3f vector, float yaw, float pitch) {
        Matrix3f a = new Matrix3f();
        Matrix3f b = new Matrix3f();
        a.rotY((180.0f - yaw) / 180.0f * (float)Math.PI);
        b.rotX(-pitch / 180.0f * (float)Math.PI);
        a.mul(b);
        a.transform((Tuple3f)vector);
        return vector;
    }

    public static void checkGunState(ItemStack stack, EntityPlayer player) {
        GunProps props = NBTUtils.getGunProps(stack);
        if (props == null) {
            return;
        }
        if (props.storedAmmo <= 0 && props.useReloading && props.state == GunState.READY_TO_SHOOT) {
            props.state = GunState.NEED_TO_BE_RELOAD;
        }
        if (props.ammoStack.func_190926_b()) {
            return;
        }
        NBTUtils.saveGunProps(player.func_184614_ca(), props.toNBT());
        if (!player.field_70170_p.field_72995_K) {
            Dispatcher.sendTo(new PacketGunInfo(props.toNBT(), player.func_145782_y()), (EntityPlayerMP)player);
            Dispatcher.sendToTracked((Entity)player, new PacketGunInfo(props.toNBT(), player.func_145782_y()));
        }
    }

    public static void checkGunReload(ItemStack stack, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            GunProps props = NBTUtils.getGunProps(stack);
            if (props.state == GunState.NEED_TO_BE_RELOAD && props.storedShotDelay == 0L) {
                ItemGun gun = (ItemGun)stack.func_77973_b();
                gun.reload(player, stack);
            }
        }
    }

    private boolean consumeInnerAmmo(ItemStack stack, EntityPlayer player) {
        GunProps props = NBTUtils.getGunProps(stack);
        if (props == null) {
            return false;
        }
        int ammo = props.storedAmmo;
        if (ammo <= 0) {
            if (props.useReloading) {
                return false;
            }
            props.storedAmmo = props.ammo;
            NBTUtils.saveGunProps(player.func_184614_ca(), props.toNBT());
            if (!player.field_71075_bZ.field_75098_d && !props.ammoStack.func_190926_b()) {
                return this.consumeAmmoStack(player, props.ammoStack, props.ammoStack.func_190916_E()) >= 0;
            }
            return true;
        }
        this.consumeAmmo(stack, player);
        return true;
    }

    private void consumeAmmo(ItemStack stack, EntityPlayer player) {
        GunProps props = NBTUtils.getGunProps(stack);
        if (props == null) {
            return;
        }
        --props.storedAmmo;
        NBTUtils.saveGunProps(player.func_184614_ca(), props.toNBT());
    }

    public int consumeAmmoStack(EntityPlayer player, ItemStack ammo, int count) {
        return player.field_71071_by.func_174925_a(ammo.func_77973_b(), -1, count, ammo.func_77978_p());
    }

    private void setThrowableHeading(EntityLivingBase entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity) {
        float f = -MathHelper.func_76126_a((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.setThrowableHeading(entityThrower, (double)f, (double)f1, (double)f2, velocity);
    }

    public void setThrowableHeading(EntityLivingBase entity, double x, double y, double z, float velocity) {
        float distance = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        entity.field_70159_w = x / (double)distance * (double)velocity;
        entity.field_70181_x = y / (double)distance * (double)velocity;
        entity.field_70179_y = z / (double)distance * (double)velocity;
    }

    public void reload(EntityPlayer player, ItemStack stack) {
        GunProps props = NBTUtils.getGunProps(stack);
        if (props == null) {
            return;
        }
        int count = 0;
        if (!player.field_71075_bZ.field_75098_d && !props.ammoStack.func_190926_b()) {
            ItemStack ammo = props.ammoStack;
            count = this.consumeAmmoStack(player, ammo, props.ammo - props.storedAmmo);
        } else {
            count = props.ammo - props.storedAmmo;
        }
        if (count > 0) {
            props.state = GunState.RELOADING;
            props.storedAmmo += count;
            props.storedReloadingTime = props.reloadingTime;
            if (!props.reloadCommand.isEmpty()) {
                player.func_184102_h().field_71321_q.func_71556_a((ICommandSender)player, props.reloadCommand);
            }
            NBTUtils.saveGunProps(stack, props.toNBT());
            Dispatcher.sendTo(new PacketGunInfo(props.toNBT(), player.func_145782_y()), (EntityPlayerMP)player);
            Dispatcher.sendToTracked((Entity)player, new PacketGunInfo(props.toNBT(), player.func_145782_y()));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        GunProps props = NBTUtils.getGunProps(stack);
        if (props != null) {
            return props.state == GunState.RELOADING || props.ammo > 1 || props.durability > 0;
        }
        return super.showDurabilityBar(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        GunProps props = NBTUtils.getGunProps(stack);
        if (props != null) {
            if (props.state != GunState.READY_TO_SHOOT) {
                if (props.state == GunState.RELOADING && props.reloadingTime > 0L) {
                    return (double)props.storedReloadingTime / (double)props.reloadingTime;
                }
                return 1.0;
            }
            if (props.ammo > 1) {
                return 1.0 - (double)props.storedAmmo / (double)props.ammo;
            }
            if (props.durability > 0) {
                return 1.0 - (double)props.storedDurability / (double)props.durability;
            }
        }
        return super.getDurabilityForDisplay(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        GunProps props = NBTUtils.getGunProps(stack);
        if (props != null) {
            if (props.state != GunState.READY_TO_SHOOT) {
                return -65536;
            }
            if (props.ammo > 1) {
                return -13647617;
            }
        }
        return super.getRGBDurabilityForDisplay(stack);
    }

    public static enum GunState {
        READY_TO_SHOOT,
        RELOADING,
        NEED_TO_BE_RELOAD;

    }
}

