/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.common.entity;

import com.google.common.collect.Queues;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Queue;
import javax.annotation.Nullable;
import javax.vecmath.Vector3d;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.ClientProxy;
import mchorse.blockbuster.client.render.IRenderLast;
import mchorse.blockbuster.common.item.ItemActorConfig;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.PacketModifyActor;
import mchorse.blockbuster.network.common.recording.PacketRequestFrames;
import mchorse.blockbuster.network.common.recording.PacketSyncTick;
import mchorse.blockbuster.network.common.recording.actions.PacketRequestAction;
import mchorse.blockbuster.recording.RecordPlayer;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.recording.data.Mode;
import mchorse.blockbuster.recording.data.Record;
import mchorse.blockbuster.recording.scene.Replay;
import mchorse.mclib.utils.Interpolations;
import mchorse.metamorph.api.Morph;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.models.IMorphProvider;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityActor
extends EntityCreature
implements IEntityAdditionalSpawnData,
IMorphProvider,
IRenderLast {
    public boolean invisible = false;
    public EntityFakePlayer fakePlayer;
    public RecordPlayer playback;
    public Morph morph = new Morph();
    public float rotateElytraX = 0.0f;
    public float rotateElytraY = 0.0f;
    public float rotateElytraZ = 0.0f;
    public boolean isMounted;
    public boolean wasAttached;
    public boolean manual = false;
    public int pauseOffset = -1;
    public AbstractMorph pausePreviousMorph;
    public int pausePreviousOffset = -1;
    public boolean forceMorph = false;
    public float prevRoll;
    public float roll;
    public boolean renderLast;
    public boolean enableBurning;
    public Queue<PacketModifyActor> modify = Queues.newArrayDeque();

    public EntityActor(World worldIn) {
        super(worldIn);
        this.fakePlayer = new EntityFakePlayer(worldIn, this, new GameProfile(null, "xXx_Fake_Player_420_xXx"));
        this.fakePlayer.field_71075_bZ.field_75098_d = true;
    }

    public AbstractMorph getMorph() {
        return this.morph.get();
    }

    @Override
    public Vector3d getRenderLastPos() {
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        return new Vector3d(Interpolations.lerp((double)this.field_70169_q, (double)this.field_70165_t, (double)partialTicks), Interpolations.lerp((double)this.field_70167_r, (double)this.field_70163_u, (double)partialTicks), Interpolations.lerp((double)this.field_70166_s, (double)this.field_70161_v, (double)partialTicks));
    }

    public boolean func_70027_ad() {
        return this.enableBurning && super.func_70027_ad();
    }

    public boolean isPlaying() {
        return this.playback != null && this.playback.playing && !this.playback.isFinished();
    }

    public double func_70033_W() {
        return -0.35;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return true;
    }

    public boolean func_82171_bF() {
        return false;
    }

    public boolean func_184186_bw() {
        return false;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Name", "blockbuster.steve");
        this.morph.fromNBT(tag);
        return super.func_180482_a(difficulty, livingdata);
    }

    public void func_70030_z() {
        Frame frame;
        boolean spawn = this.field_70170_p.field_72995_K && this.field_70173_aa < 2;
        Record record = this.playback == null ? null : this.playback.record;
        if (spawn &= record != null && record.getFrame(0) != null) {
            this.playback.applyFrame(this.playback.tick - 1, (EntityLivingBase)this, true);
            frame = record.getFrameSafe(this.playback.tick - record.preDelay - 1);
            if (frame.hasBodyYaw) {
                this.field_70761_aq = frame.bodyYaw;
            }
        }
        super.func_70030_z();
        if (spawn && this.playback.playing) {
            this.playback.applyFrame(this.playback.tick, (EntityLivingBase)this, true);
            frame = record.getFrameSafe(this.playback.tick - record.preDelay);
            if (frame.hasBodyYaw) {
                this.field_70761_aq = frame.bodyYaw;
            }
        }
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.playback != null && this.playback.playing && !this.manual) {
            int tick = this.playback.tick;
            if (this.playback.isFinished() && !this.field_70145_X) {
                this.playback.stopPlaying();
            } else if (tick != 0 && tick % (Integer)Blockbuster.recordSyncRate.get() == 0) {
                Dispatcher.sendToTracked((Entity)this, new PacketSyncTick(this.func_145782_y(), tick));
            }
        }
        if (this.field_70145_X && !this.field_70170_p.field_72995_K) {
            if (this.playback != null) {
                this.playback.next();
            }
            return;
        }
        this.pickUpNearByItems();
        if (this.playback != null) {
            if (this.manual) {
                this.playback.applyFrame(this.playback.tick, (EntityLivingBase)this, true);
                this.playback.applyAction(this.playback.tick, (EntityLivingBase)this, true);
                ++this.playback.tick;
            } else {
                this.playback.next();
            }
        }
        if (this.field_70170_p.field_72995_K && this.field_70716_bi > 0) {
            double d0 = this.field_70165_t + (this.field_184623_bh - this.field_70165_t) / (double)this.field_70716_bi;
            double d1 = this.field_70163_u + (this.field_184624_bi - this.field_70163_u) / (double)this.field_70716_bi;
            double d2 = this.field_70161_v + (this.field_184625_bj - this.field_70161_v) / (double)this.field_70716_bi;
            --this.field_70716_bi;
            this.func_70107_b(d0, d1, d2);
        } else if (!this.func_70613_aW()) {
            this.field_70159_w *= 0.98;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.98;
        }
        if (Math.abs(this.field_70159_w) < 0.005) {
            this.field_70159_w = 0.0;
        }
        if (Math.abs(this.field_70181_x) < 0.005) {
            this.field_70181_x = 0.0;
        }
        if (Math.abs(this.field_70179_y) < 0.005) {
            this.field_70179_y = 0.0;
        }
        this.func_82168_bl();
        if (!this.field_70170_p.field_72995_K && this.isPlaying() && this.playback.tick < this.playback.record.frames.size() - 1 && !this.func_70093_af() && this.field_70122_E) {
            Frame current = this.playback.record.frames.get(this.playback.tick);
            Frame next = this.playback.record.frames.get(this.playback.tick + 1);
            double dx = next.x - current.x;
            double dy = next.y - current.y;
            double dz = next.z - current.z;
            this.field_70140_Q += MathHelper.func_76133_a((double)(dx * dx + dz * dz)) * 0.32f;
            this.field_82151_R += MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz)) * 0.32f;
        }
        if (this.playback != null) {
            double posX = this.field_70165_t;
            double posY = this.field_70163_u;
            double posZ = this.field_70161_v;
            double prevPosX = this.field_70169_q;
            double prevPosY = this.field_70167_r;
            double prevPosZ = this.field_70166_s;
            this.func_191986_a(this.field_70702_br, this.field_70701_bs, this.field_191988_bg);
            this.field_70165_t = posX;
            this.field_70163_u = posY;
            this.field_70161_v = posZ;
            this.field_70169_q = prevPosX;
            this.field_70167_r = prevPosY;
            this.field_70166_s = prevPosZ;
        } else {
            this.func_191986_a(this.field_70702_br, this.field_70701_bs, this.field_191988_bg);
        }
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        int tick;
        if (!this.field_70170_p.field_72995_K && ((Boolean)Blockbuster.actorFallDamage.get()).booleanValue() && this.playback != null && (tick = this.playback.getTick()) >= 1 && tick < this.playback.record.frames.size()) {
            this.field_70122_E = onGroundIn = this.playback.record.frames.get((int)(tick - 1)).onGround;
        }
        super.func_184231_a(y, onGroundIn, state, pos);
    }

    private void pickUpNearByItems() {
        if (!this.field_70170_p.field_72995_K && !this.field_70729_aU) {
            for (EntityItem entityitem : this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_72321_a(1.0, 0.0, 1.0))) {
                if (entityitem.field_70128_L || entityitem.func_92059_d() == null || entityitem.func_174874_s()) continue;
                this.func_71001_a((Entity)entityitem, 1);
                entityitem.func_70106_y();
            }
        }
    }

    protected float func_110146_f(float renderYawOffset, float distance) {
        AbstractMorph morph;
        boolean shouldAutoAlign = true;
        if (((Boolean)Blockbuster.actorPlaybackBodyYaw.get()).booleanValue() && this.playback != null && this.playback.record != null) {
            Frame previous = this.playback.record.getFrame(this.playback.getTick() - 1);
            Frame frame = this.playback.getCurrentFrame();
            if (frame != null && frame.hasBodyYaw) {
                this.field_70761_aq = frame.bodyYaw;
                this.field_70760_ar = previous == null || !this.playback.playing ? frame.bodyYaw : previous.bodyYaw;
                shouldAutoAlign = false;
            }
        }
        if (shouldAutoAlign) {
            boolean isBackwards;
            float tempRenderYawOffset = MathHelper.func_76142_g((float)(renderYawOffset - this.field_70761_aq));
            this.field_70761_aq += tempRenderYawOffset * 0.3f;
            tempRenderYawOffset = MathHelper.func_76142_g((float)(this.field_70177_z - this.field_70761_aq));
            boolean bl = isBackwards = tempRenderYawOffset < -90.0f || tempRenderYawOffset >= 90.0f;
            if (tempRenderYawOffset < -75.0f) {
                tempRenderYawOffset = -75.0f;
            }
            if (tempRenderYawOffset >= 75.0f) {
                tempRenderYawOffset = 75.0f;
            }
            this.field_70761_aq = this.field_70177_z - tempRenderYawOffset;
            if (tempRenderYawOffset * tempRenderYawOffset > 2500.0f) {
                this.field_70761_aq += tempRenderYawOffset * 0.2f;
            }
            if (isBackwards) {
                distance *= -1.0f;
            }
        }
        if ((morph = this.morph.get()) != null) {
            morph.update((EntityLivingBase)this);
        }
        while (!this.modify.isEmpty()) {
            this.applyModifyPacket(this.modify.poll());
        }
        return distance;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        boolean empty = item.func_190926_b();
        if (empty) {
            if (!(this.field_70170_p.field_72995_K || ((Boolean)Blockbuster.actorDisableRiding.get()).booleanValue() || player.func_70093_af())) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        if (item.func_77973_b() instanceof ItemActorConfig) {
            player.openGui((Object)Blockbuster.instance, 1, player.field_70170_p, this.func_145782_y(), 0, 0);
            return true;
        }
        return false;
    }

    public void applyModifyPacket(PacketModifyActor message) {
        this.forceMorph = message.forceMorph;
        if (message.offset >= 0) {
            this.invisible = message.invisible;
            this.applyPause(message.morph, message.offset, message.previous, message.previousOffset, this.forceMorph);
            if (this.forceMorph) {
                this.pauseOffset = -1;
                this.pausePreviousMorph = null;
                this.pausePreviousOffset = -1;
                this.forceMorph = false;
            }
        } else {
            this.modify(message.morph, message.invisible, false);
        }
    }

    public void modify(AbstractMorph morph, boolean invisible, boolean notify) {
        if (this.forceMorph) {
            this.morph.setDirect(morph);
        } else {
            this.morph.set(morph);
        }
        this.invisible = invisible;
        if (!this.field_70170_p.field_72995_K && notify) {
            this.notifyPlayers();
        }
    }

    public void morph(AbstractMorph morph, boolean force) {
        this.pauseOffset = -1;
        this.pausePreviousMorph = null;
        this.pausePreviousOffset = -1;
        this.forceMorph = force;
        this.morph.set(morph);
    }

    public void morphPause(AbstractMorph morph, int offset, AbstractMorph previous, int previousOffset, boolean resume) {
        this.pauseOffset = offset;
        this.pausePreviousMorph = previous;
        this.pausePreviousOffset = previousOffset;
        this.forceMorph = resume;
        this.morph.setDirect(morph);
    }

    public void applyPause(AbstractMorph morph, int offset, AbstractMorph previous, int previousOffset, boolean resume) {
        this.morphPause(morph, offset, previous, previousOffset, resume);
        MorphUtils.pause((AbstractMorph)previous, null, (int)previousOffset);
        MorphUtils.pause((AbstractMorph)morph, (AbstractMorph)previous, (int)offset);
        if (resume) {
            MorphUtils.resume((AbstractMorph)morph);
        }
    }

    public void notifyPlayers() {
        if (!this.manual && this.playback != null) {
            this.playback.sendToTracked(new PacketModifyActor(this));
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.morph.setDirect(MorphManager.INSTANCE.morphFromNBT(tag.func_74775_l("Morph")));
        this.invisible = tag.func_74767_n("Invisible");
        this.enableBurning = tag.func_74767_n("EnableBurning");
        this.wasAttached = tag.func_74767_n("WasAttached");
        if (!this.field_70170_p.field_72995_K) {
            this.notifyPlayers();
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        if (!this.morph.isEmpty()) {
            tag.func_74782_a("Morph", (NBTBase)this.morph.get().toNBT());
        }
        tag.func_74757_a("Invisible", this.invisible);
        tag.func_74757_a("EnableBurning", this.enableBurning);
        tag.func_74757_a("WasAttached", this.wasAttached);
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (this.wasAttached && this.playback == null) {
            this.func_70106_y();
        }
        MorphUtils.morphToBuf((ByteBuf)buffer, (AbstractMorph)this.morph.get());
        buffer.writeBoolean(this.invisible);
        buffer.writeBoolean(this.enableBurning);
        buffer.writeBoolean(this.field_70145_X);
        buffer.writeBoolean(this.playback != null);
        if (this.playback != null) {
            buffer.writeBoolean(this.playback.playing);
            buffer.writeInt(this.playback.tick);
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.playback.record.filename);
            buffer.writeBoolean(this.playback.getReplay() != null && this.playback.getReplay().morph != null);
            if (this.playback.getReplay() != null && this.playback.getReplay().morph != null) {
                MorphUtils.morphToBuf((ByteBuf)buffer, (AbstractMorph)this.playback.getReplay().morph);
            }
        }
        buffer.writeBoolean(this.func_180431_b(DamageSource.field_82728_o));
        buffer.writeBoolean(this.renderLast);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.morph.setDirect(MorphUtils.morphFromBuf((ByteBuf)buffer));
        this.invisible = buffer.readBoolean();
        this.enableBurning = buffer.readBoolean();
        this.field_70145_X = buffer.readBoolean();
        if (buffer.readBoolean()) {
            boolean playing = buffer.readBoolean();
            int tick = buffer.readInt();
            String filename = ByteBufUtils.readUTF8String((ByteBuf)buffer);
            Replay replay = null;
            if (buffer.readBoolean()) {
                replay = new Replay();
                replay.morph = MorphUtils.morphFromBuf((ByteBuf)buffer);
            }
            if (this.playback == null) {
                Record record = ClientProxy.manager.getClient(filename);
                if (record != null) {
                    this.playback = new RecordPlayer(record, Mode.FRAMES, (EntityLivingBase)this);
                    record.applyPreviousMorph((EntityLivingBase)this, replay, tick - record.preDelay, playing ? Record.MorphType.FORCE : Record.MorphType.PAUSE);
                } else {
                    this.playback = new RecordPlayer(null, Mode.FRAMES, (EntityLivingBase)this);
                    Dispatcher.sendToServer(new PacketRequestAction(filename, false));
                    Dispatcher.sendToServer(new PacketRequestFrames(this.func_145782_y(), filename));
                }
            }
            if (this.playback != null) {
                this.playback.tick = tick;
                this.playback.playing = playing;
            }
        }
        this.func_184224_h(buffer.readBoolean());
        this.renderLast = buffer.readBoolean();
    }

    public boolean func_184652_a(EntityPlayer player) {
        return !this.func_110167_bD();
    }

    public void setItemStackInUse(int activeCount) {
        this.field_184628_bn = activeCount;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 *= (double)((Integer)Blockbuster.actorRenderingRange.get()).intValue()) * d0;
    }

    public static class EntityFakePlayer
    extends EntityPlayer {
        public EntityActor actor;

        public EntityFakePlayer(World world, EntityActor actor, GameProfile profile) {
            super(world, profile);
            this.actor = actor;
        }

        public boolean func_175149_v() {
            return false;
        }

        public boolean func_184812_l_() {
            return false;
        }

        public void func_70071_h_() {
            if (this.actor.field_70128_L) {
                this.func_70106_y();
                return;
            }
            this.field_70130_N = this.actor.field_70130_N;
            this.field_70131_O = this.actor.field_70131_O;
            this.eyeHeight = this.actor.func_70047_e();
            this.func_174826_a(this.actor.func_174813_aQ());
            if (this.actor.func_184187_bx() != this) {
                this.field_70165_t = this.actor.field_70165_t;
                this.field_70163_u = this.actor.field_70163_u;
                this.field_70161_v = this.actor.field_70161_v;
            }
            this.field_70177_z = this.actor.field_70177_z;
            this.field_70125_A = this.actor.field_70125_A;
            if (!Objects.equals(this.func_184582_a(EntityEquipmentSlot.MAINHAND), this.actor.func_184614_ca())) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, this.actor.func_184614_ca());
            }
            if (!Objects.equals(this.func_184582_a(EntityEquipmentSlot.OFFHAND), this.actor.func_184592_cb())) {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, this.actor.func_184592_cb());
            }
        }

        public void func_71007_a(IInventory chestInventory) {
            if (this.field_71070_bA != this.field_71069_bz) {
                this.func_71053_j();
            }
            this.field_71070_bA = chestInventory instanceof IInteractionObject ? ((IInteractionObject)chestInventory).func_174876_a(this.field_71071_by, (EntityPlayer)this) : new ContainerChest((IInventory)this.field_71071_by, chestInventory, (EntityPlayer)this);
        }

        public void func_71053_j() {
            this.field_71070_bA.func_75134_a((EntityPlayer)this);
            super.func_71053_j();
        }

        public void func_70020_e(NBTTagCompound compound) {
            this.func_70106_y();
        }

        public NBTTagCompound func_189511_e(NBTTagCompound compound) {
            return compound;
        }
    }
}

