/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.common;

import mchorse.blockbuster.api.ModelTransform;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster.common.entity.EntityGunProjectile;
import mchorse.blockbuster.common.item.ItemGun;
import mchorse.metamorph.api.Morph;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class GunProps {
    public AbstractMorph defaultMorph;
    public AbstractMorph firingMorph;
    public String fireCommand;
    public int delay;
    public int projectiles;
    public float scatterX;
    public float scatterY;
    public boolean launch;
    public boolean useTarget;
    public ItemStack ammoStack = ItemStack.field_190927_a;
    public boolean staticRecoil;
    public float recoilXMin;
    public float recoilXMax;
    public float recoilYMin;
    public float recoilYMax;
    public boolean enableArmsShootingPose;
    public boolean alwaysArmsShootingPose;
    public float shootingOffsetX;
    public float shootingOffsetY;
    public float shootingOffsetZ;
    public AbstractMorph inventoryMorph;
    public AbstractMorph crosshairMorph;
    public AbstractMorph handsMorph;
    public AbstractMorph reloadMorph;
    public AbstractMorph zoomOverlayMorph;
    public boolean hideCrosshairOnZoom;
    public boolean useInventoryMorph;
    public boolean hideHandsOnZoom;
    public boolean useZoomOverlayMorph;
    public float zoomFactor;
    public int ammo;
    public boolean useReloading;
    public long reloadingTime;
    public long shotDelay;
    public boolean shootWhenHeld;
    public String destroyCommand;
    public String meleeCommand;
    public String reloadCommand;
    public String zoomOnCommand;
    public String zoomOffCommand;
    public float meleeDamage;
    public float mouseZoom;
    public int durability;
    public boolean preventLeftClick;
    public boolean preventRightClick;
    public boolean preventEntityAttack;
    public int storedAmmo;
    public long storedReloadingTime;
    public long storedShotDelay;
    public int storedDurability;
    public ItemGun.GunState state = ItemGun.GunState.READY_TO_SHOOT;
    public AbstractMorph projectileMorph;
    public String tickCommand;
    public int ticking;
    public int lifeSpan;
    public boolean yaw;
    public boolean pitch;
    public boolean sequencer;
    public boolean random;
    public float hitboxX;
    public float hitboxY;
    public float speed;
    public float friction;
    public float gravity;
    public int fadeIn;
    public int fadeOut;
    public AbstractMorph impactMorph;
    public String impactCommand;
    public String impactEntityCommand;
    public int impactDelay;
    public boolean vanish;
    public boolean bounce;
    public boolean sticks;
    public int hits;
    public float damage;
    public float knockbackHorizontal;
    public float knockbackVertical;
    public float bounceFactor;
    public String vanishCommand;
    public int vanishDelay;
    public float penetration;
    public boolean ignoreBlocks;
    public boolean ignoreEntities;
    public ModelTransform gunTransform = new ModelTransform();
    public ModelTransform gunTransformFirstPerson = new ModelTransform();
    public ModelTransform projectileTransform = new ModelTransform();
    private int shoot = 0;
    private Morph current = new Morph();
    private Morph currentHands = new Morph();
    private Morph currentInventory = new Morph();
    private Morph currentZoomOverlay = new Morph();
    public Morph currentCrosshair = new Morph();
    private boolean renderLock;
    public EntityLivingBase target;
    public ItemGun.GunState lastState = ItemGun.GunState.READY_TO_SHOOT;

    public GunProps() {
        this.reset();
    }

    public GunProps(NBTTagCompound tag) {
        this.fromNBT(tag);
    }

    public void setCurrent(AbstractMorph morph) {
        this.current.setDirect(morph);
    }

    public void setCurrentZoomOverlay(AbstractMorph morph) {
        this.currentZoomOverlay.setDirect(morph);
    }

    public void setHandsMorph(AbstractMorph morph) {
        this.currentHands.setDirect(morph);
    }

    public void setCrosshairMorph(AbstractMorph morph) {
        this.currentCrosshair.setDirect(morph);
    }

    public void setInventoryMorph(AbstractMorph morph) {
        this.currentInventory.setDirect(morph);
    }

    public void shot() {
        if (this.delay <= 0) {
            return;
        }
        this.shoot = this.delay;
        this.current.set(MorphUtils.copy((AbstractMorph)this.firingMorph));
    }

    @SideOnly(value=Side.CLIENT)
    public void createEntity() {
        this.createEntity((World)Minecraft.func_71410_x().field_71441_e);
    }

    public void createEntity(World world) {
        if (this.target != null) {
            return;
        }
        this.target = new EntityActor(world);
        this.target.field_70122_E = true;
        this.target.field_70126_B = 0.0f;
        this.target.field_70177_z = 0.0f;
        this.target.field_70758_at = 0.0f;
        this.target.field_70759_as = 0.0f;
        this.target.field_70127_C = 0.0f;
        this.target.field_70125_A = 0.0f;
    }

    public EntityLivingBase getEntity(EntityGunProjectile entity) {
        if (this.target != null) {
            this.target.field_70169_q = entity.field_70169_q;
            this.target.field_70167_r = entity.field_70167_r;
            this.target.field_70166_s = entity.field_70166_s;
            this.target.field_70165_t = entity.field_70165_t;
            this.target.field_70163_u = entity.field_70163_u;
            this.target.field_70161_v = entity.field_70161_v;
        }
        return this.target;
    }

    @SideOnly(value=Side.CLIENT)
    public void update() {
        if (this.target != null) {
            boolean currentReload;
            ++this.target.field_70173_aa;
            boolean lastReload = this.lastState == ItemGun.GunState.RELOADING;
            boolean bl = currentReload = this.state == ItemGun.GunState.RELOADING;
            if (currentReload != lastReload) {
                if (currentReload) {
                    this.current.set(this.reloadMorph);
                } else {
                    this.current.set(this.defaultMorph);
                }
            }
            this.lastState = this.state;
            AbstractMorph morph = this.current.get();
            if (morph != null) {
                morph.update(this.target);
            }
            if (!this.currentCrosshair.isEmpty()) {
                this.currentCrosshair.get().update(this.target);
            }
            if (!this.currentHands.isEmpty()) {
                this.currentHands.get().update(this.target);
            }
            if (!this.currentInventory.isEmpty()) {
                this.currentInventory.get().update(this.target);
            }
            if (!this.currentZoomOverlay.isEmpty()) {
                this.currentZoomOverlay.get().update(this.target);
            }
        }
        if (this.shoot > 0) {
            --this.shoot;
            if (this.shoot == 0) {
                this.current.set(MorphUtils.copy((AbstractMorph)this.defaultMorph));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderZoomOverlay(EntityLivingBase lastItemHolder, float partialTicks) {
        if (this.renderLock) {
            return;
        }
        this.renderLock = true;
        if (this.target == null) {
            this.createEntity();
        }
        EntityLivingBase entity = this.useTarget ? this.target : this.target;
        AbstractMorph morph = this.currentZoomOverlay.get();
        if (morph != null && entity != null) {
            float rotationYaw = entity.field_70761_aq;
            float prevRotationYaw = entity.field_70760_ar;
            float rotationYawHead = entity.field_70759_as;
            float prevRotationYawHead = entity.field_70758_at;
            entity.field_70759_as -= entity.field_70761_aq;
            entity.field_70758_at -= entity.field_70760_ar;
            entity.field_70760_ar = 0.0f;
            entity.field_70761_aq = 0.0f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
            this.setupEntity();
            MorphUtils.render((AbstractMorph)morph, (EntityLivingBase)entity, (double)0.0, (double)0.0, (double)0.0, (float)0.0f, (float)partialTicks);
            GL11.glPopMatrix();
            entity.field_70761_aq = rotationYaw;
            entity.field_70760_ar = prevRotationYaw;
            entity.field_70759_as = rotationYawHead;
            entity.field_70758_at = prevRotationYawHead;
        }
        this.renderLock = false;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(EntityLivingBase target, float partialTicks, boolean firstPerson) {
        if (this.renderLock) {
            return;
        }
        this.renderLock = true;
        if (this.target == null) {
            this.createEntity();
        }
        EntityLivingBase entity = this.useTarget ? target : this.target;
        AbstractMorph morph = this.current.get();
        if (morph != null && entity != null) {
            float rotationYaw = entity.field_70761_aq;
            float prevRotationYaw = entity.field_70760_ar;
            float rotationYawHead = entity.field_70759_as;
            float prevRotationYawHead = entity.field_70758_at;
            entity.field_70759_as -= entity.field_70761_aq;
            entity.field_70758_at -= entity.field_70760_ar;
            entity.field_70760_ar = 0.0f;
            entity.field_70761_aq = 0.0f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
            (firstPerson ? this.gunTransformFirstPerson : this.gunTransform).transform();
            this.setupEntity();
            MorphUtils.render((AbstractMorph)morph, (EntityLivingBase)entity, (double)0.0, (double)0.0, (double)0.0, (float)0.0f, (float)partialTicks);
            GL11.glPopMatrix();
            entity.field_70761_aq = rotationYaw;
            entity.field_70760_ar = prevRotationYaw;
            entity.field_70759_as = rotationYawHead;
            entity.field_70758_at = prevRotationYawHead;
        }
        this.renderLock = false;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryMorph(EntityLivingBase target, float partialTicks) {
        if (this.renderLock) {
            return;
        }
        this.renderLock = true;
        if (this.target == null) {
            this.createEntity();
        }
        EntityLivingBase entity = this.useTarget ? target : this.target;
        AbstractMorph morph = this.currentInventory.get();
        if (morph != null && entity != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
            GlStateManager.func_179126_j();
            this.setupEntity();
            MorphUtils.render((AbstractMorph)morph, (EntityLivingBase)entity, (double)0.0, (double)0.0, (double)0.0, (float)0.0f, (float)partialTicks);
            GL11.glPopMatrix();
        }
        this.renderLock = false;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHands(EntityLivingBase target, float partialTicks, boolean firstPerson) {
        if (this.renderLock) {
            return;
        }
        this.renderLock = true;
        if (this.target == null) {
            this.createEntity();
        }
        EntityLivingBase entity = this.useTarget ? target : this.target;
        AbstractMorph morph = this.currentHands.get();
        if (morph != null && entity != null) {
            float rotationYaw = entity.field_70761_aq;
            float prevRotationYaw = entity.field_70760_ar;
            float rotationYawHead = entity.field_70759_as;
            float prevRotationYawHead = entity.field_70758_at;
            entity.field_70759_as -= entity.field_70761_aq;
            entity.field_70758_at -= entity.field_70760_ar;
            entity.field_70760_ar = 0.0f;
            entity.field_70761_aq = 0.0f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
            (firstPerson ? this.gunTransformFirstPerson : this.gunTransform).transform();
            this.setupEntity();
            MorphUtils.render((AbstractMorph)morph, (EntityLivingBase)entity, (double)0.0, (double)0.0, (double)0.0, (float)0.0f, (float)partialTicks);
            GL11.glPopMatrix();
            entity.field_70761_aq = rotationYaw;
            entity.field_70760_ar = prevRotationYaw;
            entity.field_70759_as = rotationYawHead;
            entity.field_70758_at = prevRotationYawHead;
        }
        this.renderLock = false;
    }

    @SideOnly(value=Side.CLIENT)
    private void setupEntity() {
        this.target.func_70080_a(0.0, 0.0, 0.0, 0.0f, 0.0f);
        this.target.func_70012_b(0.0, 0.0, 0.0, 0.0f, 0.0f);
        this.target.field_70758_at = 0.0f;
        this.target.field_70759_as = 0.0f;
        this.target.field_70126_B = 0.0f;
        this.target.field_70177_z = 0.0f;
        this.target.field_70127_C = 0.0f;
        this.target.field_70125_A = 0.0f;
        this.target.field_70760_ar = 0.0f;
        this.target.field_70761_aq = 0.0f;
        this.target.func_70016_h(0.0, 0.0, 0.0);
    }

    public void reset() {
        this.defaultMorph = null;
        this.handsMorph = null;
        this.inventoryMorph = null;
        this.reloadMorph = null;
        this.crosshairMorph = null;
        this.zoomOverlayMorph = null;
        this.firingMorph = null;
        this.fireCommand = "";
        this.delay = 0;
        this.projectiles = 1;
        this.storedAmmo = 1;
        this.reloadingTime = 0L;
        this.storedShotDelay = 0L;
        this.shotDelay = 0L;
        this.ammo = 1;
        this.storedReloadingTime = 0L;
        this.scatterY = 0.0f;
        this.scatterX = 0.0f;
        this.launch = false;
        this.useInventoryMorph = false;
        this.useTarget = false;
        this.ammoStack = ItemStack.field_190927_a;
        this.zoomFactor = 0.0f;
        this.recoilXMin = 0.0f;
        this.shootingOffsetX = 0.0f;
        this.mouseZoom = 0.5f;
        this.meleeDamage = 0.0f;
        this.shootingOffsetY = 0.0f;
        this.shootingOffsetZ = 0.0f;
        this.staticRecoil = true;
        this.recoilXMax = 0.0f;
        this.recoilYMin = 0.0f;
        this.recoilYMax = 0.0f;
        this.projectileMorph = null;
        this.tickCommand = "";
        this.zoomOffCommand = "";
        this.zoomOnCommand = "";
        this.reloadCommand = "";
        this.meleeCommand = "";
        this.destroyCommand = "";
        this.ticking = 0;
        this.durability = 0;
        this.storedDurability = 0;
        this.lifeSpan = 200;
        this.yaw = true;
        this.useZoomOverlayMorph = false;
        this.hideHandsOnZoom = false;
        this.hideCrosshairOnZoom = false;
        this.enableArmsShootingPose = false;
        this.preventRightClick = false;
        this.preventLeftClick = false;
        this.preventEntityAttack = false;
        this.shootWhenHeld = true;
        this.alwaysArmsShootingPose = false;
        this.pitch = true;
        this.sequencer = false;
        this.random = false;
        this.hitboxX = 0.25f;
        this.hitboxY = 0.25f;
        this.speed = 1.0f;
        this.friction = 0.99f;
        this.gravity = 0.03f;
        this.fadeOut = 10;
        this.fadeIn = 10;
        this.impactMorph = null;
        this.impactCommand = "";
        this.impactEntityCommand = "";
        this.impactDelay = 0;
        this.vanish = true;
        this.bounce = false;
        this.sticks = false;
        this.hits = 1;
        this.state = ItemGun.GunState.READY_TO_SHOOT;
        this.damage = 0.0f;
        this.knockbackHorizontal = 0.0f;
        this.knockbackVertical = 0.0f;
        this.bounceFactor = 1.0f;
        this.vanishCommand = "";
        this.vanishDelay = 0;
        this.penetration = 0.0f;
        this.ignoreBlocks = false;
        this.ignoreEntities = false;
        this.gunTransform = new ModelTransform();
        this.projectileTransform = new ModelTransform();
    }

    public void fromNBT(NBTTagCompound tag) {
        this.reset();
        this.defaultMorph = this.create(tag, "Morph");
        this.handsMorph = this.create(tag, "HandsMorph");
        this.inventoryMorph = this.create(tag, "InventoryMorph");
        this.reloadMorph = this.create(tag, "ReloadMorph");
        this.crosshairMorph = this.create(tag, "CrosshairMorph");
        this.zoomOverlayMorph = this.create(tag, "ZoomOverlayMorph");
        this.firingMorph = this.create(tag, "Fire");
        if (tag.func_74764_b("FireCommand")) {
            this.fireCommand = tag.func_74779_i("FireCommand");
        }
        if (tag.func_74764_b("Delay")) {
            this.delay = tag.func_74762_e("Delay");
        }
        if (tag.func_74764_b("Projectiles")) {
            this.projectiles = tag.func_74762_e("Projectiles");
        }
        if (tag.func_74764_b("StoredReloadingTime")) {
            this.storedReloadingTime = tag.func_74762_e("StoredReloadingTime");
        }
        if (tag.func_74764_b("Scatter")) {
            NBTBase scatter = tag.func_74781_a("Scatter");
            if (scatter instanceof NBTTagList) {
                NBTTagList list = (NBTTagList)scatter;
                if (list.func_74745_c() >= 2) {
                    this.scatterX = list.func_150308_e(0);
                    this.scatterY = list.func_150308_e(1);
                }
            } else {
                this.scatterX = this.scatterY = tag.func_74760_g("Scatter");
            }
        }
        if (tag.func_74764_b("ScatterY")) {
            this.scatterY = tag.func_74760_g("ScatterY");
        }
        if (tag.func_74764_b("Launch")) {
            this.launch = tag.func_74767_n("Launch");
        }
        if (tag.func_74764_b("UseInventoryMorph")) {
            this.useInventoryMorph = tag.func_74767_n("UseInventoryMorph");
        }
        if (tag.func_74764_b("UseReloading")) {
            this.useReloading = tag.func_74767_n("UseReloading");
        }
        if (tag.func_74764_b("Target")) {
            this.useTarget = tag.func_74767_n("Target");
        }
        if (tag.func_74764_b("AmmoStack")) {
            this.ammoStack = new ItemStack(tag.func_74775_l("AmmoStack"));
        }
        this.projectileMorph = this.create(tag, "Projectile");
        if (tag.func_74764_b("TickCommand")) {
            this.tickCommand = tag.func_74779_i("TickCommand");
        }
        if (tag.func_74764_b("MeleeCommand")) {
            this.meleeCommand = tag.func_74779_i("MeleeCommand");
        }
        if (tag.func_74764_b("DestroyCommand")) {
            this.destroyCommand = tag.func_74779_i("DestroyCommand");
        }
        if (tag.func_74764_b("ReloadCommand")) {
            this.reloadCommand = tag.func_74779_i("ReloadCommand");
        }
        if (tag.func_74764_b("ZoomOnCommand")) {
            this.zoomOnCommand = tag.func_74779_i("ZoomOnCommand");
        }
        if (tag.func_74764_b("ZoomOffCommand")) {
            this.zoomOffCommand = tag.func_74779_i("ZoomOffCommand");
        }
        if (tag.func_74764_b("Ticking")) {
            this.ticking = tag.func_74762_e("Ticking");
        }
        if (tag.func_74764_b("StoredAmmo")) {
            this.storedAmmo = tag.func_74762_e("StoredAmmo");
        }
        if (tag.func_74764_b("ReloadingTime")) {
            this.reloadingTime = tag.func_74762_e("ReloadingTime");
        }
        if (tag.func_74764_b("StoredShotDelay")) {
            this.storedShotDelay = tag.func_74763_f("StoredShotDelay");
        }
        if (tag.func_74764_b("ShotDelay")) {
            this.shotDelay = tag.func_74763_f("ShotDelay");
        }
        if (tag.func_74764_b("Ammo")) {
            this.ammo = tag.func_74762_e("Ammo");
        }
        if (tag.func_74764_b("LifeSpan")) {
            this.lifeSpan = tag.func_74762_e("LifeSpan");
        }
        if (tag.func_74764_b("Yaw")) {
            this.yaw = tag.func_74767_n("Yaw");
        }
        if (tag.func_74764_b("UseZoomOverlayMorph")) {
            this.useZoomOverlayMorph = tag.func_74767_n("UseZoomOverlayMorph");
        }
        if (tag.func_74764_b("HideHandsOnZoom")) {
            this.hideHandsOnZoom = tag.func_74767_n("HideHandsOnZoom");
        }
        if (tag.func_74764_b("HideCrosshairOnZoom")) {
            this.hideCrosshairOnZoom = tag.func_74767_n("HideCrosshairOnZoom");
        }
        if (tag.func_74764_b("ShootWhenHeld")) {
            this.shootWhenHeld = tag.func_74767_n("ShootWhenHeld");
        }
        if (tag.func_74764_b("ArmPose")) {
            this.enableArmsShootingPose = tag.func_74767_n("ArmPose");
        }
        if (tag.func_74764_b("ArmPoseAlways")) {
            this.alwaysArmsShootingPose = tag.func_74767_n("ArmPoseAlways");
        }
        if (tag.func_74764_b("PreventLeftClick")) {
            this.preventLeftClick = tag.func_74767_n("PreventLeftClick");
        }
        if (tag.func_74764_b("PreventRightClick")) {
            this.preventRightClick = tag.func_74767_n("PreventRightClick");
        }
        if (tag.func_74764_b("PreventEntityAttack")) {
            this.preventEntityAttack = tag.func_74767_n("PreventEntityAttack");
        }
        if (tag.func_74764_b("Pitch")) {
            this.pitch = tag.func_74767_n("Pitch");
        }
        if (tag.func_74764_b("Sequencer")) {
            this.sequencer = tag.func_74767_n("Sequencer");
        }
        if (tag.func_74764_b("Random")) {
            this.random = tag.func_74767_n("Random");
        }
        if (tag.func_74764_b("HX")) {
            this.hitboxX = tag.func_74760_g("HX");
        }
        if (tag.func_74764_b("HY")) {
            this.hitboxY = tag.func_74760_g("HY");
        }
        if (tag.func_74764_b("Speed")) {
            this.speed = tag.func_74760_g("Speed");
        }
        if (tag.func_74764_b("Zoom")) {
            this.zoomFactor = tag.func_74760_g("Zoom");
        }
        if (tag.func_74764_b("RecoilMinX")) {
            this.recoilXMin = tag.func_74760_g("RecoilMinX");
        }
        if (tag.func_74764_b("ShootingOffsetX")) {
            this.shootingOffsetX = tag.func_74760_g("ShootingOffsetX");
        }
        if (tag.func_74764_b("MouseZoom")) {
            this.mouseZoom = tag.func_74760_g("MouseZoom");
        }
        if (tag.func_74764_b("MeleeDamage")) {
            this.meleeDamage = tag.func_74760_g("MeleeDamage");
        }
        if (tag.func_74764_b("ShootingOffsetY")) {
            this.shootingOffsetY = tag.func_74760_g("ShootingOffsetY");
        }
        if (tag.func_74764_b("ShootingOffsetZ")) {
            this.shootingOffsetZ = tag.func_74760_g("ShootingOffsetZ");
        }
        if (tag.func_74764_b("StaticRecoil")) {
            this.staticRecoil = tag.func_74767_n("StaticRecoil");
        }
        if (tag.func_74764_b("RecoilMaxX")) {
            this.recoilXMax = tag.func_74760_g("RecoilMaxX");
        }
        if (tag.func_74764_b("RecoilMinY")) {
            this.recoilYMin = tag.func_74760_g("RecoilMinY");
        }
        if (tag.func_74764_b("RecoilMaxY")) {
            this.recoilYMax = tag.func_74760_g("RecoilMaxY");
        }
        if (tag.func_74764_b("Friction")) {
            this.friction = tag.func_74760_g("Friction");
        }
        if (tag.func_74764_b("Gravity")) {
            this.gravity = tag.func_74760_g("Gravity");
        }
        if (tag.func_74764_b("Durability")) {
            this.durability = tag.func_74762_e("Durability");
        }
        if (tag.func_74764_b("StoredDurability")) {
            this.storedDurability = tag.func_74762_e("StoredDurability");
        }
        if (tag.func_74764_b("FadeIn")) {
            this.fadeIn = tag.func_74762_e("FadeIn");
        }
        if (tag.func_74764_b("FadeOut")) {
            this.fadeOut = tag.func_74762_e("FadeOut");
        }
        this.impactMorph = this.create(tag, "Impact");
        if (tag.func_74764_b("ImpactCommand")) {
            this.impactCommand = tag.func_74779_i("ImpactCommand");
        }
        if (tag.func_74764_b("ImpactEntityCommand")) {
            this.impactEntityCommand = tag.func_74779_i("ImpactEntityCommand");
        }
        if (tag.func_74764_b("ImpactDelay")) {
            this.impactDelay = tag.func_74762_e("ImpactDelay");
        }
        if (tag.func_74764_b("Vanish")) {
            this.vanish = tag.func_74767_n("Vanish");
        }
        if (tag.func_74764_b("Bounce")) {
            this.bounce = tag.func_74767_n("Bounce");
        }
        if (tag.func_74764_b("Stick")) {
            this.sticks = tag.func_74767_n("Stick");
        }
        if (tag.func_74764_b("Hits")) {
            this.hits = tag.func_74762_e("Hits");
        }
        if (tag.func_74764_b("State")) {
            this.state = ItemGun.GunState.values()[tag.func_74762_e("State")];
        }
        if (tag.func_74764_b("Damage")) {
            this.damage = tag.func_74760_g("Damage");
        }
        if (tag.func_74764_b("KnockbackH")) {
            this.knockbackHorizontal = tag.func_74760_g("KnockbackH");
        }
        if (tag.func_74764_b("KnockbackV")) {
            this.knockbackVertical = tag.func_74760_g("KnockbackV");
        }
        if (tag.func_74764_b("BFactor")) {
            this.bounceFactor = tag.func_74760_g("BFactor");
        }
        if (tag.func_74764_b("VanishCommand")) {
            this.vanishCommand = tag.func_74779_i("VanishCommand");
        }
        if (tag.func_74764_b("VDelay")) {
            this.vanishDelay = tag.func_74762_e("VDelay");
        }
        if (tag.func_74764_b("Penetration")) {
            this.penetration = tag.func_74760_g("Penetration");
        }
        if (tag.func_74764_b("IBlocks")) {
            this.ignoreBlocks = tag.func_74767_n("IBlocks");
        }
        if (tag.func_74764_b("IEntities")) {
            this.ignoreEntities = tag.func_74767_n("IEntities");
        }
        if (tag.func_74764_b("Gun")) {
            this.gunTransform.fromNBT(tag.func_74775_l("Gun"));
        }
        if (tag.func_74764_b("GunFirstPerson")) {
            this.gunTransformFirstPerson.fromNBT(tag.func_74775_l("GunFirstPerson"));
        }
        if (tag.func_74764_b("Transform")) {
            this.projectileTransform.fromNBT(tag.func_74775_l("Transform"));
        }
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            if (this.state == ItemGun.GunState.RELOADING) {
                this.current.set(MorphUtils.copy((AbstractMorph)this.reloadMorph));
            } else {
                this.current.set(MorphUtils.copy((AbstractMorph)this.defaultMorph));
            }
            this.currentHands.set(MorphUtils.copy((AbstractMorph)this.handsMorph));
            this.currentZoomOverlay.set(MorphUtils.copy((AbstractMorph)this.zoomOverlayMorph));
            this.currentInventory.set(MorphUtils.copy((AbstractMorph)this.inventoryMorph));
            this.currentCrosshair.set(MorphUtils.copy((AbstractMorph)this.crosshairMorph));
        }
    }

    private AbstractMorph create(NBTTagCompound tag, String key) {
        if (tag.func_150297_b(key, 10)) {
            return MorphManager.INSTANCE.morphFromNBT(tag.func_74775_l(key));
        }
        return null;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.defaultMorph != null) {
            tag.func_74782_a("Morph", (NBTBase)this.to(this.defaultMorph));
        }
        if (this.firingMorph != null) {
            tag.func_74782_a("Fire", (NBTBase)this.to(this.firingMorph));
        }
        if (!this.fireCommand.isEmpty()) {
            tag.func_74778_a("FireCommand", this.fireCommand);
        }
        if (this.delay != 0) {
            tag.func_74768_a("Delay", this.delay);
        }
        if (this.projectiles != 1) {
            tag.func_74768_a("Projectiles", this.projectiles);
        }
        if (this.scatterX != 0.0f || this.scatterY != 0.0f) {
            NBTTagList scatter = new NBTTagList();
            scatter.func_74742_a((NBTBase)new NBTTagFloat(this.scatterX));
            scatter.func_74742_a((NBTBase)new NBTTagFloat(this.scatterY));
            tag.func_74782_a("Scatter", (NBTBase)scatter);
        }
        if (this.launch) {
            tag.func_74757_a("Launch", this.launch);
        }
        if (this.useTarget) {
            tag.func_74757_a("Target", this.useTarget);
        }
        if (!this.ammoStack.func_190926_b()) {
            tag.func_74782_a("AmmoStack", (NBTBase)this.ammoStack.func_77955_b(new NBTTagCompound()));
        }
        if (!this.staticRecoil) {
            tag.func_74757_a("StaticRecoil", this.staticRecoil);
        }
        if (this.recoilXMin != 0.0f) {
            tag.func_74776_a("RecoilMinX", this.recoilXMin);
        }
        if (this.recoilXMax != 0.0f) {
            tag.func_74776_a("RecoilMaxX", this.recoilXMax);
        }
        if (this.recoilYMin != 0.0f) {
            tag.func_74776_a("RecoilMinY", this.recoilYMin);
        }
        if (this.recoilYMax != 0.0f) {
            tag.func_74776_a("RecoilMaxY", this.recoilYMax);
        }
        if (this.enableArmsShootingPose) {
            tag.func_74757_a("ArmPose", this.enableArmsShootingPose);
        }
        if (this.alwaysArmsShootingPose) {
            tag.func_74757_a("ArmPoseAlways", this.alwaysArmsShootingPose);
        }
        if (this.shootingOffsetX != 0.0f) {
            tag.func_74776_a("ShootingOffsetX", this.shootingOffsetX);
        }
        if (this.shootingOffsetY != 0.0f) {
            tag.func_74776_a("ShootingOffsetY", this.shootingOffsetY);
        }
        if (this.shootingOffsetZ != 0.0f) {
            tag.func_74776_a("ShootingOffsetZ", this.shootingOffsetZ);
        }
        if (this.inventoryMorph != null) {
            tag.func_74782_a("InventoryMorph", (NBTBase)this.to(this.inventoryMorph));
        }
        if (this.crosshairMorph != null) {
            tag.func_74782_a("CrosshairMorph", (NBTBase)this.to(this.crosshairMorph));
        }
        if (this.handsMorph != null) {
            tag.func_74782_a("HandsMorph", (NBTBase)this.to(this.handsMorph));
        }
        if (this.reloadMorph != null) {
            tag.func_74782_a("ReloadMorph", (NBTBase)this.to(this.reloadMorph));
        }
        if (this.zoomOverlayMorph != null) {
            tag.func_74782_a("ZoomOverlayMorph", (NBTBase)this.to(this.zoomOverlayMorph));
        }
        if (this.hideCrosshairOnZoom) {
            tag.func_74757_a("HideCrosshairOnZoom", this.hideCrosshairOnZoom);
        }
        if (this.useInventoryMorph) {
            tag.func_74757_a("UseInventoryMorph", this.useInventoryMorph);
        }
        if (this.hideHandsOnZoom) {
            tag.func_74757_a("HideHandsOnZoom", this.hideHandsOnZoom);
        }
        if (this.useZoomOverlayMorph) {
            tag.func_74757_a("UseZoomOverlayMorph", this.useZoomOverlayMorph);
        }
        if (this.zoomFactor != 0.0f) {
            tag.func_74776_a("Zoom", this.zoomFactor);
        }
        if (this.ammo != 1) {
            tag.func_74768_a("Ammo", this.ammo);
        }
        if (this.useReloading) {
            tag.func_74757_a("UseReloading", this.useReloading);
        }
        if (this.reloadingTime != 0L) {
            tag.func_74772_a("ReloadingTime", this.reloadingTime);
        }
        if (this.shotDelay != 0L) {
            tag.func_74772_a("ShotDelay", this.shotDelay);
        }
        if (!this.shootWhenHeld) {
            tag.func_74757_a("ShootWhenHeld", this.shootWhenHeld);
        }
        if (!this.destroyCommand.isEmpty()) {
            tag.func_74778_a("DestroyCommand", this.destroyCommand);
        }
        if (!this.meleeCommand.isEmpty()) {
            tag.func_74778_a("MeleeCommand", this.meleeCommand);
        }
        if (!this.reloadCommand.isEmpty()) {
            tag.func_74778_a("ReloadCommand", this.reloadCommand);
        }
        if (!this.zoomOnCommand.isEmpty()) {
            tag.func_74778_a("ZoomOnCommand", this.zoomOnCommand);
        }
        if (!this.zoomOffCommand.isEmpty()) {
            tag.func_74778_a("ZoomOffCommand", this.zoomOffCommand);
        }
        if (this.meleeDamage != 0.0f) {
            tag.func_74776_a("MeleeDamage", this.meleeDamage);
        }
        if (this.mouseZoom != 0.5f) {
            tag.func_74776_a("MouseZoom", this.mouseZoom);
        }
        if (this.durability != 0) {
            tag.func_74768_a("Durability", this.durability);
        }
        if (this.preventLeftClick) {
            tag.func_74757_a("PreventLeftClick", this.preventLeftClick);
        }
        if (this.preventRightClick) {
            tag.func_74757_a("PreventRightClick", this.preventRightClick);
        }
        if (this.preventEntityAttack) {
            tag.func_74757_a("PreventEntityAttack", this.preventEntityAttack);
        }
        if (this.storedAmmo != 1) {
            tag.func_74768_a("StoredAmmo", this.storedAmmo);
        }
        if (this.storedReloadingTime != 0L) {
            tag.func_74772_a("StoredReloadingTime", this.storedReloadingTime);
        }
        if (this.storedShotDelay != 0L) {
            tag.func_74772_a("StoredShotDelay", this.storedShotDelay);
        }
        if (this.storedDurability != 0) {
            tag.func_74768_a("StoredDurability", this.storedDurability);
        }
        if (this.state != ItemGun.GunState.READY_TO_SHOOT) {
            tag.func_74768_a("State", this.state.ordinal());
        }
        if (this.projectileMorph != null) {
            tag.func_74782_a("Projectile", (NBTBase)this.to(this.projectileMorph));
        }
        if (!this.tickCommand.isEmpty()) {
            tag.func_74778_a("TickCommand", this.tickCommand);
        }
        if (this.ticking != 0) {
            tag.func_74768_a("Ticking", this.ticking);
        }
        if (this.lifeSpan != 200) {
            tag.func_74768_a("LifeSpan", this.lifeSpan);
        }
        if (!this.yaw) {
            tag.func_74757_a("Yaw", this.yaw);
        }
        if (!this.pitch) {
            tag.func_74757_a("Pitch", this.pitch);
        }
        if (this.sequencer) {
            tag.func_74757_a("Sequencer", this.sequencer);
        }
        if (this.random) {
            tag.func_74757_a("Random", this.random);
        }
        if (this.hitboxX != 0.25f) {
            tag.func_74776_a("HX", this.hitboxX);
        }
        if (this.hitboxY != 0.25f) {
            tag.func_74776_a("HY", this.hitboxY);
        }
        if (this.speed != 1.0f) {
            tag.func_74776_a("Speed", this.speed);
        }
        if (this.friction != 0.99f) {
            tag.func_74776_a("Friction", this.friction);
        }
        if (this.gravity != 0.03f) {
            tag.func_74776_a("Gravity", this.gravity);
        }
        if (this.fadeIn != 10) {
            tag.func_74768_a("FadeIn", this.fadeIn);
        }
        if (this.fadeOut != 10) {
            tag.func_74768_a("FadeOut", this.fadeOut);
        }
        if (this.impactMorph != null) {
            tag.func_74782_a("Impact", (NBTBase)this.to(this.impactMorph));
        }
        if (!this.impactCommand.isEmpty()) {
            tag.func_74778_a("ImpactCommand", this.impactCommand);
        }
        if (!this.impactEntityCommand.isEmpty()) {
            tag.func_74778_a("ImpactEntityCommand", this.impactEntityCommand);
        }
        if (this.impactDelay != 0) {
            tag.func_74768_a("ImpactDelay", this.impactDelay);
        }
        if (!this.vanish) {
            tag.func_74757_a("Vanish", this.vanish);
        }
        if (this.bounce) {
            tag.func_74757_a("Bounce", this.bounce);
        }
        if (this.sticks) {
            tag.func_74757_a("Stick", this.sticks);
        }
        if (this.hits != 1) {
            tag.func_74768_a("Hits", this.hits);
        }
        if (this.damage != 0.0f) {
            tag.func_74776_a("Damage", this.damage);
        }
        if (this.knockbackHorizontal != 0.0f) {
            tag.func_74776_a("KnockbackH", this.knockbackHorizontal);
        }
        if (this.knockbackVertical != 0.0f) {
            tag.func_74776_a("KnockbackV", this.knockbackVertical);
        }
        if (this.bounceFactor != 1.0f) {
            tag.func_74776_a("BFactor", this.bounceFactor);
        }
        if (!this.vanishCommand.isEmpty()) {
            tag.func_74778_a("VanishCommand", this.vanishCommand);
        }
        if (this.vanishDelay != 0) {
            tag.func_74768_a("VDelay", this.vanishDelay);
        }
        if (this.penetration != 0.0f) {
            tag.func_74776_a("Penetration", this.penetration);
        }
        if (this.ignoreBlocks) {
            tag.func_74757_a("IBlocks", this.ignoreBlocks);
        }
        if (this.ignoreEntities) {
            tag.func_74757_a("IEntities", this.ignoreEntities);
        }
        if (!this.gunTransform.isDefault()) {
            tag.func_74782_a("Gun", (NBTBase)this.gunTransform.toNBT());
        }
        if (!this.gunTransformFirstPerson.isDefault()) {
            tag.func_74782_a("GunFirstPerson", (NBTBase)this.gunTransformFirstPerson.toNBT());
        }
        if (!this.projectileTransform.isDefault()) {
            tag.func_74782_a("Transform", (NBTBase)this.projectileTransform.toNBT());
        }
        return tag;
    }

    private NBTTagCompound to(AbstractMorph morph) {
        NBTTagCompound tag = new NBTTagCompound();
        morph.toNBT(tag);
        return tag;
    }
}

