/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.commands.record;

import java.util.List;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.commands.CommandRecord;
import mchorse.blockbuster.commands.record.SubCommandRecordBase;
import mchorse.blockbuster.recording.RecordUtils;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.recording.data.Record;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.Vec3d;

public class SubCommandRecordOrigin
extends SubCommandRecordBase {
    public String func_71517_b() {
        return "origin";
    }

    public String func_71518_a(ICommandSender sender) {
        return "blockbuster.commands.record.origin";
    }

    public String getSyntax() {
        return "{l}{6}/{r}record {8}origin{r} {7}<filename> [rotation] [x] [y] [z]{r}";
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String filename = args[0];
        Vec3d position = sender.func_174791_d();
        Record record = CommandRecord.getRecord(filename);
        double x = position.field_72450_a;
        double y = position.field_72448_b;
        double z = position.field_72449_c;
        double rotation = args.length >= 2 ? CommandBase.func_175765_c((String)args[1]) : 0.0;
        double firstX = 0.0;
        double firstY = 0.0;
        double firstZ = 0.0;
        int i = 0;
        for (Frame frame : record.frames) {
            if (i == 0) {
                firstX = frame.x;
                firstY = frame.y;
                firstZ = frame.z;
                if (args.length >= 5) {
                    x = CommandBase.func_175761_b((double)firstX, (String)args[2], (boolean)false);
                    y = CommandBase.func_175761_b((double)firstY, (String)args[3], (boolean)false);
                    z = CommandBase.func_175761_b((double)firstZ, (String)args[4], (boolean)false);
                }
            }
            double frameX = frame.x - firstX;
            double frameY = frame.y - firstY;
            double frameZ = frame.z - firstZ;
            if (rotation != 0.0) {
                float cos = (float)Math.cos(rotation / 180.0 * Math.PI);
                float sin = (float)Math.sin(rotation / 180.0 * Math.PI);
                double xx = frameX * (double)cos - frameZ * (double)sin;
                double zz = frameX * (double)sin + frameZ * (double)cos;
                frameX = xx;
                frameZ = zz;
                frame.yaw = (float)((double)frame.yaw + rotation);
                frame.yawHead = (float)((double)frame.yawHead + rotation);
                if (frame.hasBodyYaw) {
                    frame.bodyYaw = (float)((double)frame.bodyYaw + rotation);
                }
            }
            frame.x = x + frameX;
            frame.y = y + frameY;
            frame.z = z + frameZ;
            ++i;
        }
        for (List list : record.actions) {
            if (list == null || list.isEmpty()) continue;
            for (Action action : list) {
                action.changeOrigin(rotation, x, y, z, firstX, firstY, firstZ);
            }
        }
        try {
            RecordUtils.saveRecord(record);
            Blockbuster.l10n.success(sender, "record.changed_origin", new Object[]{args[0], firstX, firstY, firstZ, x, y, z});
        }
        catch (Exception e) {
            e.printStackTrace();
            Blockbuster.l10n.error(sender, "record.couldnt_save", new Object[]{args[1]});
        }
    }
}

