/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.commands.record;

import java.util.ArrayList;
import java.util.List;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.commands.CommandRecord;
import mchorse.blockbuster.commands.record.SubCommandRecordBase;
import mchorse.blockbuster.recording.RecordUtils;
import mchorse.blockbuster.recording.actions.Action;
import mchorse.blockbuster.recording.actions.MorphAction;
import mchorse.blockbuster.recording.data.Record;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;

public class SubCommandRecordMerge
extends SubCommandRecordBase {
    public String func_71517_b() {
        return "merge";
    }

    public String func_71518_a(ICommandSender sender) {
        return "blockbuster.commands.record.merge";
    }

    public String getSyntax() {
        return "{l}{6}/{r}record {8}merge{r} {7}<source> <destination> [morph_only]{r}";
    }

    @Override
    public int getRequiredArgs() {
        return 2;
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Record src = CommandRecord.getRecord(args[0]);
        Record dst = CommandRecord.getRecord(args[1]);
        boolean morph = false;
        if (args.length > 2) {
            morph = CommandBase.func_180527_d((String)args[2]);
        }
        int size = Math.min(src.actions.size(), dst.actions.size());
        for (int i = 0; i < size && i < dst.actions.size(); ++i) {
            List<Action> srcActions = src.actions.get(i);
            List<Action> dstActions = dst.actions.get(i);
            if (srcActions == null) continue;
            for (Action action : srcActions) {
                if (morph && !(action instanceof MorphAction)) continue;
                if (dstActions == null) {
                    dstActions = new ArrayList<Action>();
                    dst.actions.set(i, dstActions);
                }
                dstActions.add(action);
            }
        }
        try {
            RecordUtils.saveRecord(dst);
            Blockbuster.l10n.success(sender, "record.merge", new Object[]{args[0], args[1]});
        }
        catch (Exception e) {
            e.printStackTrace();
            Blockbuster.l10n.error(sender, "record.couldnt_save", new Object[]{args[1]});
        }
    }
}

