/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.commands.record;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.commands.CommandRecord;
import mchorse.blockbuster.commands.record.SubCommandRecordBase;
import mchorse.blockbuster.commands.record.SubCommandRecordClean;
import mchorse.blockbuster.recording.RecordUtils;
import mchorse.blockbuster.recording.data.Record;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class SubCommandRecordApply
extends SubCommandRecordBase {
    public String func_71517_b() {
        return "apply";
    }

    public String func_71518_a(ICommandSender sender) {
        return "blockbuster.commands.record.apply";
    }

    public String getSyntax() {
        return "{l}{6}/{r}record {8}apply{r} {7}<target> <source> <properties> [relative] [from] [to]{r}";
    }

    @Override
    public int getRequiredArgs() {
        return 3;
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        boolean relative;
        String target = args[0];
        String source = args[1];
        ArrayList<String> properties = new ArrayList<String>();
        if (args[2].contains(",")) {
            properties.addAll(Arrays.asList(args[2].split(",")));
        } else {
            properties.add(args[2]);
        }
        Record targetRecord = CommandRecord.getRecord(target);
        Record sourceRecord = CommandRecord.getRecord(source);
        ArrayList<String> newProperties = new ArrayList<String>();
        for (String property : properties) {
            if (property.equalsIgnoreCase("head")) {
                newProperties.addAll((Collection<String>)ImmutableList.of((Object)"yaw", (Object)"yaw_head", (Object)"pitch"));
                continue;
            }
            if (property.equalsIgnoreCase("position")) {
                newProperties.addAll((Collection<String>)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"));
                continue;
            }
            if (!SubCommandRecordClean.PROPERTIES.contains(property)) continue;
            newProperties.add(property);
        }
        if (newProperties.isEmpty()) {
            throw new CommandException("record.wrong_apply_property", new Object[]{String.join((CharSequence)", ", properties)});
        }
        int start = 0;
        int end = Math.min(targetRecord.frames.size() - 1, sourceRecord.frames.size() - 1);
        boolean bl = relative = args.length >= 4 && CommandBase.func_180527_d((String)args[3]);
        if (args.length >= 5) {
            start = CommandBase.func_175764_a((String)args[4], (int)start, (int)end);
        }
        if (args.length >= 6) {
            end = CommandBase.func_175764_a((String)args[5], (int)start, (int)end);
        }
        for (String property : newProperties) {
            this.apply(property, targetRecord, sourceRecord, relative, start, end);
        }
        try {
            RecordUtils.saveRecord(targetRecord);
            Blockbuster.l10n.success(sender, "record.apply", new Object[]{target, String.join((CharSequence)", ", newProperties), source, start, end});
        }
        catch (Exception e) {
            e.printStackTrace();
            Blockbuster.l10n.error(sender, "record.couldnt_save", new Object[]{args[1]});
        }
    }

    private void apply(String property, Record targetRecord, Record sourceRecord, boolean relative, int start, int end) {
        double firstOriginal = SubCommandRecordClean.get(property, sourceRecord.frames.get(start));
        for (int i = start; i <= end; ++i) {
            double original = SubCommandRecordClean.get(property, sourceRecord.frames.get(i));
            double value = SubCommandRecordClean.get(property, targetRecord.frames.get(i));
            SubCommandRecordClean.set(property, targetRecord.frames.get(i), relative ? value + (original - firstOriginal) : original);
        }
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 3) {
            ArrayList<String> props = new ArrayList<String>(SubCommandRecordClean.PROPERTIES);
            props.add("head");
            props.add("position");
            return SubCommandRecordApply.func_175762_a((String[])args, props);
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

