/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.commands.model;

import java.io.File;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.ClientProxy;
import mchorse.blockbuster.api.loaders.lazy.IModelLazyLoader;
import mchorse.blockbuster.api.loaders.lazy.ModelLazyLoaderJSON;
import mchorse.blockbuster.api.loaders.lazy.ModelLazyLoaderOBJ;
import mchorse.blockbuster.api.loaders.lazy.ModelLazyLoaderVOX;
import mchorse.blockbuster.commands.BBCommandBase;
import mchorse.mclib.utils.resources.RLUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;

public class SubCommandModelReport
extends BBCommandBase {
    public String func_71517_b() {
        return "report";
    }

    public String func_71518_a(ICommandSender sender) {
        return "blockbuster.commands.model.report";
    }

    public String getSyntax() {
        return "{l}{6}/{r}model {8}report{r}";
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        File models = new File(ClientProxy.configFile, "models");
        StringBuilder output = new StringBuilder();
        output.append("Models folder skins report:\n\n");
        this.processRecursively(output, models, models, "", "", false);
        GuiScreen.func_146275_d((String)output.toString().trim());
        Blockbuster.l10n.success(sender, "commands.model_report", new Object[0]);
    }

    private void processRecursively(StringBuilder output, File root, File models, String prefix, String indent, boolean isModel) {
        File[] files;
        if (!models.isDirectory()) {
            return;
        }
        for (File file : files = models.listFiles()) {
            if (!file.isFile()) continue;
            String name = file.getName();
            String aux = "";
            boolean obj = name.endsWith(".obj");
            boolean vox = name.endsWith(".vox");
            if (!isModel && (obj || name.equals("model.json") || vox)) {
                IModelLazyLoader loader = Blockbuster.proxy.pack.models.get(prefix);
                if (loader instanceof ModelLazyLoaderOBJ && obj) {
                    isModel = true;
                    aux = aux + ", loaded OBJ";
                } else if (loader instanceof ModelLazyLoaderVOX && vox) {
                    isModel = true;
                    aux = aux + ", loaded VOX";
                } else if (loader != null && loader.getClass() == ModelLazyLoaderJSON.class) {
                    isModel = true;
                    aux = aux + ", loaded JSON";
                }
            }
            if (name.endsWith(".png") || name.endsWith(".jpg") || name.endsWith(".jpeg") || name.endsWith(".gif")) {
                ResourceLocation location = RLUtils.create((String)("b.a:" + (prefix.isEmpty() ? "" : prefix + "/") + name));
                ITextureObject texture = Minecraft.func_71410_x().field_71446_o.func_110581_b(location);
                if (texture == TextureUtil.field_111001_a) {
                    aux = aux + ", loaded but missing";
                } else if (texture != null) {
                    aux = aux + ", loaded";
                }
            }
            output.append(indent);
            output.append(name);
            output.append(aux);
            output.append("\n");
        }
        for (File file : files) {
            if (!file.isDirectory()) continue;
            output.append(indent);
            output.append(file.getName());
            output.append("/\n");
            this.processRecursively(output, root, file, prefix.isEmpty() ? file.getName() : prefix + "/" + file.getName(), indent + "    ", isModel);
        }
    }
}

