/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.commands.model;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.ClientProxy;
import mchorse.blockbuster.commands.BBCommandBase;
import mchorse.mclib.commands.SubCommandBase;
import mchorse.mclib.utils.files.GlobalTree;
import mchorse.mclib.utils.files.entries.AbstractEntry;
import mchorse.mclib.utils.files.entries.FolderEntry;
import mchorse.mclib.utils.resources.RLUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.io.FilenameUtils;

public class SubCommandModelConvertSkin
extends BBCommandBase {
    public String func_71517_b() {
        return "convert";
    }

    public String func_71518_a(ICommandSender sender) {
        return "blockbuster.commands.model.convert";
    }

    public String getSyntax() {
        return "{l}{6}/{r}model {8}convert{r} {7}<steve|fred> <skin>{r}";
    }

    public int getRequiredArgs() {
        return 2;
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String model = args[0];
        String skin = String.join((CharSequence)" ", SubCommandBase.dropFirstArgument((String[])args));
        if (!model.equals("steve") && !model.equals("fred")) {
            throw new CommandException("blockbuster.error.commands.convert_model", new Object[]{model});
        }
        String path = model + "/" + (skin.contains(".") || skin.contains("/") ? "skins/" + skin : skin);
        ResourceLocation location = RLUtils.create((String)"b.a", (String)path);
        try {
            Graphics graphics;
            BufferedImage target;
            boolean one;
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(location);
            BufferedImage image = ImageIO.read(resource.func_110527_b());
            int w = image.getWidth();
            int h = image.getHeight();
            boolean bl = one = w == h;
            if (w % 64 != 0 || h % (one ? 64 : 32) != 0 || !one && w != h * 2) {
                throw new CommandException("blockbuster.error.commands.convert_skin_size", new Object[]{w, h});
            }
            if (model.equals("steve")) {
                target = new BufferedImage(w, h * 2, 2);
                graphics = target.getGraphics();
                float s = (float)w / 64.0f;
                graphics.drawImage(image, 0, 0, null);
                graphics.setColor(new Color(0, 0, 0, 0));
                graphics.fillRect(0, h / 2, w, h / 2);
                this.drawImage(graphics, target, 24.0f, 48.0f, 20.0f, 52.0f, 4.0f, 16.0f, 8.0f, 20.0f, s);
                this.drawImage(graphics, target, 28.0f, 48.0f, 24.0f, 52.0f, 8.0f, 16.0f, 12.0f, 20.0f, s);
                this.drawImage(graphics, target, 20.0f, 52.0f, 16.0f, 64.0f, 8.0f, 20.0f, 12.0f, 32.0f, s);
                this.drawImage(graphics, target, 24.0f, 52.0f, 20.0f, 64.0f, 4.0f, 20.0f, 8.0f, 32.0f, s);
                this.drawImage(graphics, target, 28.0f, 52.0f, 24.0f, 64.0f, 0.0f, 20.0f, 4.0f, 32.0f, s);
                this.drawImage(graphics, target, 32.0f, 52.0f, 28.0f, 64.0f, 12.0f, 20.0f, 16.0f, 32.0f, s);
                this.drawImage(graphics, target, 40.0f, 48.0f, 36.0f, 52.0f, 44.0f, 16.0f, 48.0f, 20.0f, s);
                this.drawImage(graphics, target, 44.0f, 48.0f, 40.0f, 52.0f, 48.0f, 16.0f, 52.0f, 20.0f, s);
                this.drawImage(graphics, target, 36.0f, 52.0f, 32.0f, 64.0f, 48.0f, 20.0f, 52.0f, 32.0f, s);
                this.drawImage(graphics, target, 40.0f, 52.0f, 36.0f, 64.0f, 44.0f, 20.0f, 48.0f, 32.0f, s);
                this.drawImage(graphics, target, 44.0f, 52.0f, 40.0f, 64.0f, 40.0f, 20.0f, 44.0f, 32.0f, s);
                this.drawImage(graphics, target, 48.0f, 52.0f, 44.0f, 64.0f, 52.0f, 20.0f, 56.0f, 32.0f, s);
            } else {
                target = new BufferedImage(w, h / 2, 2);
                graphics = target.getGraphics();
                graphics.drawImage(image, 0, 0, null);
            }
            String targetModel = model.equals("steve") ? "fred" : "steve";
            File file = new File(ClientProxy.configFile, "models/" + targetModel + "/skins/" + skin);
            file.mkdirs();
            ImageIO.write((RenderedImage)target, "png", file);
            target.flush();
            image.flush();
        }
        catch (CommandException e) {
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CommandException("blockbuster.error.commands.convert_skin", new Object[]{model, skin, e.getMessage()});
        }
        Blockbuster.l10n.success(sender, "commands.convert_skin", new Object[]{model, skin});
    }

    private void drawImage(Graphics graphics, BufferedImage image, float a1, float a2, float b1, float b2, float c1, float c2, float d1, float d2, float s) {
        graphics.drawImage(image, (int)(a1 * s), (int)(a2 * s), (int)(b1 * s), (int)(b2 * s), (int)(c1 * s), (int)(c2 * s), (int)(d1 * s), (int)(d2 * s), null);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return SubCommandModelConvertSkin.func_71530_a((String[])args, (String[])new String[]{"steve", "fred"});
        }
        if (args.length >= 2 && Arrays.asList("steve", "fred").contains(args[0])) {
            String skin = String.join((CharSequence)" ", SubCommandBase.dropFirstArgument((String[])args));
            String path = "b.a/" + args[0] + "/skins/" + skin;
            FolderEntry skins = GlobalTree.TREE.getByPath(path, null);
            String name = FilenameUtils.getBaseName((String)FilenameUtils.getPathNoEndSeparator((String)path));
            if (skins != null && skins.title.equals(name)) {
                ArrayList<String> strings = new ArrayList<String>();
                String prefix = skin.contains("/") ? skin.substring(0, skin.lastIndexOf("/") + 1) : "";
                for (AbstractEntry entry : skins.getEntries()) {
                    if (entry.title.contains("..")) continue;
                    strings.add(prefix + entry.title);
                }
                return SubCommandModelConvertSkin.func_175762_a((String[])args, strings);
            }
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

