/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.commands;

import java.util.List;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.commands.BBCommandBase;
import mchorse.blockbuster.recording.scene.Scene;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandScene
extends BBCommandBase {
    public String func_71517_b() {
        return "scene";
    }

    public String func_71518_a(ICommandSender sender) {
        return "blockbuster.commands.scene";
    }

    public String getSyntax() {
        return "{l}{6}/{r}scene {8}<play|toggle|stop|loop>{r} {7}<name> [flag]{r}";
    }

    public int func_82362_a() {
        return 2;
    }

    public int getRequiredArgs() {
        return 2;
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2) {
            throw new WrongUsageException(this.func_71518_a(null), new Object[0]);
        }
        String action = args[0];
        String name = args[1];
        Scene scene = CommonProxy.scenes.get(name, sender.func_130014_f_());
        if (scene == null) {
            Blockbuster.l10n.error(sender, "scene.no_scene", new Object[]{name});
            return;
        }
        String play = "scene.play";
        String stop = "scene.stop";
        if (action.equals("play")) {
            if (scene.playing) {
                Blockbuster.l10n.error(sender, "scene.playing", new Object[]{name});
                return;
            }
            scene.startPlayback(0);
            Blockbuster.l10n.success(sender, play, new Object[]{name});
        } else if (action.equals("stop")) {
            if (!scene.playing) {
                Blockbuster.l10n.error(sender, "scene.stopped", new Object[]{name});
                return;
            }
            scene.stopPlayback(true);
            Blockbuster.l10n.success(sender, stop, new Object[]{name});
        } else if (action.equals("loop") && args.length >= 2) {
            scene.loops = CommandBase.func_180527_d((String)args[2]);
            try {
                CommonProxy.scenes.save(scene.getId(), scene);
                Blockbuster.l10n.info(sender, "scene." + (scene.loops ? "looped" : "unlooped"), new Object[0]);
            }
            catch (Exception exception) {}
        } else if (action.equals("toggle")) {
            boolean isPlaying = scene.togglePlayback();
            Blockbuster.l10n.success(sender, isPlaying ? play : stop, new Object[]{name});
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return CommandScene.func_71530_a((String[])args, (String[])new String[]{"play", "stop", "toggle", "loop"});
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

