/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.textures;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import mchorse.blockbuster.utils.mclib.GifFolder;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;

public class GifFrameTexture
extends AbstractTexture {
    public GifFolder file;
    public int index;

    public GifFrameTexture(GifFolder file, int index) {
        this.file = file;
        this.index = index;
    }

    public void func_110551_a(IResourceManager resourceManager) throws IOException {
        this.func_147631_c();
        if (!this.file.exists()) {
            throw new FileNotFoundException(this.file.getFilePath());
        }
        if (!this.tryLoadMultiTex()) {
            TextureUtil.func_110987_a((int)this.func_110552_b(), (BufferedImage)this.file.gif.getFrame(this.index));
        }
    }

    private boolean tryLoadMultiTex() {
        try {
            Class<?> config = Class.forName("Config");
            Method isShaders = config.getMethod("isShaders", new Class[0]);
            if (!Boolean.TRUE.equals(isShaders.invoke(null, new Object[0]))) {
                return false;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return false;
        }
        BufferedImage frame = this.file.gif.getFrame(this.index);
        int width = frame.getWidth();
        int height = frame.getHeight();
        int[] aint = new int[width * height * 3];
        frame.getRGB(0, 0, width, height, aint, 0, width);
        String path = this.file.getFilePath();
        path = path.substring(0, path.length() - 4);
        GifFolder normal = new GifFolder(path + "_n.gif");
        GifFolder specular = new GifFolder(path + "_s.gif");
        if (normal.exists()) {
            frame = normal.gif.getFrame(this.index);
            frame.getRGB(0, 0, width, height, aint, width * height, width);
        } else {
            Arrays.fill(aint, width * height, width * height * 2, -8421377);
        }
        if (specular.exists()) {
            frame = specular.gif.getFrame(this.index);
            frame.getRGB(0, 0, width, height, aint, width * height * 2, width);
        } else {
            Arrays.fill(aint, width * height * 2, width * height * 3, 0);
        }
        try {
            Class<?> shadersTex = Class.forName("net.optifine.shaders.ShadersTex");
            Method getMultiTexID = null;
            Method setupTexture = null;
            for (Method method : shadersTex.getMethods()) {
                if ("getMultiTexID".equals(method.getName())) {
                    getMultiTexID = method;
                    continue;
                }
                if (!"setupTexture".equals(method.getName())) continue;
                setupTexture = method;
            }
            if (getMultiTexID == null || setupTexture == null) {
                return false;
            }
            Object multiTex = getMultiTexID.invoke(null, new Object[]{this});
            setupTexture.invoke(null, multiTex, aint, width, height, false, false);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            return false;
        }
        return true;
    }
}

